/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.AciTargetMatchContext;
import org.opends.server.authorization.dseecompat.EnumTargetOperator;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.SearchFilter;

public class TargetFilter {
    private EnumTargetOperator op = EnumTargetOperator.EQUALITY;
    private SearchFilter filter;

    private TargetFilter(EnumTargetOperator op, SearchFilter filter) {
        this.op = op;
        this.filter = filter;
    }

    public static TargetFilter decode(EnumTargetOperator op, String expr) throws AciException {
        SearchFilter filter;
        try {
            filter = SearchFilter.createFilterFromString(expr);
        }
        catch (DirectoryException ex) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGETFILTERKEYWORD_EXPRESSION.get(expr);
            throw new AciException(message);
        }
        return new TargetFilter(op, filter);
    }

    public boolean isApplicable(AciTargetMatchContext matchCtx) {
        boolean ret = this.matchesFilter(matchCtx.getResourceEntry());
        if (this.op.equals((Object)EnumTargetOperator.NOT_EQUALITY)) {
            ret = !ret;
        }
        return ret;
    }

    private boolean matchesFilter(Entry e) {
        boolean ret;
        try {
            ret = this.filter.matchesEntry(e);
        }
        catch (DirectoryException ex) {
            return false;
        }
        return ret;
    }
}

