/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.regex.Pattern;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumAccessType;
import org.opends.server.authorization.dseecompat.EnumRight;

public class Permission {
    private EnumAccessType accessType = null;
    private int rights;
    private static final String separatorToken = ",";
    private static final String rightsRegex = "\\s*(\\w+)\\s*(,\\s*(\\w+)\\s*)*";

    private Permission(String accessType, String rights) throws AciException {
        String[] rightsStr;
        this.accessType = EnumAccessType.decode(accessType);
        if (this.accessType == null) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_ACCESS_TYPE_VERSION.get(accessType);
            throw new AciException(message);
        }
        if (!Pattern.matches(rightsRegex, rights)) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_RIGHTS_SYNTAX.get(rights);
            throw new AciException(message);
        }
        Pattern separatorPattern = Pattern.compile(separatorToken);
        for (String r : rightsStr = separatorPattern.split(rights.replaceAll("\\s", ""))) {
            EnumRight right = EnumRight.decode(r);
            if (right != null) {
                this.rights |= EnumRight.getMask(right);
                continue;
            }
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_RIGHTS_KEYWORD.get(rights);
            throw new AciException(message);
        }
    }

    public static Permission decode(String accessType, String rights) throws AciException {
        return new Permission(accessType, rights);
    }

    public boolean hasAccessType(EnumAccessType accessType) {
        return this.accessType == accessType;
    }

    public boolean hasRights(int rights) {
        return (this.rights & rights) != 0;
    }
}

