/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.authorization.dseecompat.Aci;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.AciTargetMatchContext;
import org.opends.server.authorization.dseecompat.EnumTargetKeyword;
import org.opends.server.authorization.dseecompat.EnumTargetOperator;
import org.opends.server.authorization.dseecompat.ExtOp;
import org.opends.server.authorization.dseecompat.TargAttrFilters;
import org.opends.server.authorization.dseecompat.Target;
import org.opends.server.authorization.dseecompat.TargetAttr;
import org.opends.server.authorization.dseecompat.TargetControl;
import org.opends.server.authorization.dseecompat.TargetFilter;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.SearchScope;

public class AciTargets {
    private Target target = null;
    private SearchScope targetScope = SearchScope.WHOLE_SUBTREE;
    private TargetAttr targetAttr = null;
    private TargetFilter targetFilter = null;
    private TargAttrFilters targAttrFilters = null;
    private TargetControl targetControl = null;
    private ExtOp extOp = null;
    private static final int targetElementCount = 3;
    private static final int targetKeywordPos = 1;
    private static final int targetOperatorPos = 2;
    private static final int targetExpressionPos = 3;
    private static final String targetRegex = "\\(\\s*(\\w+)\\s*(!?=)\\s*\"([^\"]+)\"\\s*\\)\\s*";
    public static final String targetsRegex = "(\\(\\s*(\\w+)\\s*(!?=)\\s*\"([^\"]+)\"\\s*\\)\\s*)*";
    private static final int skipRights = 176;

    private AciTargets(Target targetEntry, TargetAttr targetAttr, TargetFilter targetFilter, SearchScope targetScope, TargAttrFilters targAttrFilters, TargetControl targetControl, ExtOp extOp) {
        this.target = targetEntry;
        this.targetAttr = targetAttr;
        this.targetScope = targetScope;
        this.targetFilter = targetFilter;
        this.targAttrFilters = targAttrFilters;
        this.targetControl = targetControl;
        this.extOp = extOp;
    }

    private Target getTarget() {
        return this.target;
    }

    public TargetAttr getTargetAttr() {
        return this.targetAttr;
    }

    public SearchScope getTargetScope() {
        return this.targetScope;
    }

    public TargetFilter getTargetFilter() {
        return this.targetFilter;
    }

    public TargAttrFilters getTargAttrFilters() {
        return this.targAttrFilters;
    }

    public TargetControl getTargetControl() {
        return this.targetControl;
    }

    public ExtOp getExtOp() {
        return this.extOp;
    }

    public static AciTargets decode(String input, DN dn) throws AciException {
        Target target = null;
        TargetAttr targetAttr = null;
        TargetFilter targetFilter = null;
        TargAttrFilters targAttrFilters = null;
        TargetControl targetControl = null;
        ExtOp extOp = null;
        SearchScope targetScope = SearchScope.WHOLE_SUBTREE;
        Pattern targetPattern = Pattern.compile(targetRegex);
        Matcher targetMatcher = targetPattern.matcher(input);
        while (targetMatcher.find()) {
            if (targetMatcher.groupCount() != 3) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGET_SYNTAX.get(input);
                throw new AciException(message);
            }
            String keyword = targetMatcher.group(1);
            EnumTargetKeyword targetKeyword = EnumTargetKeyword.createKeyword(keyword);
            if (targetKeyword == null) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGET_KEYWORD.get(keyword);
                throw new AciException(message);
            }
            String operator = targetMatcher.group(2);
            EnumTargetOperator targetOperator = EnumTargetOperator.createOperator(operator);
            if (targetOperator == null) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGETS_OPERATOR.get(operator);
                throw new AciException(message);
            }
            String expression = targetMatcher.group(3);
            switch (targetKeyword) {
                case KEYWORD_TARGET: {
                    if (target == null) {
                        target = Target.decode(targetOperator, expression, dn);
                        break;
                    }
                    Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGET_DUPLICATE_KEYWORDS.get("target", input);
                    throw new AciException(message);
                }
                case KEYWORD_TARGETCONTROL: {
                    if (targetControl == null) {
                        targetControl = TargetControl.decode(targetOperator, expression);
                        break;
                    }
                    Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGET_DUPLICATE_KEYWORDS.get("targetcontrol", input);
                    throw new AciException(message);
                }
                case KEYWORD_EXTOP: {
                    if (extOp == null) {
                        extOp = ExtOp.decode(targetOperator, expression);
                        break;
                    }
                    Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGET_DUPLICATE_KEYWORDS.get("extop", input);
                    throw new AciException(message);
                }
                case KEYWORD_TARGETATTR: {
                    if (targetAttr == null) {
                        targetAttr = TargetAttr.decode(targetOperator, expression);
                        break;
                    }
                    Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGET_DUPLICATE_KEYWORDS.get("targetattr", input);
                    throw new AciException(message);
                }
                case KEYWORD_TARGETSCOPE: {
                    if (targetOperator == EnumTargetOperator.NOT_EQUALITY) {
                        Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGET_NOT_OPERATOR.get(operator, targetKeyword.name());
                        throw new AciException(message);
                    }
                    targetScope = AciTargets.createScope(expression);
                    break;
                }
                case KEYWORD_TARGETFILTER: {
                    if (targetFilter == null) {
                        targetFilter = TargetFilter.decode(targetOperator, expression);
                        break;
                    }
                    Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGET_DUPLICATE_KEYWORDS.get("targetfilter", input);
                    throw new AciException(message);
                }
                case KEYWORD_TARGATTRFILTERS: {
                    if (targAttrFilters == null) {
                        if (targetOperator == EnumTargetOperator.NOT_EQUALITY) {
                            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGET_NOT_OPERATOR.get(operator, targetKeyword.name());
                            throw new AciException(message);
                        }
                        targAttrFilters = TargAttrFilters.decode(targetOperator, expression);
                        break;
                    }
                    Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGET_DUPLICATE_KEYWORDS.get("targattrfilters", input);
                    throw new AciException(message);
                }
            }
        }
        return new AciTargets(target, targetAttr, targetFilter, targetScope, targAttrFilters, targetControl, extOp);
    }

    private static SearchScope createScope(String expression) throws AciException {
        if (expression.equalsIgnoreCase("base")) {
            return SearchScope.BASE_OBJECT;
        }
        if (expression.equalsIgnoreCase("onelevel")) {
            return SearchScope.SINGLE_LEVEL;
        }
        if (expression.equalsIgnoreCase("subtree")) {
            return SearchScope.WHOLE_SUBTREE;
        }
        if (expression.equalsIgnoreCase("subordinate")) {
            return SearchScope.SUBORDINATE_SUBTREE;
        }
        Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGETSCOPE_EXPRESSION.get(expression);
        throw new AciException(message);
    }

    public static boolean isTargetFilterApplicable(Aci aci, AciTargetMatchContext matchCtx) {
        boolean ret = true;
        TargetFilter targetFilter = aci.getTargets().getTargetFilter();
        if (targetFilter != null) {
            ret = targetFilter.isApplicable(matchCtx);
        }
        return ret;
    }

    public static boolean isTargetControlApplicable(Aci aci, AciTargetMatchContext matchCtx) {
        boolean ret = false;
        TargetControl targetControl = aci.getTargets().getTargetControl();
        if (targetControl != null) {
            ret = targetControl.isApplicable(matchCtx);
        }
        return ret;
    }

    public static boolean isExtOpApplicable(Aci aci, AciTargetMatchContext matchCtx) {
        boolean ret = false;
        ExtOp extOp = aci.getTargets().getExtOp();
        if (extOp != null) {
            ret = extOp.isApplicable(matchCtx);
        }
        return ret;
    }

    public static boolean isTargAttrFiltersApplicable(Aci aci, AciTargetMatchContext matchCtx) {
        boolean ret = true;
        TargAttrFilters targAttrFilters = aci.getTargets().getTargAttrFilters();
        if (targAttrFilters != null) {
            if (matchCtx.hasRights(32) && targAttrFilters.hasMask(4096) || matchCtx.hasRights(16) && targAttrFilters.hasMask(8192)) {
                ret = targAttrFilters.isApplicableAddDel(matchCtx);
            } else if (matchCtx.hasRights(2048) && targAttrFilters.hasMask(4096) || matchCtx.hasRights(1024) && targAttrFilters.hasMask(8192)) {
                ret = targAttrFilters.isApplicableMod(matchCtx, aci);
            }
        }
        return ret;
    }

    public static boolean isTargetAttrApplicable(Aci aci, AciTargetMatchContext targetMatchCtx) {
        boolean ret = true;
        if (!targetMatchCtx.getTargAttrFiltersMatch()) {
            AciTargets targets = aci.getTargets();
            AttributeType a = targetMatchCtx.getCurrentAttributeType();
            int rights = targetMatchCtx.getRights();
            boolean isFirstAttr = targetMatchCtx.isFirstAttribute();
            if (a != null && targets.getTargetAttr() != null) {
                ret = TargetAttr.isApplicable(a, targets.getTargetAttr());
                AciTargets.setEvalAttributes(targetMatchCtx, targets, ret);
            } else if (a != null || targets.getTargetAttr() != null) {
                ret = aci.hasRights(176) && AciTargets.skipRightsHasRights(rights) ? true : targets.getTargetAttr() != null && a == null && aci.hasRights(8);
            }
            if (isFirstAttr && aci.getTargets().getTargetAttr() == null && aci.getTargets().getTargAttrFilters() == null) {
                targetMatchCtx.setEntryTestRule(true);
            }
        }
        return ret;
    }

    public static boolean skipRightsHasRights(int rights) {
        int tmpRights = rights & 0xFFBFFFFF;
        return (0xB0 & tmpRights) == tmpRights;
    }

    public static boolean isTargetApplicable(Aci aci, AciTargetMatchContext matchCtx) {
        return AciTargets.isTargetApplicable(aci, aci.getTargets(), matchCtx.getResourceEntry().getDN());
    }

    public static boolean isTargetApplicable(Aci aci, AciTargets targets, DN entryDN) {
        DN tmpDN;
        EnumTargetOperator op;
        boolean ret = true;
        DN targetDN = aci.getDN();
        if (targets.getTarget() != null && !targets.getTarget().isPattern() && (op = targets.getTarget().getOperator()) != EnumTargetOperator.NOT_EQUALITY) {
            targetDN = targets.getTarget().getDN();
        }
        switch (targets.getTargetScope()) {
            case BASE_OBJECT: {
                if (targetDN.equals(entryDN)) break;
                return false;
            }
            case SINGLE_LEVEL: {
                if (entryDN.getParent().equals(targetDN)) break;
                return false;
            }
            case WHOLE_SUBTREE: {
                if (entryDN.isDescendantOf(targetDN)) break;
                return false;
            }
            case SUBORDINATE_SUBTREE: {
                if (entryDN.getNumComponents() > targetDN.getNumComponents() && entryDN.isDescendantOf(targetDN)) break;
                return false;
            }
            default: {
                return false;
            }
        }
        if (targets.getTarget() != null && !targets.getTarget().isPattern() && (op = targets.getTarget().getOperator()) == EnumTargetOperator.NOT_EQUALITY && entryDN.isDescendantOf(tmpDN = targets.getTarget().getDN())) {
            return false;
        }
        if (targets.getTarget() != null && targets.getTarget().isPattern()) {
            ret = targets.getTarget().matchesPattern(entryDN);
            op = targets.getTarget().getOperator();
            if (op == EnumTargetOperator.NOT_EQUALITY) {
                ret = !ret;
            }
        }
        return ret;
    }

    private static void setEvalAttributes(AciTargetMatchContext ctx, AciTargets targets, boolean ret) {
        ctx.clearEvalAttributes(8);
        ctx.clearEvalAttributes(4);
        if (ret && targets.getTargetAttr().isAllUserAttributes() && !ctx.hasEvalUserAttributes()) {
            ctx.setEvalUserAttributes(8);
        } else {
            ctx.setEvalUserAttributes(16);
        }
        if (ret && targets.getTargetAttr().isAllOpAttributes() && !ctx.hasEvalOpAttributes()) {
            ctx.setEvalOpAttributes(4);
        } else {
            ctx.setEvalOpAttributes(32);
        }
    }
}

