/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.opends.messages.AdminMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.AbsoluteInheritedDefaultBehaviorProvider;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.Constraint;
import org.opends.server.admin.DecodingException;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.DefaultBehaviorProviderVisitor;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.RelativeInheritedDefaultBehaviorProvider;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.server.AbstractConfigListenerAdaptor;
import org.opends.server.admin.server.ConstraintViolationException;
import org.opends.server.admin.server.DNBuilder;
import org.opends.server.admin.server.ServerConstraintHandler;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.server.ServerManagedObjectChangeListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConfigChangeListenerAdaptor<S extends Configuration>
extends AbstractConfigListenerAdaptor
implements ConfigChangeListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ServerManagedObject<? extends S> cachedManagedObject;
    private final ConfigDeleteListener cleanerListener;
    private final Set<DN> dependencies;
    private final ConfigChangeListener dependencyListener;
    private final DN dn;
    private final ServerManagedObjectChangeListener<? super S> listener;
    private final ManagedObjectPath<?, S> path;

    public ConfigChangeListenerAdaptor(ManagedObjectPath<?, S> path, ServerManagedObjectChangeListener<? super S> listener) {
        ConfigEntry configEntry;
        this.path = path;
        this.dn = DNBuilder.create(path);
        this.listener = listener;
        this.cachedManagedObject = null;
        this.dependencies = new HashSet<DN>();
        this.dependencyListener = new ConfigChangeListener(){

            public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
                ConfigEntry dependentConfigEntry = ConfigChangeListenerAdaptor.this.getConfigEntry(ConfigChangeListenerAdaptor.this.dn);
                if (dependentConfigEntry != null) {
                    return ConfigChangeListenerAdaptor.this.applyConfigurationChange(dependentConfigEntry);
                }
                configEntry.deregisterChangeListener(this);
                return new ConfigChangeResult(ResultCode.SUCCESS, false);
            }

            public boolean configChangeIsAcceptable(ConfigEntry configEntry, MessageBuilder unacceptableReason) {
                ConfigEntry dependentConfigEntry = ConfigChangeListenerAdaptor.this.getConfigEntry(ConfigChangeListenerAdaptor.this.dn);
                if (dependentConfigEntry != null) {
                    return ConfigChangeListenerAdaptor.this.configChangeIsAcceptable(dependentConfigEntry, unacceptableReason, configEntry);
                }
                configEntry.deregisterChangeListener(this);
                return true;
            }
        };
        AbstractManagedObjectDefinition<?, S> d = path.getManagedObjectDefinition();
        for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
            Visitor.find(path, pd, this.dependencies);
        }
        for (DN entryDN : this.dependencies) {
            ConfigEntry configEntry2;
            if (entryDN.equals(this.dn) || (configEntry2 = this.getConfigEntry(entryDN)) == null) continue;
            configEntry2.registerChangeListener(this.dependencyListener);
        }
        this.cleanerListener = new ConfigDeleteListener(){

            public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
                if (configEntry.getDN().equals(ConfigChangeListenerAdaptor.this.dn)) {
                    ConfigChangeListenerAdaptor.this.finalizeChangeListener();
                }
                return new ConfigChangeResult(ResultCode.SUCCESS, false);
            }

            public boolean configDeleteIsAcceptable(ConfigEntry configEntry, MessageBuilder unacceptableReason) {
                return true;
            }
        };
        DN parent = this.dn.getParent();
        if (parent != null && (configEntry = this.getConfigEntry(this.dn.getParent())) != null) {
            configEntry.registerDeleteListener(this.cleanerListener);
        }
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        this.cachedManagedObject.setConfigEntry(configEntry);
        ConfigChangeResult result = this.listener.applyConfigurationChange(this.cachedManagedObject);
        if (result.getResultCode() == ResultCode.SUCCESS) {
            ManagedObjectDefinition<?, S> d = this.cachedManagedObject.getManagedObjectDefinition();
            for (Constraint constraint : d.getAllConstraints()) {
                for (ServerConstraintHandler handler : constraint.getServerConstraintHandlers()) {
                    try {
                        handler.performPostModify(this.cachedManagedObject);
                    }
                    catch (ConfigException e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean configChangeIsAcceptable(ConfigEntry configEntry, MessageBuilder unacceptableReason) {
        return this.configChangeIsAcceptable(configEntry, unacceptableReason, configEntry);
    }

    public boolean configChangeIsAcceptable(ConfigEntry configEntry, MessageBuilder unacceptableReason, ConfigEntry newConfigEntry) {
        try {
            ServerManagementContext context = ServerManagementContext.getInstance();
            this.cachedManagedObject = context.decode(this.path, configEntry, newConfigEntry);
        }
        catch (DecodingException e) {
            unacceptableReason.append(e.getMessageObject());
            return false;
        }
        try {
            this.cachedManagedObject.ensureIsUsable();
        }
        catch (ConstraintViolationException e) {
            this.generateUnacceptableReason(e.getMessages(), unacceptableReason);
            return false;
        }
        LinkedList<Message> reasons = new LinkedList<Message>();
        if (this.listener.isConfigurationChangeAcceptable(this.cachedManagedObject, reasons)) {
            return true;
        }
        this.generateUnacceptableReason(reasons, unacceptableReason);
        return false;
    }

    public void finalizeChangeListener() {
        for (DN dependency : this.dependencies) {
            ConfigEntry listenerConfigEntry = this.getConfigEntry(dependency);
            if (listenerConfigEntry == null) continue;
            listenerConfigEntry.deregisterChangeListener(this.dependencyListener);
        }
        ConfigEntry parentConfigEntry = this.getConfigEntry(this.dn.getParent());
        if (parentConfigEntry != null) {
            parentConfigEntry.deregisterDeleteListener(this.cleanerListener);
        }
    }

    ServerManagedObjectChangeListener<? super S> getServerManagedObjectChangeListener() {
        return this.listener;
    }

    private ConfigEntry getConfigEntry(DN dn) {
        try {
            ConfigEntry configEntry = DirectoryServer.getConfigEntry(dn);
            if (configEntry != null) {
                return configEntry;
            }
            Message message = AdminMessages.ERR_ADMIN_MANAGED_OBJECT_DOES_NOT_EXIST.get(String.valueOf(dn));
            ErrorLogger.logError(message);
        }
        catch (ConfigException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = AdminMessages.ERR_ADMIN_CANNOT_GET_MANAGED_OBJECT.get(String.valueOf(dn), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Visitor<T>
    implements DefaultBehaviorProviderVisitor<T, Void, ManagedObjectPath<?, ?>> {
        private final Collection<DN> dependencies;

        public static <T> void find(ManagedObjectPath<?, ?> path, PropertyDefinition<T> pd, Collection<DN> dependencies) {
            Visitor<T> v = new Visitor<T>(dependencies);
            DefaultBehaviorProvider<T> db = pd.getDefaultBehaviorProvider();
            db.accept(v, path);
        }

        private Visitor(Collection<DN> dependencies) {
            this.dependencies = dependencies;
        }

        @Override
        public Void visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, ManagedObjectPath<?, ?> p) {
            ManagedObjectPath<?, ?> next = d.getManagedObjectPath();
            this.dependencies.add(DNBuilder.create(next));
            String propertyName = d.getPropertyName();
            AbstractManagedObjectDefinition<?, ?> mod = d.getManagedObjectDefinition();
            PropertyDefinition<?> pd = mod.getPropertyDefinition(propertyName);
            Visitor.find(next, pd, this.dependencies);
            return null;
        }

        @Override
        public Void visitAlias(AliasDefaultBehaviorProvider<T> d, ManagedObjectPath<?, ?> p) {
            return null;
        }

        @Override
        public Void visitDefined(DefinedDefaultBehaviorProvider<T> d, ManagedObjectPath<?, ?> p) {
            return null;
        }

        @Override
        public Void visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, ManagedObjectPath<?, ?> p) {
            ManagedObjectPath<?, ?> next = d.getManagedObjectPath(p);
            this.dependencies.add(DNBuilder.create(next));
            String propertyName = d.getPropertyName();
            AbstractManagedObjectDefinition<?, ?> mod = d.getManagedObjectDefinition();
            PropertyDefinition<?> pd = mod.getPropertyDefinition(propertyName);
            Visitor.find(next, pd, this.dependencies);
            return null;
        }

        @Override
        public Void visitUndefined(UndefinedDefaultBehaviorProvider<T> d, ManagedObjectPath<?, ?> p) {
            return null;
        }
    }
}

