/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.cli;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.messages.AdminMessages;
import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.client.cli.DsFrameworkCliParser;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.client.cli.DsFrameworkCliSubCommandGroup;
import org.opends.server.tools.ToolConstants;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.types.Privilege;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsFrameworkCliGlobalAdmin
implements DsFrameworkCliSubCommandGroup {
    private static final Message DESCRIPTION_OPTIONS_TITLE = DSConfigMessages.INFO_DSCFG_HELP_DESCRIPTION_OPTION.get();
    private static final Message DESCRIPTION_OPTIONS_READ = DSConfigMessages.INFO_DSCFG_HELP_DESCRIPTION_READ.get();
    private static final Message DESCRIPTION_OPTIONS_WRITE = DSConfigMessages.INFO_DSCFG_HELP_DESCRIPTION_WRITE.get();
    private static final Message DESCRIPTION_OPTIONS_MANDATORY = DSConfigMessages.INFO_DSCFG_HELP_DESCRIPTION_MANDATORY.get();
    private static final Message DESCRIPTION_OPTIONS_SINGLE = DSConfigMessages.INFO_DSCFG_HELP_DESCRIPTION_SINGLE_VALUED.get();
    private DsFrameworkCliParser argParser;
    private SubCommand createAdminUserSubCmd;
    private StringArgument createAdminUserUserIdArg;
    private StringArgument createAdminUserSetArg;
    private SubCommand deleteAdminUserSubCmd;
    private StringArgument deleteAdminUserUserIdArg;
    private SubCommand listAdminUserSubCmd;
    private SubCommand getAdminUserPropertiesSubCmd;
    private StringArgument getAdminUserPropertiesUserIdArg;
    private SubCommand setAdminUserPropertiesSubCmd;
    private StringArgument setAdminUserPropertiesUserIdArg;
    private StringArgument setAdminUserPropertiesSetArg;
    private SubCommand listAdminUserPropertiesSubCmd;
    private HashMap<ADSContext.AdministratorProperty, Argument> userAdminProperties;
    private HashSet<ADSContext.AdministratorProperty> readonlyadminUserProperties;
    private final HashSet<SubCommand> subCommands = new HashSet();
    private boolean isHidden;
    private String groupName;

    @Override
    public Set<SubCommand> getSubCommands() {
        return this.subCommands;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void initializeCliGroup(DsFrameworkCliParser argParser, BooleanArgument verboseArg) throws ArgumentException {
        this.isHidden = false;
        this.groupName = "admin-user";
        this.argParser = argParser;
        this.createAdminUserSubCmd = new SubCommand(argParser, SubCommandNameEnum.CREATE_ADMIN_USER.toString(), AdminMessages.INFO_ADMIN_SUBCMD_CREATE_ADMIN_USER_DESCRIPTION.get());
        this.subCommands.add(this.createAdminUserSubCmd);
        this.createAdminUserUserIdArg = new StringArgument("userID", null, "userID", false, true, ToolMessages.INFO_USERID_PLACEHOLDER.get(), AdminMessages.INFO_ADMIN_ARG_USERID_DESCRIPTION.get());
        this.createAdminUserSubCmd.addArgument(this.createAdminUserUserIdArg);
        this.createAdminUserSetArg = new StringArgument("set", ToolConstants.OPTION_SHORT_SET, "set", false, true, true, ToolMessages.INFO_VALUE_SET_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_PROP_VAL.get());
        this.createAdminUserSubCmd.addArgument(this.createAdminUserSetArg);
        this.deleteAdminUserSubCmd = new SubCommand(argParser, SubCommandNameEnum.DELETE_ADMIN_USER.toString(), AdminMessages.INFO_ADMIN_SUBCMD_DELETE_ADMIN_USER_DESCRIPTION.get());
        this.subCommands.add(this.deleteAdminUserSubCmd);
        this.deleteAdminUserUserIdArg = new StringArgument("userID", null, "userID", false, true, ToolMessages.INFO_USERID_PLACEHOLDER.get(), AdminMessages.INFO_ADMIN_ARG_USERID_DESCRIPTION.get());
        this.deleteAdminUserSubCmd.addArgument(this.deleteAdminUserUserIdArg);
        this.listAdminUserSubCmd = new SubCommand(argParser, SubCommandNameEnum.LIST_ADMIN_USER.toString(), AdminMessages.INFO_ADMIN_SUBCMD_LIST_ADMIN_USER_DESCRIPTION.get());
        this.subCommands.add(this.listAdminUserSubCmd);
        this.getAdminUserPropertiesSubCmd = new SubCommand(argParser, SubCommandNameEnum.GET_ADMIN_USER_PROPERTIES.toString(), AdminMessages.INFO_ADMIN_SUBCMD_GET_ADMIN_USER_PROPERTIES_DESCRIPTION.get());
        this.subCommands.add(this.getAdminUserPropertiesSubCmd);
        this.getAdminUserPropertiesUserIdArg = new StringArgument("userID", null, "userID", false, true, ToolMessages.INFO_USERID_PLACEHOLDER.get(), AdminMessages.INFO_ADMIN_ARG_USERID_DESCRIPTION.get());
        this.getAdminUserPropertiesUserIdArg.setMultiValued(true);
        this.getAdminUserPropertiesSubCmd.addArgument(this.getAdminUserPropertiesUserIdArg);
        this.setAdminUserPropertiesSubCmd = new SubCommand(argParser, SubCommandNameEnum.SET_ADMIN_USER_PROPERTIES.toString(), AdminMessages.INFO_ADMIN_SUBCMD_SET_ADMIN_USER_PROPERTIES_DESCRIPTION.get());
        this.subCommands.add(this.setAdminUserPropertiesSubCmd);
        this.setAdminUserPropertiesUserIdArg = new StringArgument("userID", null, "userID", false, true, ToolMessages.INFO_USERID_PLACEHOLDER.get(), AdminMessages.INFO_ADMIN_ARG_USERID_DESCRIPTION.get());
        this.setAdminUserPropertiesSubCmd.addArgument(this.setAdminUserPropertiesUserIdArg);
        this.setAdminUserPropertiesSetArg = new StringArgument("set", ToolConstants.OPTION_SHORT_SET, "set", false, true, true, ToolMessages.INFO_VALUE_SET_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_PROP_VAL.get());
        this.setAdminUserPropertiesSubCmd.addArgument(this.setAdminUserPropertiesSetArg);
        this.listAdminUserPropertiesSubCmd = new SubCommand(argParser, SubCommandNameEnum.LIST_ADMIN_USER_PROPERTIES.toString(), AdminMessages.INFO_ADMIN_SUBCMD_LIST_ADMIN_USER_PROPERTIES_DESCRIPTION.get());
        this.subCommands.add(this.listAdminUserPropertiesSubCmd);
        this.userAdminProperties = new HashMap();
        this.readonlyadminUserProperties = new HashSet();
        ADSContext.AdministratorProperty prop = ADSContext.AdministratorProperty.UID;
        String attName = prop.getAttributeName();
        StringArgument arg = new StringArgument(attName, null, attName, false, false, true, Message.raw("", new Object[0]), null, null, null);
        this.userAdminProperties.put(prop, arg);
        prop = ADSContext.AdministratorProperty.PASSWORD;
        attName = prop.getAttributeName();
        arg = new StringArgument(attName, null, attName, false, false, true, Message.raw("", new Object[0]), null, null, null);
        this.userAdminProperties.put(prop, arg);
        prop = ADSContext.AdministratorProperty.DESCRIPTION;
        attName = prop.getAttributeName();
        arg = new StringArgument(attName, null, attName, false, false, true, Message.raw("", new Object[0]), null, null, null);
        this.userAdminProperties.put(prop, arg);
        prop = ADSContext.AdministratorProperty.ADMINISTRATOR_DN;
        attName = prop.getAttributeName();
        arg = new StringArgument(attName, null, attName, false, false, true, Message.raw("", new Object[0]), null, null, null);
        this.userAdminProperties.put(prop, arg);
        this.readonlyadminUserProperties.add(prop);
        prop = ADSContext.AdministratorProperty.PRIVILEGE;
        attName = prop.getAttributeName();
        arg = new StringArgument(attName, null, attName, true, true, true, Message.raw("", new Object[0]), "root", null, null);
        this.userAdminProperties.put(prop, arg);
    }

    @Override
    public boolean isSubCommand(SubCommand subCmd) {
        return SubCommandNameEnum.isSubCommand(subCmd.getName());
    }

    @Override
    public DsFrameworkCliReturnCode performSubCommand(SubCommand subCmd, OutputStream outStream, OutputStream errStream) throws ADSContextException, ArgumentException {
        DsFrameworkCliReturnCode returnCode;
        InitialContext ctx;
        block24: {
            ADSContext adsCtx = null;
            ctx = null;
            returnCode = DsFrameworkCliReturnCode.ERROR_UNEXPECTED;
            try {
                if (subCmd.getName().equals(this.createAdminUserSubCmd.getName())) {
                    String userId = this.createAdminUserUserIdArg.getValue();
                    Map<ADSContext.AdministratorProperty, Object> map = this.mapSetOptionsToMap(this.createAdminUserSetArg, true);
                    map.put(ADSContext.AdministratorProperty.UID, userId);
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    adsCtx.createAdministrator(map);
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block24;
                }
                if (subCmd.getName().equals(this.deleteAdminUserSubCmd.getName())) {
                    String userId = this.deleteAdminUserUserIdArg.getValue();
                    HashMap<ADSContext.AdministratorProperty, Object> map = new HashMap<ADSContext.AdministratorProperty, Object>();
                    map.put(ADSContext.AdministratorProperty.UID, userId);
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    adsCtx.deleteAdministrator(map);
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block24;
                }
                if (subCmd.getName().equals(this.listAdminUserSubCmd.getName())) {
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    Set<Map<ADSContext.AdministratorProperty, Object>> adminUserList = adsCtx.readAdministratorRegistry();
                    PrintStream out = new PrintStream(outStream);
                    for (Map<ADSContext.AdministratorProperty, Object> user : adminUserList) {
                        out.println(ADSContext.AdministratorProperty.UID.getAttributeName() + ": " + user.get((Object)ADSContext.AdministratorProperty.UID));
                    }
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block24;
                }
                if (subCmd.getName().equals(this.getAdminUserPropertiesSubCmd.getName())) {
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    Set<Map<ADSContext.AdministratorProperty, Object>> adsAdminUserList = adsCtx.readAdministratorRegistry();
                    LinkedList<String> userAdminUserList = this.getAdminUserPropertiesUserIdArg.getValues();
                    PrintStream out = new PrintStream(outStream);
                    for (Map<ADSContext.AdministratorProperty, Object> adminUser : adsAdminUserList) {
                        String adminUserID = (String)adminUser.get((Object)ADSContext.AdministratorProperty.UID);
                        if (!userAdminUserList.contains(adminUserID)) continue;
                        out.println(ADSContext.AdministratorProperty.UID.getAttributeName() + ": " + adminUser.get((Object)ADSContext.AdministratorProperty.UID));
                        for (ADSContext.AdministratorProperty ap : adminUser.keySet()) {
                            if (ap.equals((Object)ADSContext.AdministratorProperty.UID)) continue;
                            out.println(ap.getAttributeName() + ": " + adminUser.get((Object)ap));
                        }
                        out.println();
                    }
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block24;
                }
                if (subCmd.getName().equals(this.setAdminUserPropertiesSubCmd.getName())) {
                    Map<ADSContext.AdministratorProperty, Object> map = this.mapSetOptionsToMap(this.setAdminUserPropertiesSetArg, false);
                    String newServerId = (String)map.get((Object)ADSContext.AdministratorProperty.UID);
                    map.put(ADSContext.AdministratorProperty.UID, this.setAdminUserPropertiesUserIdArg.getValue());
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    adsCtx.updateAdministrator(map, newServerId);
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block24;
                }
                if (subCmd.getName().equals(this.listAdminUserPropertiesSubCmd.getName())) {
                    PrintStream out = new PrintStream(outStream);
                    out.println(DESCRIPTION_OPTIONS_TITLE);
                    out.println();
                    out.print(" r -- ");
                    out.println(DESCRIPTION_OPTIONS_READ);
                    out.print(" w -- ");
                    out.println(DESCRIPTION_OPTIONS_WRITE);
                    out.print(" m -- ");
                    out.println(DESCRIPTION_OPTIONS_MANDATORY);
                    out.print(" s -- ");
                    out.println(DESCRIPTION_OPTIONS_SINGLE);
                    out.println();
                    TableBuilder table = new TableBuilder();
                    table.appendHeading(DSConfigMessages.INFO_DSCFG_HEADING_PROPERTY_NAME.get());
                    table.appendHeading(DSConfigMessages.INFO_DSCFG_HEADING_PROPERTY_OPTIONS.get());
                    table.appendHeading(DSConfigMessages.INFO_DSCFG_HEADING_PROPERTY_SYNTAX.get());
                    table.appendHeading(ToolMessages.INFO_CLI_HEADING_PROPERTY_DEFAULT_VALUE.get());
                    for (ADSContext.AdministratorProperty adminUserProp : this.userAdminProperties.keySet()) {
                        if (this.userAdminProperties.get((Object)adminUserProp).isHidden()) continue;
                        table.startRow();
                        table.appendCell(adminUserProp.getAttributeName());
                        table.appendCell(this.getPropertyOptionSummary(this.userAdminProperties.get((Object)adminUserProp)));
                        table.appendCell((Object)adminUserProp.getAttributeSyntax());
                        if (this.userAdminProperties.get((Object)adminUserProp).getDefaultValue() != null) {
                            table.appendCell(this.userAdminProperties.get((Object)adminUserProp).getDefaultValue());
                            continue;
                        }
                        table.appendCell("-");
                    }
                    TextTablePrinter printer = new TextTablePrinter(outStream);
                    table.print(printer);
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block24;
                }
                throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED);
            }
            catch (ADSContextException e) {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException x) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException x) {
                // empty catch block
            }
        }
        return returnCode;
    }

    private Map<ADSContext.AdministratorProperty, Object> mapSetOptionsToMap(StringArgument propertySetArgument, boolean createCall) throws ArgumentException {
        HashMap<ADSContext.AdministratorProperty, Object> map = new HashMap<ADSContext.AdministratorProperty, Object>();
        boolean rootPrivileges = false;
        for (String m : propertySetArgument.getValues()) {
            Message message;
            int sep = m.indexOf(58);
            if (sep < 0) {
                throw ArgumentExceptionFactory.missingSeparatorInPropertyArgument(m);
            }
            if (sep == 0) {
                throw ArgumentExceptionFactory.missingNameInPropertyArgument(m);
            }
            String propertyName = m.substring(0, sep);
            String value = m.substring(sep + 1, m.length());
            if (value.length() == 0) {
                throw ArgumentExceptionFactory.missingValueInPropertyArgument(m);
            }
            ADSContext.AdministratorProperty adminUserProperty = ADSContext.getAdminUserPropFromName(propertyName);
            if (adminUserProperty == null) {
                message = ToolMessages.ERR_CLI_ERROR_PROPERTY_UNRECOGNIZED.get(propertyName);
                throw new ArgumentException(message);
            }
            if (this.userAdminProperties.get((Object)adminUserProperty).isHidden()) {
                message = ToolMessages.ERR_CLI_ERROR_PROPERTY_UNRECOGNIZED.get(propertyName);
                throw new ArgumentException(message);
            }
            MessageBuilder invalidReason = new MessageBuilder();
            Argument arg = this.userAdminProperties.get((Object)adminUserProperty);
            if (!arg.valueIsAcceptable(value, invalidReason)) {
                Message message2 = ToolMessages.ERR_CLI_ERROR_INVALID_PROPERTY_VALUE.get(propertyName, value);
                throw new ArgumentException(message2);
            }
            if (adminUserProperty.equals((Object)ADSContext.AdministratorProperty.PRIVILEGE)) {
                if (value.equals(arg.getDefaultValue())) {
                    rootPrivileges = true;
                } else {
                    String valueToCheck = value;
                    if (value.startsWith("-")) {
                        valueToCheck = value.substring(1);
                    }
                    if (Privilege.privilegeForName(valueToCheck) == null) {
                        Message message3 = ToolMessages.ERR_CLI_ERROR_INVALID_PROPERTY_VALUE.get(ADSContext.AdministratorProperty.PRIVILEGE.getAttributeName(), valueToCheck);
                        throw new ArgumentException(message3);
                    }
                }
            }
            arg.addValue(value);
            if (arg.isMultiValued()) {
                map.put(adminUserProperty, arg.getValues());
                continue;
            }
            map.put(adminUserProperty, value);
        }
        if (!createCall) {
            return map;
        }
        if (!map.containsKey((Object)ADSContext.AdministratorProperty.PRIVILEGE)) {
            rootPrivileges = true;
        }
        if (rootPrivileges) {
            LinkedList<String> privilegesList = new LinkedList<String>();
            for (Privilege p : Privilege.getDefaultRootPrivileges()) {
                privilegesList.add(p.getName());
            }
            map.put(ADSContext.AdministratorProperty.PRIVILEGE, privilegesList);
        }
        for (ADSContext.AdministratorProperty s : ADSContext.AdministratorProperty.values()) {
            Argument arg = this.userAdminProperties.get((Object)s);
            if (arg.isHidden() || map.containsKey((Object)s) || !arg.isRequired()) continue;
            if (arg.getDefaultValue() == null) {
                Message message = ToolMessages.ERR_CLI_ERROR_MISSING_PROPERTY.get(s.getAttributeName());
                throw new ArgumentException(message);
            }
            map.put(s, arg.getDefaultValue());
        }
        return map;
    }

    private String getPropertyOptionSummary(Argument arg) {
        StringBuilder b = new StringBuilder();
        if (this.readonlyadminUserProperties.contains((Object)ADSContext.getServerPropFromName(arg.getName()))) {
            b.append("r-");
        } else {
            b.append("rw");
        }
        if (arg.isRequired()) {
            b.append('m');
        } else {
            b.append('-');
        }
        if (arg.isMultiValued()) {
            b.append('-');
        } else {
            b.append('s');
        }
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SubCommandNameEnum {
        CREATE_ADMIN_USER("create-admin-user"),
        DELETE_ADMIN_USER("delete-admin-user"),
        LIST_ADMIN_USER("list-admin-user"),
        LIST_ADMIN_USER_PROPERTIES("list-admin-user-properties"),
        GET_ADMIN_USER_PROPERTIES("get-admin-user-properties"),
        SET_ADMIN_USER_PROPERTIES("set-admin-user-properties");

        private final String name;
        private static final List<String> nameToSubCmdName;

        private SubCommandNameEnum(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static boolean isSubCommand(String name) {
            return nameToSubCmdName.contains(name);
        }

        static {
            nameToSubCmdName = new ArrayList<String>();
            for (SubCommandNameEnum subCmd : SubCommandNameEnum.values()) {
                nameToSubCmdName.add(subCmd.toString());
            }
        }
    }
}

