/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client;

import java.util.SortedSet;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.SetRelationDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.client.spi.Driver;
import org.opends.server.admin.std.client.RootCfgClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ManagementContext {
    protected ManagementContext() {
    }

    public final <C extends ConfigurationClient, S extends Configuration> boolean deleteManagedObject(ManagedObjectPath<?, ?> parent, InstantiableRelationDefinition<C, S> rd, String name) throws IllegalArgumentException, ManagedObjectNotFoundException, OperationRejectedException, AuthorizationException, CommunicationException {
        return this.getDriver().deleteManagedObject(parent, rd, name);
    }

    public final <C extends ConfigurationClient, S extends Configuration> boolean deleteManagedObject(ManagedObjectPath<?, ?> parent, OptionalRelationDefinition<C, S> rd) throws IllegalArgumentException, ManagedObjectNotFoundException, OperationRejectedException, AuthorizationException, CommunicationException {
        return this.getDriver().deleteManagedObject(parent, rd);
    }

    public final <C extends ConfigurationClient, S extends Configuration> boolean deleteManagedObject(ManagedObjectPath<?, ?> parent, SetRelationDefinition<C, S> rd, String name) throws IllegalArgumentException, ManagedObjectNotFoundException, OperationRejectedException, AuthorizationException, CommunicationException {
        return this.getDriver().deleteManagedObject(parent, rd, name);
    }

    public final <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getManagedObject(ManagedObjectPath<C, S> path) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, AuthorizationException, CommunicationException {
        if (path.isEmpty()) {
            return this.getRootConfigurationManagedObject();
        }
        return this.getDriver().getManagedObject(path);
    }

    public final <PD> PD getPropertyValue(ManagedObjectPath<?, ?> path, PropertyDefinition<PD> pd) throws IllegalArgumentException, DefinitionDecodingException, AuthorizationException, ManagedObjectNotFoundException, CommunicationException, PropertyException {
        SortedSet<PD> values = this.getPropertyValues(path, pd);
        if (values.isEmpty()) {
            return null;
        }
        return (PD)values.iterator().next();
    }

    public final <PD> SortedSet<PD> getPropertyValues(ManagedObjectPath<?, ?> path, PropertyDefinition<PD> pd) throws IllegalArgumentException, DefinitionDecodingException, AuthorizationException, ManagedObjectNotFoundException, CommunicationException, PropertyException {
        return this.getDriver().getPropertyValues(path, pd);
    }

    public final RootCfgClient getRootConfiguration() {
        return this.getRootConfigurationManagedObject().getConfiguration();
    }

    public final ManagedObject<RootCfgClient> getRootConfigurationManagedObject() {
        return this.getDriver().getRootConfigurationManagedObject();
    }

    public final <C extends ConfigurationClient, S extends Configuration> String[] listManagedObjects(ManagedObjectPath<?, ?> parent, InstantiableRelationDefinition<C, S> rd) throws IllegalArgumentException, ManagedObjectNotFoundException, AuthorizationException, CommunicationException {
        return this.listManagedObjects(parent, rd, rd.getChildDefinition());
    }

    public final <C extends ConfigurationClient, S extends Configuration> String[] listManagedObjects(ManagedObjectPath<?, ?> parent, InstantiableRelationDefinition<C, S> rd, AbstractManagedObjectDefinition<? extends C, ? extends S> d) throws IllegalArgumentException, ManagedObjectNotFoundException, AuthorizationException, CommunicationException {
        return this.getDriver().listManagedObjects(parent, rd, d);
    }

    public final <C extends ConfigurationClient, S extends Configuration> String[] listManagedObjects(ManagedObjectPath<?, ?> parent, SetRelationDefinition<C, S> rd) throws IllegalArgumentException, ManagedObjectNotFoundException, AuthorizationException, CommunicationException {
        return this.getDriver().listManagedObjects(parent, rd, rd.getChildDefinition());
    }

    public final boolean managedObjectExists(ManagedObjectPath<?, ?> path) throws ManagedObjectNotFoundException, AuthorizationException, CommunicationException {
        return this.getDriver().managedObjectExists(path);
    }

    protected abstract Driver getDriver();

    public final void close() {
        this.getDriver().close();
    }
}

