/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Application;
import org.opends.quicksetup.CurrentInstallStatus;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.ProgressDescriptor;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.Step;
import org.opends.quicksetup.UserDataCertificateException;
import org.opends.quicksetup.UserDataConfirmationException;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.WizardStep;
import org.opends.quicksetup.event.ButtonActionListener;
import org.opends.quicksetup.event.ButtonEvent;
import org.opends.quicksetup.event.ProgressUpdateEvent;
import org.opends.quicksetup.event.ProgressUpdateListener;
import org.opends.quicksetup.ui.CertificateDialog;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.QuickSetupDialog;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.BackgroundTask;
import org.opends.quicksetup.util.HtmlProgressMessageFormatter;
import org.opends.quicksetup.util.Utils;

public class QuickSetup
implements ButtonActionListener,
ProgressUpdateListener {
    private static final Logger LOG = Logger.getLogger(QuickSetup.class.getName());
    private GuiApplication application;
    private CurrentInstallStatus installStatus;
    private WizardStep currentStep;
    private QuickSetupDialog dialog;
    private MessageBuilder progressDetails = new MessageBuilder();
    private ProgressDescriptor lastDescriptor;
    private ProgressDescriptor lastDisplayedDescriptor;
    private ProgressDescriptor descriptorToDisplay;
    private static final int UPDATE_PERIOD = 500;
    private static final String MAC_APPLICATIONS_OPENER = "/usr/bin/open";

    public void initialize(String[] args) {
        HtmlProgressMessageFormatter formatter = new HtmlProgressMessageFormatter();
        this.installStatus = new CurrentInstallStatus();
        this.application = Application.create();
        this.application.setProgressMessageFormatter(formatter);
        this.application.setCurrentInstallStatus(this.installStatus);
        this.initLookAndFeel();
        this.setCurrentStep(this.application.getFirstWizardStep());
    }

    public void display() {
        this.getDialog().packAndShow();
    }

    public void buttonActionPerformed(ButtonEvent ev) {
        switch (ev.getButtonName()) {
            case NEXT: {
                this.nextClicked();
                break;
            }
            case CLOSE: {
                this.closeClicked();
                break;
            }
            case FINISH: {
                this.finishClicked();
                break;
            }
            case QUIT: {
                this.quitClicked();
                break;
            }
            case CONTINUE_INSTALL: {
                this.continueInstallClicked();
                break;
            }
            case PREVIOUS: {
                this.previousClicked();
                break;
            }
            case LAUNCH_STATUS_PANEL: {
                this.launchStatusPanelClicked();
                break;
            }
            case INPUT_PANEL_BUTTON: {
                this.inputPanelButtonClicked();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown button name: " + (Object)((Object)ev.getButtonName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressUpdate(ProgressUpdateEvent ev) {
        QuickSetup quickSetup = this;
        synchronized (quickSetup) {
            ProgressDescriptor desc = this.createProgressDescriptor(ev);
            boolean isLastDescriptor = desc.getProgressStep().isLast();
            if (isLastDescriptor) {
                this.lastDescriptor = desc;
            }
            this.descriptorToDisplay = desc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDisplayUpdater() {
        boolean doPool = true;
        while (doPool) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            QuickSetup quickSetup = this;
            synchronized (quickSetup) {
                final ProgressDescriptor desc = this.descriptorToDisplay;
                if (desc != null) {
                    if (desc != this.lastDisplayedDescriptor) {
                        this.lastDisplayedDescriptor = desc;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (QuickSetup.this.application.isFinished() && !QuickSetup.this.getCurrentStep().isFinishedStep()) {
                                    QuickSetup.this.setCurrentStep(QuickSetup.this.application.getFinishedStep());
                                }
                                QuickSetup.this.getDialog().displayProgress(desc);
                            }
                        });
                    }
                    doPool = desc != this.lastDescriptor;
                }
            }
        }
    }

    private void nextClicked() {
        WizardStep cStep = this.getCurrentStep();
        this.application.nextClicked(cStep, this);
        NextClickedBackgroundTask worker = new NextClickedBackgroundTask(cStep);
        this.getDialog().workerStarted();
        worker.startBackgroundTask();
    }

    private void updateUserData(final WizardStep cStep) {
        BackgroundTask worker = new BackgroundTask(){

            public Object processBackgroundTask() throws UserDataException {
                try {
                    QuickSetup.this.application.updateUserData(cStep, QuickSetup.this);
                }
                catch (UserDataException uide) {
                    throw uide;
                }
                catch (Throwable t) {
                    throw new UserDataException(cStep, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t));
                }
                return null;
            }

            public void backgroundTaskCompleted(Object returnValue, Throwable throwable) {
                QuickSetup.this.getDialog().workerFinished();
                if (throwable != null) {
                    UserDataException ude = (UserDataException)throwable;
                    if (ude instanceof UserDataConfirmationException) {
                        if (QuickSetup.this.displayConfirmation(ude.getMessageObject(), QuickSetupMessages.INFO_CONFIRMATION_TITLE.get())) {
                            try {
                                QuickSetup.this.setCurrentStep(QuickSetup.this.application.getNextWizardStep(cStep));
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                    } else {
                        QuickSetup.this.displayError(ude.getMessageObject(), QuickSetupMessages.INFO_ERROR_TITLE.get());
                    }
                } else {
                    QuickSetup.this.setCurrentStep(QuickSetup.this.application.getNextWizardStep(cStep));
                }
                if (QuickSetup.this.currentStep.isProgressStep()) {
                    QuickSetup.this.launch();
                }
            }
        };
        this.getDialog().workerStarted();
        worker.startBackgroundTask();
    }

    private void finishClicked() {
        WizardStep cStep = this.getCurrentStep();
        if (this.application.finishClicked(cStep, this)) {
            this.updateUserData(cStep);
        }
    }

    private void previousClicked() {
        WizardStep cStep = this.getCurrentStep();
        this.application.previousClicked(cStep, this);
        this.setCurrentStep(this.application.getPreviousWizardStep(cStep));
    }

    private void quitClicked() {
        WizardStep cStep = this.getCurrentStep();
        this.application.quitClicked(cStep, this);
    }

    private void continueInstallClicked() {
        this.application.forceToDisplay();
        this.getDialog().forceToDisplay();
        this.setCurrentStep(Step.WELCOME);
    }

    private void closeClicked() {
        WizardStep cStep = this.getCurrentStep();
        this.application.closeClicked(cStep, this);
    }

    private void launchStatusPanelClicked() {
        BackgroundTask worker = new BackgroundTask(){

            public Object processBackgroundTask() throws UserDataException {
                try {
                    ProcessBuilder pb;
                    Object cmd;
                    Installation installation;
                    if (Utils.isWebStart()) {
                        String installDir = QuickSetup.this.application.getUserData().getServerLocation();
                        installation = new Installation(installDir, installDir);
                    } else {
                        installation = Installation.getLocal();
                    }
                    if (Utils.isMacOS()) {
                        cmd = new ArrayList<String>();
                        ((ArrayList)cmd).add(QuickSetup.MAC_APPLICATIONS_OPENER);
                        ((ArrayList)cmd).add(Utils.getScriptPath(Utils.getPath(installation.getControlPanelCommandFile())));
                        pb = new ProcessBuilder((List<String>)cmd);
                    } else {
                        cmd = Utils.getScriptPath(Utils.getPath(installation.getControlPanelCommandFile()));
                        pb = new ProcessBuilder(new String[]{cmd});
                    }
                    Map<String, String> env = pb.environment();
                    env.put("OPENDS_JAVA_HOME", System.getProperty("java.home"));
                    Process process = pb.start();
                    int returnValue = 0;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    try {
                        returnValue = process.exitValue();
                    }
                    catch (IllegalThreadStateException ithse) {
                        // empty catch block
                    }
                    if (returnValue != 0) {
                        throw new Error(QuickSetupMessages.INFO_COULD_NOT_LAUNCH_CONTROL_PANEL_MSG.get().toString());
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new Error(QuickSetupMessages.INFO_COULD_NOT_LAUNCH_CONTROL_PANEL_MSG.get().toString());
                }
                return null;
            }

            public void backgroundTaskCompleted(Object returnValue, Throwable throwable) {
                QuickSetup.this.getDialog().getFrame().setCursor(Cursor.getPredefinedCursor(0));
                if (throwable != null) {
                    QuickSetup.this.displayError(Message.raw(throwable.getMessage(), new Object[0]), QuickSetupMessages.INFO_ERROR_TITLE.get());
                }
            }
        };
        this.getDialog().getFrame().setCursor(Cursor.getPredefinedCursor(3));
        worker.startBackgroundTask();
    }

    private void inputPanelButtonClicked() {
        this.getDialog().getStepsPanel().updateStepVisibility(this);
    }

    public void quit() {
        LOG.log(Level.INFO, "quitting application");
        this.flushLogs();
        System.exit(0);
    }

    private void flushLogs() {
        Handler[] handlers = LOG.getHandlers();
        if (handlers != null) {
            for (Handler h : handlers) {
                h.flush();
            }
        }
    }

    public void launch() {
        this.application.addProgressUpdateListener(this);
        new Thread((Runnable)this.application, "Application Thread").start();
        Thread t = new Thread(new Runnable(){

            public void run() {
                QuickSetup.this.runDisplayUpdater();
                WizardStep ws = QuickSetup.this.application.getCurrentWizardStep();
                QuickSetup.this.getDialog().getButtonsPanel().updateButtons(ws);
            }
        });
        t.start();
    }

    private WizardStep getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(WizardStep step) {
        if (step == null) {
            throw new NullPointerException("step is null");
        }
        this.currentStep = step;
        this.application.setDisplayedWizardStep(step, this.application.getUserData(), this.getDialog());
    }

    public QuickSetupDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new QuickSetupDialog(this.application, this.installStatus, this);
            this.dialog.addButtonActionListener(this);
            this.application.setQuickSetupDialog(this.dialog);
        }
        return this.dialog;
    }

    public void displayError(Message msg, Message title) {
        if (Utils.isCli()) {
            System.err.println(msg);
        } else {
            this.getDialog().displayError(msg, title);
        }
    }

    public boolean displayConfirmation(Message msg, Message title) {
        return this.getDialog().displayConfirmation(msg, title);
    }

    public String getFieldStringValue(FieldName fieldName) {
        String sValue = null;
        Object value = this.getFieldValue(fieldName);
        if (value != null) {
            sValue = value instanceof String ? (String)value : String.valueOf(value);
        }
        return sValue;
    }

    public Object getFieldValue(FieldName fieldName) {
        return this.getDialog().getFieldValue(fieldName);
    }

    public void displayFieldInvalid(FieldName fieldName, boolean invalid) {
        this.getDialog().displayFieldInvalid(fieldName, invalid);
    }

    private void initLookAndFeel() {
        UIFactory.initialize();
    }

    private ProgressDescriptor createProgressDescriptor(ProgressUpdateEvent ev) {
        ProgressStep status = ev.getProgressStep();
        Message newProgressLabel = ev.getCurrentPhaseSummary();
        Message additionalDetails = ev.getNewLogs();
        Integer ratio = ev.getProgressRatio();
        if (additionalDetails != null) {
            this.progressDetails.append(additionalDetails);
        }
        return new ProgressDescriptor(status, ratio, newProgressLabel, Message.raw(this.progressDetails.toString(), new Object[0]));
    }

    private class NextClickedBackgroundTask
    extends BackgroundTask {
        private WizardStep cStep;

        public NextClickedBackgroundTask(WizardStep cStep) {
            this.cStep = cStep;
        }

        public Object processBackgroundTask() throws UserDataException {
            try {
                QuickSetup.this.application.updateUserData(this.cStep, QuickSetup.this);
            }
            catch (UserDataException uide) {
                throw uide;
            }
            catch (Throwable t) {
                throw new UserDataException(this.cStep, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t));
            }
            return null;
        }

        public void backgroundTaskCompleted(Object returnValue, Throwable throwable) {
            QuickSetup.this.getDialog().workerFinished();
            if (throwable != null) {
                if (!(throwable instanceof UserDataException)) {
                    LOG.log(Level.WARNING, "Unhandled exception.", throwable);
                } else {
                    UserDataException ude = (UserDataException)throwable;
                    if (ude instanceof UserDataConfirmationException) {
                        if (QuickSetup.this.displayConfirmation(ude.getMessageObject(), QuickSetupMessages.INFO_CONFIRMATION_TITLE.get())) {
                            QuickSetup.this.setCurrentStep(QuickSetup.this.application.getNextWizardStep(this.cStep));
                        }
                    } else if (ude instanceof UserDataCertificateException) {
                        UserDataCertificateException ce = (UserDataCertificateException)ude;
                        CertificateDialog dlg = new CertificateDialog(QuickSetup.this.getDialog().getFrame(), ce);
                        dlg.pack();
                        dlg.setVisible(true);
                        CertificateDialog.ReturnType answer = dlg.getUserAnswer();
                        if (answer != CertificateDialog.ReturnType.NOT_ACCEPTED) {
                            QuickSetup.this.application.acceptCertificateForException(ce, answer == CertificateDialog.ReturnType.ACCEPTED_PERMANENTLY);
                            QuickSetup.this.application.nextClicked(this.cStep, QuickSetup.this);
                            NextClickedBackgroundTask worker = new NextClickedBackgroundTask(this.cStep);
                            QuickSetup.this.getDialog().workerStarted();
                            worker.startBackgroundTask();
                        }
                    } else {
                        QuickSetup.this.displayError(ude.getMessageObject(), QuickSetupMessages.INFO_ERROR_TITLE.get());
                    }
                }
            } else {
                QuickSetup.this.setCurrentStep(QuickSetup.this.application.getNextWizardStep(this.cStep));
            }
        }
    }
}

