/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.SecurityOptions;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.event.BrowseActionListener;
import org.opends.quicksetup.installer.ui.SecurityOptionsDialog;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.LabelFieldDescriptor;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.CertificateManager;

public class ServerSettingsPanel
extends QuickSetupStepPanel {
    private UserData defaultUserData;
    private Component lastFocusComponent;
    private JLabel lSecurity;
    private JButton secureAccessButton;
    private JButton browseButton;
    private boolean displayServerLocation;
    private boolean canUpdateSecurity;
    private SecurityOptions securityOptions;
    private HashMap<FieldName, JLabel> hmLabels = new HashMap();
    private HashMap<FieldName, JTextComponent> hmFields = new HashMap();
    private JTextComponent tfServerLocationParent;
    private JTextComponent tfServerLocationRelativePath;
    private JLabel lServerLocation;
    private SecurityOptionsDialog dlg;
    private static final long serialVersionUID = -15911406930993035L;

    public ServerSettingsPanel(GuiApplication application) {
        super(application);
        this.defaultUserData = application.getUserData();
        this.displayServerLocation = this.isWebStart();
        this.canUpdateSecurity = CertificateManager.mayUseCertificateManager();
        this.securityOptions = this.defaultUserData.getSecurityOptions();
        this.populateLabelAndFieldMaps();
        this.addFocusListeners();
    }

    public Object getFieldValue(FieldName fieldName) {
        Object value = null;
        if (fieldName == FieldName.SERVER_LOCATION) {
            String parent = this.tfServerLocationParent.getText();
            String relative = this.tfServerLocationRelativePath.getText();
            if (parent != null && parent.length() > 0) {
                value = parent;
            }
            if (relative != null && relative.length() > 0) {
                value = value == null ? File.separator + relative : value + File.separator + relative;
            }
        } else if (fieldName == FieldName.SECURITY_OPTIONS) {
            value = this.securityOptions;
        } else {
            JTextComponent field = this.getField(fieldName);
            if (field != null) {
                value = field.getText();
            }
        }
        return value;
    }

    public void displayFieldInvalid(FieldName fieldName, boolean invalid) {
        JLabel label = this.getLabel(fieldName);
        if (label != null) {
            if (invalid) {
                UIFactory.setTextStyle(label, UIFactory.TextStyle.PRIMARY_FIELD_INVALID);
            } else {
                UIFactory.setTextStyle(label, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
            }
        }
    }

    protected Component createInputPanel() {
        JPanel auxPanel;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        FieldName[] fieldNames = new FieldName[]{FieldName.HOST_NAME, FieldName.SERVER_PORT, FieldName.ADMIN_CONNECTOR_PORT, FieldName.SECURITY_OPTIONS, FieldName.DIRECTORY_MANAGER_DN, FieldName.DIRECTORY_MANAGER_PWD, FieldName.DIRECTORY_MANAGER_PWD_CONFIRM};
        if (this.displayServerLocation) {
            gbc.gridwidth = -1;
            gbc.weightx = 0.0;
            gbc.insets.top = 0;
            gbc.insets.left = 0;
            gbc.anchor = 18;
            panel.add((Component)this.lServerLocation, gbc);
            gbc.anchor = 17;
            auxPanel = new JPanel(new GridBagLayout());
            auxPanel.setOpaque(false);
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets.top = 0;
            gbc.insets.left = 10;
            gbc.gridwidth = 0;
            panel.add((Component)auxPanel, gbc);
            gbc.gridwidth = 3;
            gbc.insets = UIFactory.getEmptyInsets();
            gbc.weightx = 0.7;
            auxPanel.add((Component)this.tfServerLocationParent, gbc);
            gbc.gridwidth = -1;
            gbc.weightx = 0.0;
            gbc.insets.left = 5;
            auxPanel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, Message.raw(File.separator, new Object[0]), UIFactory.TextStyle.TEXTFIELD), gbc);
            gbc.gridwidth = 0;
            gbc.weightx = 0.3;
            auxPanel.add((Component)this.tfServerLocationRelativePath, gbc);
            gbc.gridwidth = 3;
            gbc.anchor = 12;
            gbc.insets.top = 5;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            auxPanel.add((Component)this.getBrowseButton(), gbc);
        }
        for (FieldName fieldName : fieldNames) {
            JLabel l;
            gbc.gridwidth = -1;
            gbc.weightx = 0.0;
            gbc.insets.top = 10;
            gbc.insets.left = 0;
            boolean isSecurityField = fieldName == FieldName.SECURITY_OPTIONS;
            int securityInsetsTop = Math.abs(this.getLDAPSecureAccessButton().getPreferredSize().height - this.getLabel((FieldName)fieldName).getPreferredSize().height) / 2;
            if (isSecurityField) {
                gbc.anchor = 18;
                gbc.insets.top += securityInsetsTop;
            } else {
                gbc.anchor = 17;
            }
            panel.add((Component)this.getLabel(fieldName), gbc);
            auxPanel = new JPanel(new GridBagLayout());
            auxPanel.setOpaque(false);
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets.top = 10;
            gbc.insets.left = 10;
            gbc.gridwidth = 0;
            panel.add((Component)auxPanel, gbc);
            boolean isPortField = fieldName == FieldName.SERVER_PORT;
            boolean isAdminConnectorPortField = fieldName == FieldName.ADMIN_CONNECTOR_PORT;
            gbc.insets = UIFactory.getEmptyInsets();
            gbc.gridwidth = isPortField || isAdminConnectorPortField || isSecurityField && this.canUpdateSecurity ? 3 : -1;
            gbc.weightx = 0.0;
            if (isSecurityField) {
                gbc.insets.top = securityInsetsTop;
                if (this.canUpdateSecurity) {
                    auxPanel.add((Component)this.lSecurity, gbc);
                } else {
                    auxPanel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.WARNING, QuickSetupMessages.INFO_CANNOT_UPDATE_SECURITY_WARNING.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID), gbc);
                }
            } else {
                auxPanel.add((Component)this.getField(fieldName), gbc);
            }
            if (isPortField) {
                l = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, this.getPortHelpMessage(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
                gbc.gridwidth = -1;
                gbc.insets.left = 5;
                auxPanel.add((Component)l, gbc);
            } else if (isAdminConnectorPortField) {
                l = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, this.getAdminConnectorPortHelpMessage(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
                gbc.gridwidth = -1;
                gbc.insets.left = 5;
                auxPanel.add((Component)l, gbc);
            } else if (isSecurityField && this.canUpdateSecurity) {
                gbc.gridwidth = -1;
                gbc.insets.left = 10;
                gbc.anchor = 18;
                gbc.insets.top = 0;
                auxPanel.add((Component)this.getLDAPSecureAccessButton(), gbc);
            }
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            auxPanel.add(Box.createHorizontalGlue(), gbc);
        }
        this.addVerticalGlue(panel);
        return panel;
    }

    protected Message getInstructions() {
        if (Utils.isWebStart()) {
            return QuickSetupMessages.INFO_SERVER_SETTINGS_PANEL_INSTRUCTIONS_WEBSTART.get();
        }
        return QuickSetupMessages.INFO_SERVER_SETTINGS_PANEL_INSTRUCTIONS.get();
    }

    protected Message getTitle() {
        return QuickSetupMessages.INFO_SERVER_SETTINGS_PANEL_TITLE.get();
    }

    public void endDisplay() {
        if (this.lastFocusComponent != null) {
            this.lastFocusComponent.requestFocusInWindow();
        }
    }

    private String getDefaultValue(FieldName fieldName) {
        String value = null;
        switch (fieldName) {
            case SERVER_LOCATION: {
                value = this.defaultUserData.getServerLocation();
                break;
            }
            case HOST_NAME: {
                value = this.defaultUserData.getHostName();
                break;
            }
            case SERVER_PORT: {
                if (this.defaultUserData.getServerPort() > 0) {
                    value = String.valueOf(this.defaultUserData.getServerPort());
                    break;
                }
                value = "";
                break;
            }
            case ADMIN_CONNECTOR_PORT: {
                if (this.defaultUserData.getAdminConnectorPort() > 0) {
                    value = String.valueOf(this.defaultUserData.getAdminConnectorPort());
                    break;
                }
                value = "";
                break;
            }
            case DIRECTORY_MANAGER_DN: {
                value = this.defaultUserData.getDirectoryManagerDn();
                break;
            }
            case DIRECTORY_MANAGER_PWD: {
                value = this.defaultUserData.getDirectoryManagerPwd();
                break;
            }
            case DIRECTORY_MANAGER_PWD_CONFIRM: {
                value = this.defaultUserData.getDirectoryManagerPwd();
                break;
            }
            case SECURITY_OPTIONS: {
                value = ServerSettingsPanel.getSecurityOptionsString(this.defaultUserData.getSecurityOptions(), true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown field name: " + (Object)((Object)fieldName));
            }
        }
        return value;
    }

    private void populateLabelAndFieldMaps() {
        int index;
        HashMap<FieldName, LabelFieldDescriptor> hm = new HashMap<FieldName, LabelFieldDescriptor>();
        hm.put(FieldName.HOST_NAME, new LabelFieldDescriptor(QuickSetupMessages.INFO_HOST_NAME_LABEL.get(), QuickSetupMessages.INFO_HOST_NAME_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.PRIMARY, 20));
        hm.put(FieldName.SERVER_PORT, new LabelFieldDescriptor(QuickSetupMessages.INFO_SERVER_PORT_LABEL.get(), QuickSetupMessages.INFO_SERVER_PORT_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.PRIMARY, 5));
        hm.put(FieldName.ADMIN_CONNECTOR_PORT, new LabelFieldDescriptor(QuickSetupMessages.INFO_ADMIN_CONNECTOR_PORT_LABEL.get(), QuickSetupMessages.INFO_ADMIN_CONNECTOR_PORT_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.PRIMARY, 5));
        hm.put(FieldName.SECURITY_OPTIONS, new LabelFieldDescriptor(QuickSetupMessages.INFO_SERVER_SECURITY_LABEL.get(), QuickSetupMessages.INFO_SERVER_SECURITY_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        hm.put(FieldName.DIRECTORY_MANAGER_DN, new LabelFieldDescriptor(QuickSetupMessages.INFO_SERVER_DIRECTORY_MANAGER_DN_LABEL.get(), QuickSetupMessages.INFO_SERVER_DIRECTORY_MANAGER_DN_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.PRIMARY, 20));
        hm.put(FieldName.DIRECTORY_MANAGER_PWD, new LabelFieldDescriptor(QuickSetupMessages.INFO_SERVER_DIRECTORY_MANAGER_PWD_LABEL.get(), QuickSetupMessages.INFO_SERVER_DIRECTORY_MANAGER_PWD_TOOLTIP.get(), LabelFieldDescriptor.FieldType.PASSWORD, LabelFieldDescriptor.LabelType.PRIMARY, 15));
        hm.put(FieldName.DIRECTORY_MANAGER_PWD_CONFIRM, new LabelFieldDescriptor(QuickSetupMessages.INFO_SERVER_DIRECTORY_MANAGER_PWD_CONFIRM_LABEL.get(), QuickSetupMessages.INFO_SERVER_DIRECTORY_MANAGER_PWD_CONFIRM_TOOLTIP.get(), LabelFieldDescriptor.FieldType.PASSWORD, LabelFieldDescriptor.LabelType.PRIMARY, 15));
        for (FieldName fieldName : hm.keySet()) {
            LabelFieldDescriptor desc = (LabelFieldDescriptor)hm.get((Object)fieldName);
            String defaultValue = this.getDefaultValue(fieldName);
            JLabel label = UIFactory.makeJLabel(desc);
            if (fieldName != FieldName.SECURITY_OPTIONS) {
                JTextComponent field = UIFactory.makeJTextComponent(desc, defaultValue);
                this.hmFields.put(fieldName, field);
                label.setLabelFor(field);
            } else {
                this.lSecurity = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, Message.raw(defaultValue, new Object[0]), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
            }
            this.hmLabels.put(fieldName, label);
        }
        LabelFieldDescriptor desc = new LabelFieldDescriptor(QuickSetupMessages.INFO_SERVER_LOCATION_LABEL.get(), QuickSetupMessages.INFO_SERVER_LOCATION_PARENT_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.PRIMARY, 20);
        this.lServerLocation = UIFactory.makeJLabel(desc);
        this.tfServerLocationParent = UIFactory.makeJTextComponent(desc, "");
        this.lServerLocation.setLabelFor(this.tfServerLocationParent);
        this.hmLabels.put(FieldName.SERVER_LOCATION, this.lServerLocation);
        desc = new LabelFieldDescriptor(QuickSetupMessages.INFO_SERVER_LOCATION_LABEL.get(), QuickSetupMessages.INFO_SERVER_LOCATION_RELATIVE_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.PRIMARY, 10);
        this.tfServerLocationRelativePath = UIFactory.makeJTextComponent(desc, "");
        String defaultPath = this.getDefaultValue(FieldName.SERVER_LOCATION);
        if (defaultPath != null && (index = defaultPath.lastIndexOf(File.separator)) != -1) {
            String parent = defaultPath.substring(0, index);
            String relativeDir = defaultPath.substring(index + 1);
            this.tfServerLocationParent.setText(parent);
            this.tfServerLocationRelativePath.setText(relativeDir);
        }
    }

    private JButton getBrowseButton() {
        if (this.browseButton == null) {
            this.browseButton = UIFactory.makeJButton(QuickSetupMessages.INFO_BROWSE_BUTTON_LABEL.get(), QuickSetupMessages.INFO_BROWSE_BUTTON_TOOLTIP.get());
            BrowseActionListener l = new BrowseActionListener(this.tfServerLocationParent, BrowseActionListener.BrowseType.LOCATION_DIRECTORY, this.getMainWindow());
            this.browseButton.addActionListener(l);
        }
        return this.browseButton;
    }

    private JButton getLDAPSecureAccessButton() {
        if (this.secureAccessButton == null) {
            this.secureAccessButton = UIFactory.makeJButton(QuickSetupMessages.INFO_SERVER_SECURITY_BUTTON_LABEL.get(), QuickSetupMessages.INFO_SERVER_SECURITY_BUTTON_TOOLTIP.get());
            this.secureAccessButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ServerSettingsPanel.this.getConfigureSecureAccessDialog().display(ServerSettingsPanel.this.securityOptions);
                    if (!ServerSettingsPanel.this.getConfigureSecureAccessDialog().isCancelled()) {
                        ServerSettingsPanel.this.securityOptions = ServerSettingsPanel.this.getConfigureSecureAccessDialog().getSecurityOptions();
                        ServerSettingsPanel.this.lSecurity.setText(QuickSetupStepPanel.getSecurityOptionsString(ServerSettingsPanel.this.securityOptions, true));
                    }
                }
            });
        }
        return this.secureAccessButton;
    }

    private JLabel getLabel(FieldName fieldName) {
        return this.hmLabels.get((Object)fieldName);
    }

    private JTextComponent getField(FieldName fieldName) {
        return this.hmFields.get((Object)fieldName);
    }

    private void addFocusListeners() {
        FocusListener l = new FocusListener(){

            public void focusGained(FocusEvent e) {
                ServerSettingsPanel.this.lastFocusComponent = e.getComponent();
            }

            public void focusLost(FocusEvent e) {
            }
        };
        for (JTextComponent tf : this.hmFields.values()) {
            tf.addFocusListener(l);
        }
        this.getLDAPSecureAccessButton().addFocusListener(l);
        this.getBrowseButton().addFocusListener(l);
        this.lastFocusComponent = Utils.isWebStart() ? this.tfServerLocationRelativePath : this.getField(FieldName.DIRECTORY_MANAGER_PWD);
    }

    private Message getAdminConnectorPortHelpMessage() {
        Message s = Message.EMPTY;
        if (this.defaultUserData.getAdminConnectorPort() != 4444) {
            s = QuickSetupMessages.INFO_CANNOT_USE_DEFAULT_ADMIN_CONNECTOR_PORT.get();
        }
        return s;
    }

    private Message getPortHelpMessage() {
        Message s = Message.EMPTY;
        if (this.defaultUserData.getServerPort() != 389) {
            s = QuickSetupMessages.INFO_CANNOT_USE_DEFAULT_PORT.get();
        }
        return s;
    }

    private SecurityOptionsDialog getConfigureSecureAccessDialog() {
        if (this.dlg == null) {
            this.dlg = new SecurityOptionsDialog((JFrame)this.getMainWindow(), this.securityOptions);
            this.dlg.setModal(true);
        }
        return this.dlg;
    }
}

