/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.renderer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.opends.guitools.controlpanel.datamodel.BinaryValue;
import org.opends.guitools.controlpanel.datamodel.ObjectClassValue;
import org.opends.guitools.controlpanel.ui.components.BinaryCellPanel;
import org.opends.guitools.controlpanel.ui.components.ObjectClassCellPanel;
import org.opends.guitools.controlpanel.ui.renderer.SelectableTableCellRenderer;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.server.types.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPEntryTableCellRenderer
extends SelectableTableCellRenderer {
    private static final long serialVersionUID = 3590456676685339618L;
    private BinaryCellPanel binaryPanel;
    private ObjectClassCellPanel ocPanel;
    private JLabel lockLabel = new JLabel();
    private ImageIcon lockIcon = Utilities.createImageIcon("org/opends/guitools/controlpanel/images/field-locked.png");
    private Schema schema;
    private Collection<String> requiredAttrs = new ArrayList<String>();

    public LDAPEntryTableCellRenderer() {
        this.binaryPanel = new BinaryCellPanel();
        this.binaryPanel.setOpaque(true);
        this.ocPanel = new ObjectClassCellPanel();
        this.ocPanel.setOpaque(true);
        GridBagConstraints gbc = new GridBagConstraints();
        this.add((Component)this.lockLabel, gbc);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.isRequired(table, row, column)) {
            Utilities.setRequiredIcon(this.label);
        } else {
            this.label.setIcon(null);
        }
        if (this.isPassword(table, row, column)) {
            return this.getStringValue(table, "********", isSelected, hasFocus, row, column);
        }
        if (value instanceof ObjectClassValue) {
            if (!table.isCellEditable(row, column)) {
                this.ocPanel.setLockIconVisible(true);
                this.ocPanel.setEditButtonVisible(false);
            } else {
                this.ocPanel.setLockIconVisible(false);
                this.ocPanel.setEditButtonVisible(true);
            }
            this.ocPanel.setValue((ObjectClassValue)value);
            if (hasFocus) {
                this.ocPanel.setBorder(LDAPEntryTableCellRenderer.getDefaultFocusBorder(table, value, isSelected, row, column));
            } else {
                this.ocPanel.setBorder(defaultBorder);
            }
            this.updateComponent(this.ocPanel, table, row, column, isSelected);
            return this.ocPanel;
        }
        if (value instanceof byte[] || value instanceof BinaryValue) {
            if (value instanceof byte[]) {
                if (((byte[])value).length > 0) {
                    this.binaryPanel.setValue((byte[])value, this.isImage(table, row, column));
                } else {
                    this.binaryPanel.setValue((byte[])null, this.isImage(table, row, column));
                }
            } else {
                this.binaryPanel.setValue((BinaryValue)value, this.isImage(table, row, column));
            }
            if (!table.isCellEditable(row, column)) {
                this.binaryPanel.setLockIconVisible(true);
                this.binaryPanel.setEditButtonText(AdminToolMessages.INFO_CTRL_PANEL_VIEW_BUTTON_LABEL.get());
            } else {
                this.binaryPanel.setLockIconVisible(false);
                this.binaryPanel.setEditButtonText(AdminToolMessages.INFO_CTRL_PANEL_EDIT_BUTTON_LABEL.get());
            }
            if (hasFocus) {
                this.binaryPanel.setBorder(LDAPEntryTableCellRenderer.getDefaultFocusBorder(table, value, isSelected, row, column));
            } else {
                this.binaryPanel.setBorder(defaultBorder);
            }
            this.updateComponent(this.binaryPanel, table, row, column, isSelected);
            return this.binaryPanel;
        }
        return this.getStringValue(table, value, isSelected, hasFocus, row, column);
    }

    public String getString(byte[] value) {
        return this.binaryPanel.getString(value, false).toString();
    }

    public String getString(BinaryValue value) {
        return this.binaryPanel.getMessage(value, false).toString();
    }

    public String getString(ObjectClassValue value) {
        return this.ocPanel.getMessage(value).toString();
    }

    private Component getStringValue(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (table.isCellEditable(row, column) && !isSelected) {
            this.lockLabel.setIcon(null);
        } else if (column == 1 && !table.isCellEditable(row, column)) {
            this.lockLabel.setIcon(this.lockIcon);
        } else {
            this.lockLabel.setIcon(null);
        }
        return this;
    }

    private boolean isPassword(JTable table, int row, int col) {
        Object o;
        boolean isPassword = false;
        if (col == 1 && Utilities.hasPasswordSyntax((String)(o = table.getValueAt(row, 0)), this.getSchema())) {
            isPassword = true;
        }
        return isPassword;
    }

    private boolean isImage(JTable table, int row, int col) {
        boolean isImage = false;
        if (col == 1) {
            Object o = table.getValueAt(row, 0);
            isImage = Utilities.hasImageSyntax((String)o, this.schema);
        }
        return isImage;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setRequiredAttrs(Collection<String> requiredAttrs) {
        this.requiredAttrs.clear();
        this.requiredAttrs.addAll(requiredAttrs);
    }

    private boolean isRequired(JTable table, int row, int col) {
        boolean isRequired = false;
        if (col == 0) {
            Object o = table.getValueAt(row, 0);
            isRequired = this.requiredAttrs.contains(Utilities.getAttributeNameWithoutOptions((String)o).toLowerCase());
        }
        return isRequired;
    }
}

