/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.renderer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.opends.guitools.controlpanel.datamodel.CategorizedComboBoxElement;

public class CustomListCellRenderer
implements ListCellRenderer {
    private ListCellRenderer defaultRenderer;
    protected Component separator;
    protected Font defaultFont;
    protected Font categoryFont;

    public CustomListCellRenderer(JComboBox combo) {
        this(combo.getRenderer());
    }

    public CustomListCellRenderer(JList list) {
        this(list.getCellRenderer());
    }

    private CustomListCellRenderer(ListCellRenderer defaultRenderer) {
        this.defaultRenderer = defaultRenderer;
        JSeparator sep = new JSeparator();
        this.separator = new JPanel(new BorderLayout());
        ((JPanel)this.separator).setOpaque(false);
        ((JPanel)this.separator).add((Component)sep, "Center");
        ((JPanel)this.separator).setBorder(new EmptyBorder(5, 3, 5, 3));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component comp;
        if ("----------".equals(value)) {
            return this.separator;
        }
        if (value instanceof CategorizedComboBoxElement) {
            boolean isRegular;
            CategorizedComboBoxElement element = (CategorizedComboBoxElement)value;
            String name = this.getStringValue(element);
            boolean bl = isRegular = element.getType() == CategorizedComboBoxElement.Type.REGULAR;
            if (isRegular) {
                name = "    " + name;
            }
            comp = this.defaultRenderer.getListCellRendererComponent(list, name, index, isSelected && isRegular, cellHasFocus);
            if (this.defaultFont == null) {
                this.defaultFont = comp.getFont();
                this.categoryFont = this.defaultFont.deriveFont(3);
            }
            if (element.getType() == CategorizedComboBoxElement.Type.REGULAR) {
                comp.setFont(this.defaultFont);
            } else {
                comp.setFont(this.categoryFont);
            }
        } else {
            comp = this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (this.defaultFont == null) {
                this.defaultFont = comp.getFont();
                this.categoryFont = this.defaultFont.deriveFont(3);
            }
            comp.setFont(this.defaultFont);
        }
        return comp;
    }

    protected String getStringValue(CategorizedComboBoxElement desc) {
        return String.valueOf(desc.getValue());
    }
}

