/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opends.guitools.controlpanel.datamodel.Category;
import org.opends.guitools.controlpanel.ui.border.AccordionElementBorder;
import org.opends.guitools.controlpanel.ui.components.CategoryButton;

public class CategoryPanel
extends JPanel {
    private static final long serialVersionUID = 8941374689175404431L;
    private JPanel panel;
    private JComponent child;
    private Category category;
    private CategoryButton expandButton;
    private boolean expanded = true;
    static final Border categoryBorder = new AccordionElementBorder();

    public CategoryPanel(JComponent child, Category category) {
        this.child = child;
        this.setLayout(new BorderLayout());
        this.panel = new JPanel(new BorderLayout());
        this.add((Component)this.panel, "Center");
        this.panel.add((Component)child, "Center");
        this.expandButton = new CategoryButton(category);
        this.expandButton.setSelected(this.isExpanded());
        this.expandButton.addChangeListener(new CollapseListener());
        this.add((Component)this.expandButton, "North");
        this.category = category;
        this.setBorder(categoryBorder);
    }

    public void setExpanded(boolean expanded) {
        boolean oldExpanded = this.expanded;
        if (oldExpanded != expanded) {
            this.expandButton.setSelected(expanded);
            this.expanded = expanded;
            this.child.setVisible(expanded);
            this.firePropertyChange("expanded", oldExpanded, expanded);
        }
    }

    public Category getCategory() {
        return this.category;
    }

    public JComponent getChild() {
        return this.child;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setForeground(Color foreground) {
        super.setForeground(foreground);
        if (this.expandButton != null) {
            this.expandButton.setForeground(foreground);
        }
    }

    private class CollapseListener
    implements ChangeListener {
        private CollapseListener() {
        }

        public void stateChanged(ChangeEvent event) {
            CategoryPanel.this.setExpanded(CategoryPanel.this.expandButton.isSelected());
        }
    }
}

