/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import org.opends.guitools.controlpanel.datamodel.BasicMonitoringAttributes;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.MonitoringAttributes;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.ui.GeneralMonitoringPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;

public class SystemInformationMonitoringPanel
extends GeneralMonitoringPanel {
    private static final long serialVersionUID = 9031734563298069830L;
    static List<MonitoringAttributes> operations = new ArrayList<MonitoringAttributes>();
    private ArrayList<JLabel> monitoringLabels;

    public SystemInformationMonitoringPanel() {
        operations.add(BasicMonitoringAttributes.SYSTEM_NAME);
        operations.add(BasicMonitoringAttributes.OPERATING_SYSTEM);
        operations.add(BasicMonitoringAttributes.AVAILABLE_CPUS);
        operations.add(BasicMonitoringAttributes.USED_MEMORY);
        operations.add(BasicMonitoringAttributes.FREE_USED_MEMORY);
        operations.add(BasicMonitoringAttributes.MAX_MEMORY);
        this.monitoringLabels = new ArrayList();
        for (int i = 0; i < operations.size(); ++i) {
            this.monitoringLabels.add(Utilities.createDefaultLabel());
        }
        this.createLayout();
    }

    public Component getPreferredFocusComponent() {
        return this.monitoringLabels.get(0);
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel lTitle = Utilities.createTitleLabel(AdminToolMessages.INFO_CTRL_PANEL_SYSTEM_INFORMATION.get());
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets.top = 5;
        gbc.insets.bottom = 7;
        this.add((Component)lTitle, gbc);
        gbc.insets.bottom = 0;
        gbc.insets.top = 10;
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        for (int i = 0; i < operations.size(); ++i) {
            JLabel l = Utilities.createPrimaryLabel(SystemInformationMonitoringPanel.getLabel(operations.get(i)));
            ++gbc.gridy;
            gbc.insets.left = 0;
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.gridwidth = 1;
            this.add((Component)l, gbc);
            gbc.insets.left = 10;
            gbc.gridx = 1;
            gbc.gridwidth = 2;
            this.add((Component)this.monitoringLabels.get(i), gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 3;
        this.add(Box.createGlue(), gbc);
        this.setBorder(this.PANEL_BORDER);
    }

    public void updateContents() {
        ServerDescriptor server = null;
        if (this.getInfo() != null) {
            server = this.getInfo().getServerDescriptor();
        }
        CustomSearchResult csr = null;
        if (server != null) {
            csr = server.getSystemInformationMonitor();
        }
        if (csr != null) {
            this.updateMonitoringInfo(operations, this.monitoringLabels, csr);
        } else {
            for (JLabel l : this.monitoringLabels) {
                l.setText(NO_VALUE_SET.toString());
            }
        }
    }
}

