/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNTableModel;
import org.opends.guitools.controlpanel.datamodel.ConnectionHandlerDescriptor;
import org.opends.guitools.controlpanel.datamodel.ConnectionHandlerTableModel;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.ScrollPaneBorderListener;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.LabelWithHelpIcon;
import org.opends.guitools.controlpanel.ui.renderer.BaseDNCellRenderer;
import org.opends.guitools.controlpanel.ui.renderer.CustomCellRenderer;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.guitools.controlpanel.util.ViewPositions;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.types.DN;
import org.opends.server.types.OpenDsException;

class StatusPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -6493442314639004717L;
    private JLabel serverStatus;
    private LabelWithHelpIcon currentConnections;
    private JLabel hostName;
    private JLabel administrativeUsers;
    private JLabel installPath;
    private JLabel instancePath;
    private JLabel opendsVersion;
    private LabelWithHelpIcon javaVersion;
    private JLabel adminConnector;
    private JLabel dbTableEmpty;
    private JLabel connectionHandlerTableEmpty;
    private JLabel lInstancePath;
    private JButton stopButton;
    private JButton startButton;
    private JButton restartButton;
    private BaseDNTableModel dbTableModelWithReplication;
    private BaseDNTableModel dbTableModelWithoutReplication;
    private JTable noReplicatedBaseDNsTable;
    private JTable replicationBaseDNsTable;
    private ConnectionHandlerTableModel connectionHandlerTableModel;
    private JTable connectionHandlersTable;

    public StatusPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        this.createErrorPane();
        gbc.insets = new Insets(20, 20, 10, 20);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.errorPane, gbc);
        JPanel inScrollPanel = new JPanel(new GridBagLayout());
        inScrollPanel.setOpaque(false);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        JScrollPane scroll = Utilities.createBorderLessScrollBar(inScrollPanel);
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)scroll, gbc);
        ScrollPaneBorderListener.createFullBorderListener(scroll);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(15, 10, 0, 10);
        gbc.weighty = 0.0;
        inScrollPanel.add((Component)this.createServerStatusPanel(), gbc);
        ++gbc.gridy;
        inScrollPanel.add((Component)this.createServerDetailsPanel(), gbc);
        gbc.insets.left += 3;
        gbc.insets.right += 3;
        ++gbc.gridy;
        inScrollPanel.add((Component)this.createListenersPanel(), gbc);
        ++gbc.gridy;
        gbc.insets.bottom = 20;
        inScrollPanel.add((Component)this.createBackendsPanel(), gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 3;
        inScrollPanel.add(Box.createVerticalGlue(), gbc);
    }

    public Component getPreferredFocusComponent() {
        if (this.startButton.isVisible()) {
            return this.startButton;
        }
        return this.stopButton;
    }

    public boolean requiresBorder() {
        return false;
    }

    private void recalculateSizes() {
        Utilities.updateTableSizes(this.replicationBaseDNsTable);
        Utilities.updateTableSizes(this.noReplicatedBaseDNsTable);
        Utilities.updateTableSizes(this.connectionHandlersTable);
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_STATUS_PANEL_TITLE.get();
    }

    public void configurationChanged(final ConfigurationChangeEvent ev) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateContents(ev.getNewDescriptor());
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatusPanel.this.updateContents(ev.getNewDescriptor());
                }
            });
        }
    }

    public void okClicked() {
    }

    public void updateContents(ServerDescriptor desc) {
        boolean sameInstallAndInstance;
        JScrollPane scroll = Utilities.getContainingScroll(this);
        ViewPositions pos = scroll != null ? Utilities.getViewPositions(scroll) : Utilities.getViewPositions(this);
        List<OpenDsException> exceptions = desc.getExceptions();
        if (exceptions.size() == 0) {
            boolean errorPaneVisible = false;
            if (desc.getStatus() == ServerDescriptor.ServerStatus.STARTED && !desc.isAuthenticated()) {
                errorPaneVisible = true;
                MessageBuilder mb = new MessageBuilder();
                mb.append(AdminToolMessages.INFO_CTRL_PANEL_AUTH_REQUIRED_TO_BROWSE_MONITORING_SUMMARY.get());
                mb.append("<br><br>" + this.getAuthenticateHTML());
                Message title = AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_SUMMARY.get();
                this.updateErrorPane(this.errorPane, title, ColorAndFontConstants.errorTitleFont, mb.toMessage(), ColorAndFontConstants.defaultFont);
            }
            if (this.errorPane.isVisible() != errorPaneVisible) {
                this.errorPane.setVisible(errorPaneVisible);
            }
        } else {
            ArrayList<Message> msgs = new ArrayList<Message>();
            for (OpenDsException oe : exceptions) {
                msgs.add(oe.getMessageObject());
            }
            Message title = AdminToolMessages.ERR_CTRL_PANEL_ERROR_READING_CONFIGURATION_SUMMARY.get();
            MessageBuilder mb = new MessageBuilder();
            for (Message error : msgs) {
                if (mb.length() > 0) {
                    mb.append("<br>");
                }
                mb.append(error);
            }
            if (desc.getStatus() == ServerDescriptor.ServerStatus.STARTED && !desc.isAuthenticated()) {
                mb.append(AdminToolMessages.INFO_CTRL_PANEL_AUTH_REQUIRED_TO_BROWSE_MONITORING_SUMMARY.get());
                mb.append("<br><br>" + this.getAuthenticateHTML());
            }
            this.updateErrorPane(this.errorPane, title, ColorAndFontConstants.errorTitleFont, mb.toMessage(), ColorAndFontConstants.defaultFont);
            if (!this.errorPane.isVisible()) {
                this.errorPane.setVisible(true);
            }
        }
        this.serverStatus.setText(desc.getStatus().toString().toLowerCase());
        boolean isRunning = desc.getStatus() == ServerDescriptor.ServerStatus.STARTED;
        boolean isAuthenticated = desc.isAuthenticated();
        this.startButton.setVisible(desc.getStatus() == ServerDescriptor.ServerStatus.STOPPED);
        this.restartButton.setVisible(isRunning);
        this.stopButton.setVisible(isRunning);
        if (!isRunning) {
            Utilities.setNotAvailableBecauseServerIsDown(this.currentConnections);
        } else if (!isAuthenticated) {
            Utilities.setNotAvailableBecauseAuthenticationIsRequired(this.currentConnections);
        } else {
            int nConnections = desc.getOpenConnections();
            if (nConnections >= 0) {
                Utilities.setTextValue(this.currentConnections, String.valueOf(nConnections));
            } else {
                Utilities.setNotAvailable(this.currentConnections);
            }
        }
        this.hostName.setText(desc.getHostname());
        Set<DN> rootUsers = desc.getAdministrativeUsers();
        TreeSet<String> sortedRootUsers = new TreeSet<String>();
        for (DN dn : rootUsers) {
            try {
                sortedRootUsers.add(Utilities.unescapeUtf8(dn.toString()));
            }
            catch (Throwable t) {
                throw new IllegalStateException("Unexpected error: " + t, t);
            }
        }
        String htmlString = "<html>" + Utilities.applyFont(Utilities.getStringFromCollection(sortedRootUsers, "<br>"), this.administrativeUsers.getFont());
        this.administrativeUsers.setText(htmlString);
        File install = desc.getInstallPath();
        this.installPath.setText(install.getAbsolutePath());
        File instance = desc.getInstancePath();
        this.instancePath.setText(instance.getAbsolutePath());
        try {
            sameInstallAndInstance = instance.getCanonicalFile().equals(install);
        }
        catch (IOException ioe) {
            sameInstallAndInstance = instance.getAbsoluteFile().equals(install);
        }
        this.instancePath.setVisible(!sameInstallAndInstance);
        this.lInstancePath.setVisible(!sameInstallAndInstance);
        this.opendsVersion.setText(desc.getOpenDSVersion());
        if (!isRunning) {
            Utilities.setNotAvailableBecauseServerIsDown(this.javaVersion);
        } else if (!isAuthenticated) {
            Utilities.setNotAvailableBecauseAuthenticationIsRequired(this.javaVersion);
        } else {
            String jVersion = desc.getJavaVersion();
            if (jVersion != null) {
                Utilities.setTextValue(this.javaVersion, jVersion);
            } else {
                Utilities.setNotAvailable(this.javaVersion);
            }
        }
        this.adminConnector.setText(StatusPanel.getAdminConnectorStringValue(desc.getAdminConnector()));
        HashSet<BaseDNDescriptor> baseDNs = new HashSet<BaseDNDescriptor>();
        for (BackendDescriptor backend : desc.getBackends()) {
            if (backend.isConfigBackend()) continue;
            baseDNs.addAll(backend.getBaseDns());
        }
        boolean oneReplicated = false;
        for (BaseDNDescriptor baseDN : baseDNs) {
            if (baseDN.getType() != BaseDNDescriptor.Type.REPLICATED) continue;
            oneReplicated = true;
            break;
        }
        boolean hasBaseDNs = baseDNs.size() > 0;
        this.replicationBaseDNsTable.setVisible(oneReplicated && hasBaseDNs);
        this.replicationBaseDNsTable.getTableHeader().setVisible(oneReplicated && hasBaseDNs);
        this.noReplicatedBaseDNsTable.setVisible(!oneReplicated && hasBaseDNs);
        this.noReplicatedBaseDNsTable.getTableHeader().setVisible(!oneReplicated && hasBaseDNs);
        this.dbTableEmpty.setVisible(!hasBaseDNs);
        this.dbTableModelWithReplication.setData(baseDNs, desc.getStatus(), desc.isAuthenticated());
        this.dbTableModelWithoutReplication.setData(baseDNs, desc.getStatus(), desc.isAuthenticated());
        Set<ConnectionHandlerDescriptor> connectionHandlers = desc.getConnectionHandlers();
        this.connectionHandlerTableModel.setData(connectionHandlers);
        boolean hasConnectionHandlers = connectionHandlers.size() > 0;
        this.connectionHandlersTable.setVisible(hasConnectionHandlers);
        this.connectionHandlersTable.getTableHeader().setVisible(hasConnectionHandlers);
        this.connectionHandlerTableEmpty.setVisible(!hasConnectionHandlers);
        this.recalculateSizes();
        Utilities.updateViewPositions(pos);
    }

    private JPanel createServerStatusPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        p.setBorder(Utilities.makeTitledBorder(AdminToolMessages.INFO_CTRL_PANEL_SERVER_STATUS_TITLE_BORDER.get()));
        JPanel auxPanel = new JPanel(new GridBagLayout());
        auxPanel.setOpaque(false);
        gbc.anchor = 17;
        gbc.gridwidth = -1;
        JLabel l = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_SERVER_STATUS_LABEL.get());
        auxPanel.add((Component)l, gbc);
        JPanel statusPanel = new JPanel(new GridBagLayout());
        statusPanel.setOpaque(false);
        gbc.gridwidth = 6;
        gbc.weightx = 0.0;
        this.serverStatus = Utilities.createDefaultLabel();
        statusPanel.add((Component)this.serverStatus, gbc);
        --gbc.gridwidth;
        this.stopButton = Utilities.createButton(AdminToolMessages.INFO_STOP_BUTTON_LABEL.get());
        this.stopButton.setOpaque(false);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                StatusPanel.this.stopServer();
            }
        });
        gbc.insets.left = 10;
        statusPanel.add((Component)this.stopButton, gbc);
        --gbc.gridwidth;
        gbc.insets.left = 10;
        this.startButton = Utilities.createButton(AdminToolMessages.INFO_START_BUTTON_LABEL.get());
        this.startButton.setOpaque(false);
        statusPanel.add((Component)this.startButton, gbc);
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                StatusPanel.this.startServer();
            }
        });
        --gbc.gridwidth;
        gbc.insets.left = 5;
        this.restartButton = Utilities.createButton(AdminToolMessages.INFO_RESTART_BUTTON_LABEL.get());
        this.restartButton.setOpaque(false);
        this.restartButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                StatusPanel.this.restartServer();
            }
        });
        statusPanel.add((Component)this.restartButton, gbc);
        gbc.gridwidth = -1;
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        statusPanel.add(Box.createHorizontalGlue(), gbc);
        int maxButtonHeight = 0;
        maxButtonHeight = Math.max(maxButtonHeight, (int)this.startButton.getPreferredSize().getHeight());
        maxButtonHeight = Math.max(maxButtonHeight, (int)this.restartButton.getPreferredSize().getHeight());
        maxButtonHeight = Math.max(maxButtonHeight, (int)this.stopButton.getPreferredSize().getHeight());
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        statusPanel.add(Box.createVerticalStrut(maxButtonHeight), gbc);
        gbc.weightx = 1.0;
        gbc.insets.left = 5;
        auxPanel.add((Component)statusPanel, gbc);
        gbc.insets.left = 0;
        gbc.weightx = 0.0;
        gbc.insets.top = 5;
        gbc.gridwidth = -1;
        l = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OPEN_CONNECTIONS_LABEL.get());
        auxPanel.add((Component)l, gbc);
        this.currentConnections = new LabelWithHelpIcon(Message.EMPTY, null);
        gbc.gridwidth = 0;
        gbc.insets.left = 5;
        auxPanel.add((Component)this.currentConnections, gbc);
        gbc.insets.top = 2;
        gbc.insets.right = 5;
        gbc.insets.left = 5;
        gbc.insets.bottom = 5;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        p.add((Component)auxPanel, gbc);
        this.restartButton.setVisible(false);
        this.stopButton.setVisible(false);
        return p;
    }

    private JPanel createServerDetailsPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        p.setBorder(Utilities.makeTitledBorder(AdminToolMessages.INFO_CTRL_PANEL_SERVER_DETAILS_TITLE_BORDER.get()));
        JPanel auxPanel = new JPanel(new GridBagLayout());
        auxPanel.setOpaque(false);
        gbc.anchor = 18;
        gbc.weightx = 0.0;
        JLabel[] leftLabels = new JLabel[]{Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_HOST_NAME_LABEL.get()), Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ADMINISTRATIVE_USERS_LABEL.get()), Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_INSTALLATION_PATH_LABEL.get()), Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_INSTANCE_PATH_LABEL.get()), Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OPENDS_VERSION_LABEL.get()), Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_JAVA_VERSION_LABEL.get()), Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ADMIN_CONNECTOR_LABEL.get())};
        this.lInstancePath = leftLabels[3];
        this.hostName = Utilities.createDefaultLabel();
        this.administrativeUsers = Utilities.createDefaultLabel();
        this.installPath = Utilities.createDefaultLabel();
        this.instancePath = Utilities.createDefaultLabel();
        this.opendsVersion = Utilities.createDefaultLabel();
        this.javaVersion = new LabelWithHelpIcon(Message.EMPTY, null);
        this.adminConnector = Utilities.createDefaultLabel();
        JComponent[] rightLabels = new JComponent[]{this.hostName, this.administrativeUsers, this.installPath, this.instancePath, this.opendsVersion, this.javaVersion, this.adminConnector};
        for (int i = 0; i < leftLabels.length; ++i) {
            gbc.insets.left = 0;
            if (i != 0) {
                gbc.insets.top = 5;
            }
            gbc.gridwidth = -1;
            auxPanel.add((Component)leftLabels[i], gbc);
            gbc.gridwidth = 0;
            gbc.insets.left = 5;
            auxPanel.add((Component)rightLabels[i], gbc);
        }
        gbc.insets.top = 2;
        gbc.insets.right = 5;
        gbc.insets.left = 5;
        gbc.insets.bottom = 5;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        p.add((Component)auxPanel, gbc);
        return p;
    }

    private JPanel createListenersPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        JLabel l = Utilities.createTitleLabel(AdminToolMessages.INFO_CTRL_PANEL_CONNECTION_HANDLERS.get());
        p.add((Component)l, gbc);
        this.connectionHandlerTableModel = new ConnectionHandlerTableModel();
        this.connectionHandlersTable = Utilities.createSortableTable(this.connectionHandlerTableModel, new CustomCellRenderer());
        gbc.insets.top = 5;
        p.add((Component)this.connectionHandlersTable.getTableHeader(), gbc);
        gbc.insets.top = 0;
        p.add((Component)this.connectionHandlersTable, gbc);
        this.connectionHandlerTableEmpty = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_CONNECTION_HANDLER_FOUND.get());
        this.connectionHandlerTableEmpty.setHorizontalAlignment(0);
        gbc.insets.top = 5;
        p.add((Component)this.connectionHandlerTableEmpty, gbc);
        this.connectionHandlerTableEmpty.setVisible(false);
        return p;
    }

    private JPanel createBackendsPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        JLabel l = Utilities.createTitleLabel(AdminToolMessages.INFO_CTRL_PANEL_DATA_SOURCES.get());
        p.add((Component)l, gbc);
        this.dbTableModelWithReplication = new BaseDNTableModel(true);
        this.dbTableModelWithoutReplication = new BaseDNTableModel(false);
        this.noReplicatedBaseDNsTable = Utilities.createSortableTable(this.dbTableModelWithoutReplication, new BaseDNCellRenderer());
        this.noReplicatedBaseDNsTable.setVisible(false);
        this.noReplicatedBaseDNsTable.getTableHeader().setVisible(false);
        this.replicationBaseDNsTable = Utilities.createSortableTable(this.dbTableModelWithReplication, new BaseDNCellRenderer());
        gbc.insets.top = 5;
        p.add((Component)this.noReplicatedBaseDNsTable.getTableHeader(), gbc);
        gbc.insets.top = 0;
        p.add((Component)this.noReplicatedBaseDNsTable, gbc);
        gbc.insets.top = 5;
        p.add((Component)this.replicationBaseDNsTable.getTableHeader(), gbc);
        gbc.insets.top = 0;
        p.add((Component)this.replicationBaseDNsTable, gbc);
        this.replicationBaseDNsTable.setVisible(true);
        this.replicationBaseDNsTable.getTableHeader().setVisible(true);
        gbc.insets.top = 5;
        this.dbTableEmpty = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_DATA_SOURCES_FOUND.get());
        this.dbTableEmpty.setHorizontalAlignment(0);
        gbc.anchor = 10;
        p.add((Component)this.dbTableEmpty, gbc);
        this.dbTableEmpty.setVisible(false);
        return p;
    }

    private static String getAdminConnectorStringValue(ConnectionHandlerDescriptor adminConnector) {
        if (adminConnector != null) {
            return AdminToolMessages.INFO_CTRL_PANEL_ADMIN_CONNECTOR_DESCRIPTION.get(adminConnector.getPort()).toString();
        }
        return AdminToolMessages.INFO_NOT_AVAILABLE_SHORT_LABEL.get().toString();
    }
}

