/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.ui.AbstractNewEntryPanel;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.util.LDIFException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewEntryFromLDIFPanel
extends AbstractNewEntryPanel {
    private static final long serialVersionUID = -3923907357481784964L;
    private JTextArea ldif;
    private JButton checkSyntax;

    public NewEntryFromLDIFPanel() {
        this.createLayout();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.ldif;
    }

    @Override
    public boolean requiresScroll() {
        return false;
    }

    @Override
    public void setParent(BasicNode parentNode, BrowserController controller) {
        super.setParent(parentNode, controller);
        StringBuilder sb = new StringBuilder();
        String emptyDn = "dn: ";
        sb.append("dn: ");
        if (parentNode != null) {
            sb.append("," + parentNode.getDN());
        }
        sb.append("\nobjectClass: top");
        this.ldif.setText(sb.toString());
        this.ldif.setCaretPosition("dn: ".length());
    }

    @Override
    protected Message getProgressDialogTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_ENTRY_FROM_LDIF_TITLE.get();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_ENTRY_FROM_LDIF_TITLE.get();
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridy = 0;
        this.addErrorPane(gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.insets.left = 0;
        gbc.weightx = 1.0;
        JLabel label = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_LDIF_SYNTAX_LABEL.get());
        this.add((Component)label, gbc);
        this.ldif = Utilities.createTextArea(Message.EMPTY, 20, 50);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JScrollPane scroll = Utilities.createScrollPane(this.ldif);
        ++gbc.gridy;
        gbc.insets.top = 5;
        gbc.fill = 1;
        this.add((Component)scroll, gbc);
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.checkSyntax = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_CHECK_SYNTAX_BUTTON.get());
        this.checkSyntax.setOpaque(false);
        this.checkSyntax.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ArrayList<Message> errors = new ArrayList<Message>();
                NewEntryFromLDIFPanel.this.checkSyntax(errors);
                if (errors.size() > 0) {
                    NewEntryFromLDIFPanel.this.displayErrorDialog(errors);
                }
            }
        });
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.anchor = 17;
        this.add((Component)this.checkSyntax, gbc);
    }

    @Override
    protected void checkSyntax(ArrayList<Message> errors) {
        try {
            this.getEntry();
        }
        catch (IOException ioe) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_ERROR_CHECKING_ENTRY.get(ioe.toString()));
        }
        catch (LDIFException le) {
            errors.add(le.getMessageObject());
        }
    }

    @Override
    protected String getLDIF() {
        return this.ldif.getText();
    }
}

