/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreePath;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.EntryReadErrorEvent;
import org.opends.guitools.controlpanel.event.EntryReadEvent;
import org.opends.guitools.controlpanel.event.EntryReadListener;
import org.opends.guitools.controlpanel.event.LDAPEntryChangedEvent;
import org.opends.guitools.controlpanel.event.LDAPEntryChangedListener;
import org.opends.guitools.controlpanel.task.DeleteEntryTask;
import org.opends.guitools.controlpanel.task.ModifyEntryTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ErrorSearchingEntryPanel;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.LDIFViewEntryPanel;
import org.opends.guitools.controlpanel.ui.NoItemSelectedPanel;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.SimplifiedViewEntryPanel;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.TableViewEntryPanel;
import org.opends.guitools.controlpanel.ui.UnsavedChangesDialog;
import org.opends.guitools.controlpanel.ui.ViewEntryPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.OpenDsException;

public class LDAPEntryPanel
extends StatusGenericPanel
implements EntryReadListener {
    private static final long serialVersionUID = -6608246173472437830L;
    private JButton saveChanges;
    private JButton delete;
    private JPanel mainPanel;
    private CardLayout cardLayout;
    private ErrorSearchingEntryPanel errorSearchingPanel;
    private LDIFViewEntryPanel ldifEntryPanel;
    private TableViewEntryPanel tableEntryPanel;
    private SimplifiedViewEntryPanel simplifiedEntryPanel;
    private ViewEntryPanel displayedEntryPanel;
    private CustomSearchResult searchResult;
    private BrowserController controller;
    private TreePath treePath;
    private ModifyEntryTask newTask;
    private final String NOTHING_SELECTED = "Nothing Selected";
    private final String MULTIPLE_SELECTED = "Multiple Selected";
    private final String LDIF_VIEW = "LDIF View";
    private final String ATTRIBUTE_VIEW = "Attribute View";
    private final String SIMPLIFIED_VIEW = "Simplified View";
    private final String ERROR_SEARCHING = "Error Searching";
    private View view = View.SIMPLIFIED_VIEW;
    private DN[] parentReadOnly;
    private DN[] nonDeletable;

    public LDAPEntryPanel() {
        try {
            this.parentReadOnly = new DN[]{DN.decode("cn=Tasks"), DN.decode("cn=monitor"), DN.decode("cn=backups"), DN.decode("dc=replicationChanges")};
            this.nonDeletable = new DN[]{DN.decode("cn=config"), DN.decode("cn=schema"), DN.decode("cn=ads-truststore")};
        }
        catch (Throwable t) {
            throw new IllegalStateException("Error decoding DNs: " + t, t);
        }
        this.createLayout();
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.cardLayout = new CardLayout();
        this.mainPanel = new JPanel(this.cardLayout);
        this.mainPanel.setOpaque(false);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.mainPanel, gbc);
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.weighty = 0.0;
        ++gbc.gridy;
        gbc.fill = 0;
        this.delete = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_DELETE_ENTRY_BUTTON.get());
        this.delete.setOpaque(false);
        this.add((Component)this.delete, gbc);
        this.delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LDAPEntryPanel.this.deleteEntry();
            }
        });
        gbc.anchor = 13;
        ++gbc.gridx;
        this.saveChanges = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_SAVE_CHANGES_LABEL.get());
        this.saveChanges.setOpaque(false);
        this.add((Component)this.saveChanges, gbc);
        this.saveChanges.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LDAPEntryPanel.this.saveChanges(true);
            }
        });
        EmptyBorder border = new EmptyBorder(10, 10, 10, 10);
        NoItemSelectedPanel noEntryPanel = new NoItemSelectedPanel();
        noEntryPanel.setMessage(AdminToolMessages.INFO_CTRL_PANEL_NO_ENTRY_SELECTED_LABEL.get());
        Utilities.setBorder(noEntryPanel, border);
        this.mainPanel.add((Component)noEntryPanel, "Nothing Selected");
        NoItemSelectedPanel multipleEntryPanel = new NoItemSelectedPanel();
        multipleEntryPanel.setMessage(AdminToolMessages.INFO_CTRL_PANEL_MULTIPLE_ENTRIES_SELECTED_LABEL.get());
        Utilities.setBorder(multipleEntryPanel, border);
        this.mainPanel.add((Component)multipleEntryPanel, "Multiple Selected");
        this.errorSearchingPanel = new ErrorSearchingEntryPanel();
        if (this.errorSearchingPanel.requiresBorder()) {
            Utilities.setBorder(multipleEntryPanel, border);
        }
        this.mainPanel.add((Component)this.errorSearchingPanel, "Error Searching");
        LDAPEntryChangedListener listener = new LDAPEntryChangedListener(){

            public void entryChanged(LDAPEntryChangedEvent ev) {
                boolean enable;
                boolean bl = enable = LDAPEntryPanel.this.saveChanges.isVisible() && !LDAPEntryPanel.this.authenticationRequired(LDAPEntryPanel.this.getInfo().getServerDescriptor());
                if (enable) {
                    boolean modified;
                    enable = ev.getEntry() == null ? true : (modified = !Utilities.areDnsEqual(ev.getEntry().getDN().toString(), LDAPEntryPanel.this.searchResult.getDN()) || !ModifyEntryTask.getModifications(ev.getEntry(), LDAPEntryPanel.this.searchResult, LDAPEntryPanel.this.getInfo()).isEmpty());
                }
                LDAPEntryPanel.this.saveChanges.setEnabled(enable);
            }
        };
        this.ldifEntryPanel = new LDIFViewEntryPanel();
        this.ldifEntryPanel.addLDAPEntryChangedListener(listener);
        if (this.ldifEntryPanel.requiresBorder()) {
            Utilities.setBorder(this.ldifEntryPanel, border);
        }
        this.mainPanel.add((Component)this.ldifEntryPanel, "LDIF View");
        this.tableEntryPanel = new TableViewEntryPanel();
        this.tableEntryPanel.addLDAPEntryChangedListener(listener);
        if (this.tableEntryPanel.requiresBorder()) {
            Utilities.setBorder(this.tableEntryPanel, border);
        }
        this.mainPanel.add((Component)this.tableEntryPanel, "Attribute View");
        this.simplifiedEntryPanel = new SimplifiedViewEntryPanel();
        this.simplifiedEntryPanel.addLDAPEntryChangedListener(listener);
        if (this.simplifiedEntryPanel.requiresBorder()) {
            Utilities.setBorder(this.simplifiedEntryPanel, border);
        }
        this.mainPanel.add((Component)this.simplifiedEntryPanel, "Simplified View");
        this.cardLayout.show(this.mainPanel, "Nothing Selected");
    }

    public void okClicked() {
    }

    public void entryRead(EntryReadEvent ev) {
        this.searchResult = ev.getSearchResult();
        this.updateEntryView(this.searchResult, this.treePath);
    }

    private void updateEntryView(CustomSearchResult searchResult, TreePath treePath) {
        String cardKey;
        boolean isReadOnly = this.isReadOnly(searchResult.getDN());
        boolean canDelete = this.canDelete(searchResult.getDN());
        this.delete.setVisible(canDelete);
        this.saveChanges.setVisible(!isReadOnly);
        switch (this.view) {
            case LDIF_VIEW: {
                this.displayedEntryPanel = this.ldifEntryPanel;
                cardKey = "LDIF View";
                break;
            }
            case ATTRIBUTE_VIEW: {
                this.displayedEntryPanel = this.tableEntryPanel;
                cardKey = "Attribute View";
                break;
            }
            default: {
                this.displayedEntryPanel = this.simplifiedEntryPanel;
                cardKey = "Simplified View";
            }
        }
        this.displayedEntryPanel.update(searchResult, isReadOnly, treePath);
        this.saveChanges.setEnabled(false);
        this.cardLayout.show(this.mainPanel, cardKey);
    }

    public void setView(View view) {
        if (view != this.view) {
            this.view = view;
            if (this.searchResult != null) {
                this.updateEntryView(this.searchResult, this.treePath);
            }
        }
    }

    public void entryReadError(EntryReadErrorEvent ev) {
        this.searchResult = null;
        this.errorSearchingPanel.setError(ev.getDN(), ev.getError());
        this.delete.setVisible(false);
        this.saveChanges.setVisible(false);
        this.cardLayout.show(this.mainPanel, "Error Searching");
        this.displayedEntryPanel = null;
    }

    public void noEntrySelected() {
        this.searchResult = null;
        this.delete.setVisible(false);
        this.saveChanges.setVisible(false);
        this.cardLayout.show(this.mainPanel, "Nothing Selected");
        this.displayedEntryPanel = null;
    }

    public void multipleEntriesSelected() {
        this.searchResult = null;
        this.delete.setVisible(false);
        this.saveChanges.setVisible(false);
        this.cardLayout.show(this.mainPanel, "Multiple Selected");
        this.displayedEntryPanel = null;
    }

    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.NO_BUTTON;
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_EDIT_LDAP_ENTRY_TITLE.get();
    }

    public Component getPreferredFocusComponent() {
        return this.saveChanges;
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
        final ServerDescriptor desc = ev.getNewDescriptor();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean isReadOnly = true;
                boolean canDelete = false;
                if (LDAPEntryPanel.this.searchResult != null && desc.isAuthenticated()) {
                    isReadOnly = LDAPEntryPanel.this.isReadOnly(LDAPEntryPanel.this.searchResult.getDN());
                    canDelete = LDAPEntryPanel.this.canDelete(LDAPEntryPanel.this.searchResult.getDN());
                }
                LDAPEntryPanel.this.delete.setVisible(canDelete);
                LDAPEntryPanel.this.saveChanges.setVisible(!isReadOnly);
            }
        });
    }

    public void setInfo(ControlPanelInfo info) {
        super.setInfo(info);
        this.simplifiedEntryPanel.setInfo(info);
        this.ldifEntryPanel.setInfo(info);
        this.tableEntryPanel.setInfo(info);
        this.errorSearchingPanel.setInfo(info);
    }

    public boolean isReadOnly(String sDn) {
        boolean isReadOnly = false;
        try {
            DN dn = DN.decode(sDn);
            for (DN parentDN : this.parentReadOnly) {
                if (!dn.isDescendantOf(parentDN)) continue;
                isReadOnly = true;
                break;
            }
            if (!isReadOnly) {
                isReadOnly = dn.equals(DN.NULL_DN);
            }
        }
        catch (Throwable t) {
            throw new IllegalStateException("Error decoding DNs: " + t, t);
        }
        return isReadOnly;
    }

    public boolean canDelete(String sDn) {
        boolean canDelete = true;
        try {
            DN dn = DN.decode(sDn);
            for (DN parentDN : this.parentReadOnly) {
                if (!dn.isDescendantOf(parentDN)) continue;
                canDelete = false;
                break;
            }
            if (canDelete) {
                for (DN cannotDelete : this.nonDeletable) {
                    if (!cannotDelete.equals(dn)) continue;
                    canDelete = false;
                    break;
                }
            }
            if (canDelete) {
                canDelete = !dn.equals(DN.NULL_DN);
            }
        }
        catch (Throwable t) {
            throw new IllegalStateException("Error decoding DNs: " + t, t);
        }
        return canDelete;
    }

    private void saveChanges(boolean modal) {
        this.newTask = null;
        ArrayList<Message> errors = new ArrayList<Message>();
        try {
            ProgressDialog dlg = new ProgressDialog((Component)Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_ENTRY_CHANGES_TITLE.get(), this.getInfo());
            dlg.setModal(modal);
            Entry entry = this.displayedEntryPanel.getEntry();
            this.newTask = new ModifyEntryTask(this.getInfo(), dlg, entry, this.searchResult, this.controller, this.treePath);
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(this.newTask, errors);
            }
            if (errors.size() == 0 && this.newTask.hasModifications()) {
                String dn = entry.getDN().toString();
                this.launchOperation(this.newTask, AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_ENTRY_SUMMARY.get(dn), AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_ENTRY_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_ENTRY_SUCCESSFUL.get(dn), AdminToolMessages.ERR_CTRL_PANEL_MODIFYING_ENTRY_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_MODIFYING_ENTRY_ERROR_DETAILS.get(dn), null, dlg);
                this.saveChanges.setEnabled(false);
                dlg.setVisible(true);
            } else if (errors.size() == 0) {
                this.saveChanges.setEnabled(false);
            }
        }
        catch (OpenDsException ode) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_ENTRY.get(ode.getMessageObject().toString()));
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    private void deleteEntry() {
        ArrayList<Message> errors = new ArrayList<Message>();
        boolean isLeaf = true;
        Set<Object> o = this.searchResult.getAttributeValues("numsubordinates");
        if (!o.isEmpty()) {
            int numsubordinates = Integer.parseInt((String)o.iterator().next());
            boolean bl = isLeaf = numsubordinates <= 0;
        }
        if (this.treePath != null) {
            Message title = isLeaf ? AdminToolMessages.INFO_CTRL_PANEL_DELETING_ENTRY_TITLE.get() : AdminToolMessages.INFO_CTRL_PANEL_DELETING_SUBTREE_TITLE.get();
            ProgressDialog dlg = new ProgressDialog((Component)Utilities.getParentDialog(this), title, this.getInfo());
            DeleteEntryTask newTask = new DeleteEntryTask(this.getInfo(), dlg, new TreePath[]{this.treePath}, this.controller);
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            if (errors.size() == 0) {
                Message confirmationMessage;
                Message message = confirmationMessage = isLeaf ? AdminToolMessages.INFO_CTRL_PANEL_DELETE_ENTRY_CONFIRMATION_DETAILS.get(this.searchResult.getDN()) : AdminToolMessages.INFO_CTRL_PANEL_DELETE_SUBTREE_CONFIRMATION_DETAILS.get(this.searchResult.getDN());
                if (this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), confirmationMessage)) {
                    String dn = this.searchResult.getDN();
                    if (isLeaf) {
                        this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_DELETING_ENTRY_SUMMARY.get(dn), AdminToolMessages.INFO_CTRL_PANEL_DELETING_ENTRY_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_ENTRY_SUCCESSFUL.get(dn), AdminToolMessages.ERR_CTRL_PANEL_DELETING_ENTRY_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_DELETING_ENTRY_ERROR_DETAILS.get(dn), null, dlg);
                    } else {
                        this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_DELETING_SUBTREE_SUMMARY.get(dn), AdminToolMessages.INFO_CTRL_PANEL_DELETING_SUBTREE_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_SUBTREE_SUCCESSFUL.get(dn), AdminToolMessages.ERR_CTRL_PANEL_DELETING_SUBTREE_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_DELETING_SUBTREE_ERROR_DETAILS.get(dn), null, dlg);
                    }
                    dlg.setVisible(true);
                }
            }
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    public BrowserController getController() {
        return this.controller;
    }

    public void setController(BrowserController controller) {
        this.controller = controller;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public void setTreePath(TreePath treePath) {
        this.treePath = treePath;
    }

    public boolean mustCheckUnsavedChanges() {
        return this.displayedEntryPanel != null && this.saveChanges.isVisible() && this.saveChanges.isEnabled();
    }

    public UnsavedChangesDialog.Result checkUnsavedChanges() {
        UnsavedChangesDialog unsavedChangesDlg = new UnsavedChangesDialog((Component)Utilities.getParentDialog(this), this.getInfo());
        unsavedChangesDlg.setMessage(AdminToolMessages.INFO_CTRL_PANEL_UNSAVED_CHANGES_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_UNSAVED_ENTRY_CHANGES_DETAILS.get(this.searchResult.getDN()));
        Utilities.centerGoldenMean(unsavedChangesDlg, Utilities.getParentDialog(this));
        unsavedChangesDlg.setVisible(true);
        UnsavedChangesDialog.Result result = unsavedChangesDlg.getResult();
        if (result == UnsavedChangesDialog.Result.SAVE) {
            this.saveChanges(false);
            if (this.newTask == null || this.newTask.getState() != Task.State.FINISHED_SUCCESSFULLY) {
                result = UnsavedChangesDialog.Result.CANCEL;
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum View {
        SIMPLIFIED_VIEW,
        ATTRIBUTE_VIEW,
        LDIF_VIEW;

    }
}

