/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.ScrollPaneBorderListener;
import org.opends.guitools.controlpanel.task.DeleteSchemaElementsTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StandardAttributePanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Schema;

public class CustomAttributePanel
extends StandardAttributePanel {
    private static final long serialVersionUID = 2850763193735843746L;
    private JButton delete;
    private AttributeType attribute;
    private String attrName;
    private ScrollPaneBorderListener scrollListener;

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_CUSTOM_ATTRIBUTE_TITLE.get();
    }

    protected void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        p.setBorder(this.PANEL_BORDER);
        super.createBasicLayout(p, gbc);
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JScrollPane scroll = Utilities.createBorderLessScrollBar(p);
        this.scrollListener = ScrollPaneBorderListener.createBottomBorderListener(scroll);
        this.add((Component)scroll, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.delete = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_DELETE_ATTRIBUTE_BUTTON.get());
        this.delete.setOpaque(false);
        this.add((Component)this.delete, gbc);
        this.delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                CustomAttributePanel.this.deleteAttribute();
            }
        });
    }

    public boolean requiresScroll() {
        return false;
    }

    public void update(AttributeType attr, Schema schema) {
        super.update(attr, schema);
        this.attribute = attr;
        this.attrName = this.attribute.getNameOrOID();
        this.scrollListener.updateBorder();
    }

    public void configurationChanged(final ConfigurationChangeEvent ev) {
        this.updateErrorPaneIfAuthRequired(ev.getNewDescriptor(), AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_FOR_ATTRIBUTE_DELETE.get());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CustomAttributePanel.this.delete.setEnabled(!CustomAttributePanel.this.authenticationRequired(ev.getNewDescriptor()));
            }
        });
    }

    private void deleteAttribute() {
        ArrayList<Message> errors = new ArrayList<Message>();
        ProgressDialog dlg = new ProgressDialog((Component)Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_DELETE_ATTRIBUTE_TITLE.get(), this.getInfo());
        ArrayList<ObjectClass> ocsToDelete = new ArrayList<ObjectClass>();
        ArrayList<AttributeType> attrsToDelete = new ArrayList<AttributeType>();
        attrsToDelete.add(this.attribute);
        DeleteSchemaElementsTask newTask = new DeleteSchemaElementsTask(this.getInfo(), dlg, ocsToDelete, attrsToDelete);
        for (Task task : this.getInfo().getTasks()) {
            task.canLaunch(newTask, errors);
        }
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        if (schema != null) {
            ArrayList<String> childAttributes = new ArrayList<String>();
            for (AttributeType attr : schema.getAttributeTypes().values()) {
                if (!this.attribute.equals(attr.getSuperiorType())) continue;
                childAttributes.add(attr.getNameOrOID());
            }
            if (!childAttributes.isEmpty()) {
                errors.add(AdminToolMessages.ERR_CANNOT_DELETE_PARENT_ATTRIBUTE.get(this.attrName, Utilities.getStringFromCollection(childAttributes, ", "), this.attrName));
            }
            ArrayList<String> dependentClasses = new ArrayList<String>();
            for (ObjectClass o : schema.getObjectClasses().values()) {
                if (!o.getRequiredAttributeChain().contains(this.attribute)) continue;
                dependentClasses.add(o.getNameOrOID());
            }
            if (!dependentClasses.isEmpty()) {
                errors.add(AdminToolMessages.ERR_CANNOT_DELETE_ATTRIBUTE_WITH_DEPENDENCIES.get(this.attrName, Utilities.getStringFromCollection(dependentClasses, ", "), this.attrName));
            }
        }
        if (errors.size() == 0) {
            Message confirmationMessage = AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_DELETE_ATTRIBUTE_DETAILS.get(this.attribute.getNameOrOID());
            if (this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), confirmationMessage)) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_DELETING_ATTRIBUTE_SUMMARY.get(this.attrName), AdminToolMessages.INFO_CTRL_PANEL_DELETING_ATTRIBUTE_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_ATTRIBUTE_SUCCESSFUL.get(this.attrName), AdminToolMessages.ERR_CTRL_PANEL_DELETING_ATTRIBUTE_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_DELETING_ATTRIBUTE_ERROR_DETAILS.get(this.attrName), null, dlg);
                dlg.setVisible(true);
            }
        } else {
            this.displayErrorDialog(errors);
        }
    }
}

