/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.messages.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StartStopTask
extends Task {
    Set<String> backendSet = new HashSet<String>();

    protected StartStopTask(ControlPanelInfo info, ProgressDialog progressDialog) {
        super(info, progressDialog);
        for (BackendDescriptor backend : info.getServerDescriptor().getBackends()) {
            this.backendSet.add(backend.getBackendID());
        }
    }

    @Override
    public Set<String> getBackends() {
        return this.backendSet;
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (this.state == Task.State.RUNNING) {
            incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
            canLaunch = false;
        }
        return canLaunch;
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        try {
            this.getInfo().regenerateDescriptor();
            this.getInfo().stopPooling();
            List arguments = this.getCommandLineArguments();
            String[] args = new String[((ArrayList)arguments).size()];
            ((ArrayList)arguments).toArray(args);
            this.returnCode = this.executeCommandLine(this.getCommandLinePath(), args);
            this.state = this.returnCode != 0 ? Task.State.FINISHED_WITH_ERROR : Task.State.FINISHED_SUCCESSFULLY;
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
        this.getInfo().startPooling();
    }

    protected ArrayList<String> getCommandLineArguments() {
        ArrayList<String> args = new ArrayList<String>();
        return args;
    }
}

