/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.VLVIndexDescriptor;
import org.opends.guitools.controlpanel.task.IndexTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.std.client.LocalDBBackendCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.cli.CommandBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebuildIndexTask
extends IndexTask {
    private SortedSet<AbstractIndexDescriptor> indexes = new TreeSet<AbstractIndexDescriptor>();

    public RebuildIndexTask(ControlPanelInfo info, ProgressDialog dlg, Collection<String> baseDNs, SortedSet<AbstractIndexDescriptor> indexes) {
        super(info, dlg, baseDNs);
        this.indexes.addAll(indexes);
    }

    @Override
    public Task.Type getType() {
        return Task.Type.REBUILD_INDEXES;
    }

    @Override
    public Message getTaskDescription() {
        if (this.baseDNs.size() == 1) {
            return AdminToolMessages.INFO_CTRL_PANEL_REBUILD_INDEX_TASK_DESCRIPTION.get((CharSequence)this.baseDNs.iterator().next());
        }
        return AdminToolMessages.INFO_CTRL_PANEL_REBUILD_INDEX_TASK_DESCRIPTION.get((CharSequence)this.backendSet.iterator().next());
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (this.state == Task.State.RUNNING) {
            TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
            backends.retainAll(this.getBackends());
            if (backends.size() > 0) {
                incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                canLaunch = false;
            }
        }
        return canLaunch;
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        try {
            boolean mustDisable = false;
            boolean mustEnable = false;
            String backendName = (String)this.backendSet.iterator().next();
            if (this.isServerRunning()) {
                for (BackendDescriptor backend : this.getInfo().getServerDescriptor().getBackends()) {
                    if (!backendName.equals(backend.getBackendID())) continue;
                    mustDisable = backend.isEnabled();
                    break;
                }
            }
            if (mustDisable) {
                this.setBackendEnable(backendName, false);
                mustEnable = true;
            }
            for (final String baseDN : this.baseDNs) {
                ArrayList<String> arguments = this.getCommandLineArguments(baseDN);
                String[] args = new String[arguments.size()];
                arguments.toArray(args);
                final StringBuilder sb = new StringBuilder();
                sb.append(this.getCommandLinePath("rebuild-index"));
                List<String> displayArgs = this.getObfuscatedCommandLineArguments(this.getCommandLineArguments(baseDN));
                displayArgs.removeAll(this.getConfigCommandLineArguments());
                for (String arg : displayArgs) {
                    sb.append(" " + CommandBuilder.escapeValue(arg));
                }
                sb.toString();
                final ProgressDialog progressDialog = this.getProgressDialog();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        progressDialog.appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_REBUILD_INDEX.get(baseDN) + "<br><b>" + sb.toString() + "</b><br><br>", ColorAndFontConstants.progressFont));
                    }
                });
                this.returnCode = this.executeCommandLine(this.getCommandLinePath("rebuild-index"), args);
                if (this.returnCode == 0) continue;
                break;
            }
            if (mustEnable) {
                this.setBackendEnable(backendName, true);
            }
            if (this.returnCode != 0) {
                this.state = Task.State.FINISHED_WITH_ERROR;
            } else {
                for (AbstractIndexDescriptor index : this.indexes) {
                    this.getInfo().unregisterModifiedIndex(index);
                }
                this.state = Task.State.FINISHED_SUCCESSFULLY;
            }
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
    }

    protected ArrayList<String> getCommandLineArguments() {
        return new ArrayList<String>();
    }

    protected ArrayList<String> getCommandLineArguments(String baseDN) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--baseDN");
        args.add(baseDN);
        for (AbstractIndexDescriptor index : this.indexes) {
            args.add("--index");
            if (index instanceof VLVIndexDescriptor) {
                args.add(Utilities.getVLVNameInCommandLine((VLVIndexDescriptor)index));
                continue;
            }
            args.add(index.getName());
        }
        return args;
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    private void setBackendEnable(final String backendName, final boolean enable) throws OpenDsException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("set-backend-prop");
        args.add("--backend-name");
        args.add(backendName);
        args.add("--set");
        args.add("enabled:" + enable);
        args.addAll(this.getConnectionCommandLineArguments());
        args.add(this.getNoPropertiesFileArgument());
        args.add("--no-prompt");
        final StringBuilder sb = new StringBuilder();
        sb.append(this.getCommandLinePath("dsconfig"));
        for (String arg : args) {
            sb.append(" " + CommandBuilder.escapeValue(arg));
        }
        final ProgressDialog progressDialog = this.getProgressDialog();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (enable) {
                    progressDialog.appendProgressHtml("<br><br>" + Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_ENABLE_BACKEND.get(backendName) + "<br><b>" + sb.toString() + "</b><br><br>", ColorAndFontConstants.progressFont));
                    progressDialog.appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_ENABLING_BACKEND.get(backendName), ColorAndFontConstants.progressFont));
                } else {
                    progressDialog.appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_DISABLE_BACKEND.get(backendName) + "<br><b>" + sb.toString() + "</b><br><br>", ColorAndFontConstants.progressFont));
                    progressDialog.appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_DISABLING_BACKEND.get(backendName), ColorAndFontConstants.progressFont));
                }
            }
        });
        ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(this.getInfo().getDirContext()));
        RootCfgClient root = mCtx.getRootConfiguration();
        LocalDBBackendCfgClient backend = (LocalDBBackendCfgClient)root.getBackend(backendName);
        if (backend.isEnabled() != enable) {
            backend.setEnabled(enable);
            backend.commit();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                progressDialog.appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont) + "<br><br>");
            }
        });
    }
}

