/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.controlpanel.browser.IconPool;
import org.opends.guitools.controlpanel.browser.LDAPConnectionPool;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BackupDescriptor;
import org.opends.guitools.controlpanel.datamodel.ConfigReadException;
import org.opends.guitools.controlpanel.datamodel.ConnectionHandlerDescriptor;
import org.opends.guitools.controlpanel.datamodel.ConnectionProtocolPolicy;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.BackendPopulatedEvent;
import org.opends.guitools.controlpanel.event.BackendPopulatedListener;
import org.opends.guitools.controlpanel.event.BackupCreatedEvent;
import org.opends.guitools.controlpanel.event.BackupCreatedListener;
import org.opends.guitools.controlpanel.event.ConfigChangeListener;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.IndexModifiedEvent;
import org.opends.guitools.controlpanel.event.IndexModifiedListener;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.util.ConfigFromDirContext;
import org.opends.guitools.controlpanel.util.ConfigFromFile;
import org.opends.guitools.controlpanel.util.ConfigReader;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.quicksetup.util.UIKeyStore;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tools.ConfigureWindowsService;
import org.opends.server.util.DynamicConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlPanelInfo {
    private long poolingPeriod = 20000L;
    private ServerDescriptor serverDesc;
    private Set<Task> tasks = new HashSet<Task>();
    private InitialLdapContext ctx;
    private InitialLdapContext userDataCtx;
    private final LDAPConnectionPool connectionPool = new LDAPConnectionPool();
    private final IconPool iconPool = new IconPool();
    private Thread poolingThread;
    private boolean stopPooling;
    private boolean pooling;
    private ApplicationTrustManager trustManager;
    private ConnectionProtocolPolicy connectionPolicy = ConnectionProtocolPolicy.USE_MOST_SECURE_AVAILABLE;
    private String ldapURL;
    private String startTLSURL;
    private String ldapsURL;
    private String adminConnectorURL;
    private String lastWorkingBindDN;
    private String lastWorkingBindPwd;
    private static boolean mustDeregisterConfig;
    private Set<AbstractIndexDescriptor> modifiedIndexes = new HashSet<AbstractIndexDescriptor>();
    private LinkedHashSet<ConfigChangeListener> configListeners = new LinkedHashSet();
    private LinkedHashSet<BackupCreatedListener> backupListeners = new LinkedHashSet();
    private LinkedHashSet<BackendPopulatedListener> backendPopulatedListeners = new LinkedHashSet();
    private LinkedHashSet<IndexModifiedListener> indexListeners = new LinkedHashSet();
    private static final Logger LOG;
    private static ControlPanelInfo instance;

    protected ControlPanelInfo() {
    }

    public static ControlPanelInfo getInstance() {
        if (instance == null) {
            instance = new ControlPanelInfo();
            try {
                instance.setTrustManager(new ApplicationTrustManager(UIKeyStore.getInstance()));
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Error retrieving UI key store: " + t, t);
                instance.setTrustManager(new ApplicationTrustManager(null));
            }
        }
        return instance;
    }

    public ServerDescriptor getServerDescriptor() {
        return this.serverDesc;
    }

    public Set<Task> getTasks() {
        return Collections.unmodifiableSet(this.tasks);
    }

    public void registerTask(Task task) {
        this.tasks.add(task);
    }

    public boolean mustReindex(AbstractIndexDescriptor index) {
        boolean mustReindex = false;
        for (AbstractIndexDescriptor i : this.modifiedIndexes) {
            if (!i.getName().equals(index.getName()) || !i.getBackend().getBackendID().equals(index.getBackend().getBackendID())) continue;
            mustReindex = true;
            break;
        }
        return mustReindex;
    }

    public void registerModifiedIndex(AbstractIndexDescriptor index) {
        this.modifiedIndexes.add(index);
        this.indexModified(index);
    }

    public boolean unregisterModifiedIndex(AbstractIndexDescriptor index) {
        HashSet<AbstractIndexDescriptor> toRemove = new HashSet<AbstractIndexDescriptor>();
        for (AbstractIndexDescriptor i : this.modifiedIndexes) {
            if (!i.getName().equalsIgnoreCase(index.getName()) || !i.getBackend().getBackendID().equalsIgnoreCase(index.getBackend().getBackendID()) || !i.getClass().equals(index.getClass())) continue;
            toRemove.add(i);
        }
        if (!toRemove.isEmpty()) {
            boolean returnValue = this.modifiedIndexes.removeAll(toRemove);
            this.indexModified((AbstractIndexDescriptor)toRemove.iterator().next());
            return returnValue;
        }
        return false;
    }

    public void unregisterModifiedIndexesInBackend(String backendName) {
        HashSet<AbstractIndexDescriptor> toDelete = new HashSet<AbstractIndexDescriptor>();
        for (AbstractIndexDescriptor index : this.modifiedIndexes) {
            if (!index.getBackend().getBackendID().equalsIgnoreCase(backendName)) continue;
            toDelete.add(index);
        }
        this.modifiedIndexes.removeAll(toDelete);
        for (BackendDescriptor backend : this.getServerDescriptor().getBackends()) {
            if (!backend.getBackendID().equals(backendName)) continue;
            IndexModifiedEvent ev = new IndexModifiedEvent(backend);
            for (IndexModifiedListener listener : this.indexListeners) {
                listener.backendIndexesModified(ev);
            }
        }
    }

    public Collection<AbstractIndexDescriptor> getModifiedIndexes() {
        return Collections.unmodifiableCollection(this.modifiedIndexes);
    }

    public void setDirContext(InitialLdapContext ctx) {
        this.ctx = ctx;
        if (ctx != null) {
            this.lastWorkingBindDN = ConnectionUtils.getBindDN(ctx);
            this.lastWorkingBindPwd = ConnectionUtils.getBindPassword(ctx);
        }
    }

    public InitialLdapContext getDirContext() {
        return this.ctx;
    }

    public void setUserDataDirContext(InitialLdapContext ctx) throws NamingException {
        if (this.userDataCtx != null && this.connectionPool.isConnectionRegistered(this.userDataCtx)) {
            try {
                this.connectionPool.unregisterConnection(this.userDataCtx);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.userDataCtx = ctx;
        if (ctx != null) {
            InitialLdapContext cloneLdc = ConnectionUtils.cloneInitialLdapContext(this.userDataCtx, ConnectionUtils.getDefaultLDAPTimeout(), this.getTrustManager(), null);
            this.connectionPool.registerConnection(cloneLdc);
        }
    }

    public InitialLdapContext getUserDataDirContext() {
        return this.userDataCtx;
    }

    public void backupCreated(BackupDescriptor newBackup) {
        BackupCreatedEvent ev = new BackupCreatedEvent(newBackup);
        for (BackupCreatedListener listener : this.backupListeners) {
            listener.backupCreated(ev);
        }
    }

    public void backendPopulated(Set<BackendDescriptor> backends) {
        BackendPopulatedEvent ev = new BackendPopulatedEvent(backends);
        for (BackendPopulatedListener listener : this.backendPopulatedListeners) {
            listener.backendPopulated(ev);
        }
    }

    public void indexModified(AbstractIndexDescriptor modifiedIndex) {
        IndexModifiedEvent ev = new IndexModifiedEvent(modifiedIndex);
        for (IndexModifiedListener listener : this.indexListeners) {
            listener.indexModified(ev);
        }
    }

    protected ServerDescriptor createNewServerDescriptorInstance() {
        return new ServerDescriptor();
    }

    protected ConfigFromFile createNewConfigFromFileReader() {
        return new ConfigFromFile();
    }

    protected ConfigFromDirContext createNewConfigFromDirContextReader() {
        return new ConfigFromDirContext();
    }

    protected void updateServerDescriptor(ConfigReader reader, ServerDescriptor desc) {
        desc.setExceptions(reader.getExceptions());
        desc.setAdministrativeUsers(reader.getAdministrativeUsers());
        desc.setBackends(reader.getBackends());
        desc.setConnectionHandlers(reader.getConnectionHandlers());
        desc.setAdminConnector(reader.getAdminConnector());
        desc.setSchema(reader.getSchema());
        desc.setSchemaEnabled(reader.isSchemaEnabled());
    }

    public synchronized void regenerateDescriptor() {
        ConfigReader reader;
        ServerDescriptor desc = this.createNewServerDescriptorInstance();
        InitialLdapContext ctx = this.getDirContext();
        desc.setInstallPath(Utilities.getServerRootDirectory());
        desc.setInstancePath(Utilities.getInstanceRootDirectory(Utilities.getServerRootDirectory().getAbsolutePath()));
        boolean windowsServiceEnabled = false;
        if (Utilities.isWindows()) {
            int result = ConfigureWindowsService.serviceState(null, null);
            windowsServiceEnabled = result == 0;
        }
        desc.setWindowsServiceEnabled(windowsServiceEnabled);
        desc.setOpenDSVersion(DynamicConstants.FULL_VERSION_STRING);
        ServerDescriptor.ServerStatus status = null;
        for (Task task : this.getTasks()) {
            if (task.getType() == Task.Type.START_SERVER && task.getState() == Task.State.RUNNING) {
                status = ServerDescriptor.ServerStatus.STARTING;
                continue;
            }
            if (task.getType() != Task.Type.STOP_SERVER || task.getState() != Task.State.RUNNING) continue;
            status = ServerDescriptor.ServerStatus.STOPPING;
        }
        if (status != null) {
            desc.setStatus(status);
            if (status == ServerDescriptor.ServerStatus.STOPPING) {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.ctx = null;
                }
                if (this.userDataCtx != null) {
                    if (this.connectionPool.isConnectionRegistered(this.userDataCtx)) {
                        try {
                            this.connectionPool.unregisterConnection(this.userDataCtx);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    try {
                        this.userDataCtx.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.userDataCtx = null;
                }
            }
            reader = this.createNewConfigFromFileReader();
            ((ConfigFromFile)reader).readConfiguration();
            desc.setAuthenticated(false);
        } else if (Utilities.isServerRunning(Utilities.getInstanceRootDirectory(desc.getInstallPath().getAbsolutePath()))) {
            desc.setStatus(ServerDescriptor.ServerStatus.STARTED);
            if (ctx == null && this.lastWorkingBindDN != null) {
                try {
                    ctx = Utilities.getAdminDirContext(this, this.lastWorkingBindDN, this.lastWorkingBindPwd);
                }
                catch (ConfigReadException cre) {
                }
                catch (NamingException ne) {
                    // empty catch block
                }
                if (ctx != null) {
                    this.ctx = ctx;
                }
            }
            if (ctx == null) {
                reader = this.createNewConfigFromFileReader();
                ((ConfigFromFile)reader).readConfiguration();
            } else {
                reader = this.createNewConfigFromDirContextReader();
                ((ConfigFromDirContext)reader).readConfiguration(ctx);
                if (reader.getExceptions().size() > 0) {
                    boolean connectionWorks = false;
                    int nMaxErrors = 5;
                    for (int i = 0; i < nMaxErrors && !connectionWorks; ++i) {
                        try {
                            Utilities.pingDirContext(ctx);
                            connectionWorks = true;
                            continue;
                        }
                        catch (NamingException ne) {
                            try {
                                Thread.sleep(400L);
                                continue;
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                    }
                    if (!connectionWorks) {
                        reader = this.createNewConfigFromFileReader();
                        ((ConfigFromFile)reader).readConfiguration();
                        try {
                            ctx.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        this.ctx = null;
                        if (this.connectionPool.isConnectionRegistered(this.userDataCtx)) {
                            try {
                                this.connectionPool.unregisterConnection(this.userDataCtx);
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        try {
                            this.userDataCtx.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        this.userDataCtx = null;
                    }
                }
            }
            desc.setAuthenticated(reader instanceof ConfigFromDirContext);
            desc.setJavaVersion(reader.getJavaVersion());
            desc.setOpenConnections(reader.getOpenConnections());
            if (reader instanceof ConfigFromDirContext) {
                ConfigFromDirContext rCtx = (ConfigFromDirContext)reader;
                desc.setRootMonitor(rCtx.getRootMonitor());
                desc.setEntryCachesMonitor(rCtx.getEntryCaches());
                desc.setJvmMemoryUsageMonitor(rCtx.getJvmMemoryUsage());
                desc.setSystemInformationMonitor(rCtx.getSystemInformation());
                desc.setWorkQueueMonitor(rCtx.getWorkQueue());
            }
        } else {
            desc.setStatus(ServerDescriptor.ServerStatus.STOPPED);
            desc.setAuthenticated(false);
            reader = this.createNewConfigFromFileReader();
            ((ConfigFromFile)reader).readConfiguration();
        }
        this.updateServerDescriptor(reader, desc);
        if (this.serverDesc == null || !this.serverDesc.equals(desc)) {
            this.serverDesc = desc;
            if (this.serverDesc.getSchema() != null && !ServerDescriptor.areSchemasEqual(this.serverDesc.getSchema(), DirectoryServer.getSchema())) {
                DirectoryServer.setSchema(desc.getSchema());
            }
            this.ldapURL = ControlPanelInfo.getURL(this.serverDesc, ConnectionHandlerDescriptor.Protocol.LDAP);
            this.ldapsURL = ControlPanelInfo.getURL(this.serverDesc, ConnectionHandlerDescriptor.Protocol.LDAPS);
            this.adminConnectorURL = ControlPanelInfo.getAdminConnectorURL(this.serverDesc);
            this.startTLSURL = ControlPanelInfo.getURL(this.serverDesc, ConnectionHandlerDescriptor.Protocol.LDAP_STARTTLS);
            ConfigurationChangeEvent ev = new ConfigurationChangeEvent(this, desc);
            for (ConfigChangeListener listener : this.configListeners) {
                listener.configurationChanged(ev);
            }
        }
    }

    public void addConfigChangeListener(ConfigChangeListener listener) {
        this.configListeners.add(listener);
    }

    public boolean removeConfigChangeListener(ConfigChangeListener listener) {
        return this.configListeners.remove(listener);
    }

    public void addBackupCreatedListener(BackupCreatedListener listener) {
        this.backupListeners.add(listener);
    }

    public boolean removeBackupCreatedListener(BackupCreatedListener listener) {
        return this.backupListeners.remove(listener);
    }

    public void addBackendPopulatedListener(BackendPopulatedListener listener) {
        this.backendPopulatedListeners.add(listener);
    }

    public boolean removeBackendPopulatedListener(BackendPopulatedListener listener) {
        return this.backendPopulatedListeners.remove(listener);
    }

    public void addIndexModifiedListener(IndexModifiedListener listener) {
        this.indexListeners.add(listener);
    }

    public boolean removeIndexModifiedListener(IndexModifiedListener listener) {
        return this.indexListeners.remove(listener);
    }

    public synchronized void startPooling() {
        if (this.poolingThread != null) {
            return;
        }
        this.pooling = true;
        this.stopPooling = false;
        this.poolingThread = new Thread(new Runnable(){

            public void run() {
                try {
                    while (!ControlPanelInfo.this.stopPooling) {
                        ControlPanelInfo.this.regenerateDescriptor();
                        Thread.sleep(ControlPanelInfo.this.poolingPeriod);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ControlPanelInfo.this.pooling = false;
            }
        });
        this.poolingThread.start();
    }

    public synchronized void stopPooling() {
        this.stopPooling = true;
        while (this.poolingThread != null && this.pooling) {
            try {
                this.poolingThread.interrupt();
                Thread.sleep(100L);
            }
            catch (Throwable throwable) {}
        }
        this.poolingThread = null;
        this.pooling = false;
    }

    public ApplicationTrustManager getTrustManager() {
        return this.trustManager;
    }

    public void setTrustManager(ApplicationTrustManager trustManager) {
        this.trustManager = trustManager;
        this.connectionPool.setTrustManager(trustManager);
    }

    public ConnectionProtocolPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    public void setConnectionPolicy(ConnectionProtocolPolicy connectionPolicy) {
        this.connectionPolicy = connectionPolicy;
    }

    public String getLDAPSURL() {
        return this.ldapsURL;
    }

    public String getAdminConnectorURL() {
        return this.adminConnectorURL;
    }

    public String getLDAPURL() {
        return this.ldapURL;
    }

    public String getStartTLSURL() {
        return this.startTLSURL;
    }

    private static String getURL(ServerDescriptor server, ConnectionHandlerDescriptor.Protocol protocol) {
        String url = null;
        String sProtocol = null;
        switch (protocol) {
            case LDAP: {
                sProtocol = "ldap";
                break;
            }
            case LDAPS: {
                sProtocol = "ldaps";
                break;
            }
            case LDAP_STARTTLS: {
                sProtocol = "ldap";
                break;
            }
            case JMX: {
                sProtocol = "jmx";
                break;
            }
            case JMXS: {
                sProtocol = "jmxs";
            }
        }
        for (ConnectionHandlerDescriptor desc : server.getConnectionHandlers()) {
            if (desc.getState() != ConnectionHandlerDescriptor.State.ENABLED || desc.getProtocol() != protocol) continue;
            int port = desc.getPort();
            SortedSet<InetAddress> addresses = desc.getAddresses();
            if (addresses.size() == 0) {
                if (port <= 0) continue;
                url = sProtocol + "://localhost:" + port;
                continue;
            }
            if (port <= 0) continue;
            InetAddress address = addresses.first();
            url = sProtocol + "://" + ConnectionUtils.getHostNameForLdapUrl(address.getHostAddress()) + ":" + port;
        }
        return url;
    }

    private static String getAdminConnectorURL(ServerDescriptor server) {
        String url = null;
        ConnectionHandlerDescriptor desc = server.getAdminConnector();
        int port = desc.getPort();
        SortedSet<InetAddress> addresses = desc.getAddresses();
        if (addresses.size() == 0) {
            if (port > 0) {
                url = "ldaps://localhost:" + port;
            }
        } else if (port > 0) {
            InetAddress address = addresses.first();
            url = "ldaps://" + ConnectionUtils.getHostNameForLdapUrl(address.getHostAddress()) + ":" + port;
        }
        return url;
    }

    public boolean connectUsingStartTLS() {
        boolean connectUsingStartTLS = false;
        if (this.getStartTLSURL() != null) {
            connectUsingStartTLS = this.getStartTLSURL().equals(this.getURLToConnect());
        }
        return connectUsingStartTLS;
    }

    public boolean connectUsingLDAPS() {
        boolean connectUsingLDAPS = false;
        if (this.getLDAPSURL() != null) {
            connectUsingLDAPS = this.getLDAPSURL().equals(this.getURLToConnect());
        }
        return connectUsingLDAPS;
    }

    public String getURLToConnect() {
        String url;
        switch (this.getConnectionPolicy()) {
            case USE_STARTTLS: {
                url = this.getStartTLSURL();
                break;
            }
            case USE_LDAP: {
                url = this.getLDAPURL();
                break;
            }
            case USE_LDAPS: {
                url = this.getLDAPSURL();
                break;
            }
            case USE_ADMIN: {
                url = this.getAdminConnectorURL();
                break;
            }
            case USE_MOST_SECURE_AVAILABLE: {
                url = this.getLDAPSURL();
                if (url == null) {
                    url = this.getStartTLSURL();
                }
                if (url != null) break;
                url = this.getLDAPURL();
                break;
            }
            case USE_LESS_SECURE_AVAILABLE: {
                url = this.getLDAPURL();
                if (url == null) {
                    url = this.getStartTLSURL();
                }
                if (url != null) break;
                url = this.getLDAPSURL();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown policy: " + (Object)((Object)this.getConnectionPolicy()));
            }
        }
        return url;
    }

    public boolean mustDeregisterConfig() {
        return mustDeregisterConfig;
    }

    public void setMustDeregisterConfig(boolean mustDeregisterConfig) {
        ControlPanelInfo.mustDeregisterConfig = mustDeregisterConfig;
    }

    public LDAPConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public IconPool getIconPool() {
        return this.iconPool;
    }

    public long getPoolingPeriod() {
        return this.poolingPeriod;
    }

    public void setPoolingPeriod(long poolingPeriod) {
        this.poolingPeriod = poolingPeriod;
    }

    static {
        LOG = Logger.getLogger(ControlPanelInfo.class.getName());
    }
}

