/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.guitools.controlpanel.datamodel.ConnectionHandlerDescriptor;
import org.opends.guitools.controlpanel.datamodel.SortableTableModel;
import org.opends.messages.AdminToolMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionHandlerTableModel
extends SortableTableModel
implements Comparator<ConnectionHandlerDescriptor> {
    private static final long serialVersionUID = -1121308303480078376L;
    private Set<ConnectionHandlerDescriptor> data = new HashSet<ConnectionHandlerDescriptor>();
    private ArrayList<String[]> dataArray = new ArrayList();
    private String[] COLUMN_NAMES;
    private int sortColumn = 0;
    private boolean sortAscending = true;

    public ConnectionHandlerTableModel() {
        this(true);
    }

    public ConnectionHandlerTableModel(boolean wrapHeader) {
        this.COLUMN_NAMES = wrapHeader ? new String[]{this.getHeader(AdminToolMessages.INFO_ADDRESS_PORT_COLUMN.get()), this.getHeader(AdminToolMessages.INFO_PROTOCOL_COLUMN.get()), this.getHeader(AdminToolMessages.INFO_STATE_COLUMN.get())} : new String[]{AdminToolMessages.INFO_ADDRESS_PORT_COLUMN.get().toString(), AdminToolMessages.INFO_PROTOCOL_COLUMN.get().toString(), AdminToolMessages.INFO_STATE_COLUMN.get().toString()};
    }

    public void setData(Set<ConnectionHandlerDescriptor> newData) {
        if (!((Object)newData).equals(this.data)) {
            this.data.clear();
            this.data.addAll(newData);
            this.updateDataArray();
            this.fireTableDataChanged();
        }
    }

    @Override
    public void forceResort() {
        this.updateDataArray();
        this.fireTableDataChanged();
    }

    @Override
    public int compare(ConnectionHandlerDescriptor desc1, ConnectionHandlerDescriptor desc2) {
        int result = 0;
        if (this.sortColumn == 0) {
            if (desc1.getAddresses().equals(desc2.getAddresses())) {
                Integer port1 = new Integer(desc1.getPort());
                Integer port2 = new Integer(desc2.getPort());
                result = port1.compareTo(port2);
            } else {
                result = this.getAddressPortString(desc1).compareTo(this.getAddressPortString(desc2));
            }
            if (result == 0) {
                result = this.getProtocolString(desc1).compareTo(this.getProtocolString(desc2));
            }
            if (result == 0) {
                result = desc1.getState().compareTo(desc2.getState());
            }
        } else if (this.sortColumn == 1) {
            result = this.getProtocolString(desc1).compareTo(this.getProtocolString(desc2));
            if (result == 0) {
                result = this.getAddressPortString(desc1).compareTo(this.getAddressPortString(desc2));
            }
            if (result == 0) {
                result = desc1.getState().compareTo(desc2.getState());
            }
        } else {
            result = desc1.getState().compareTo(desc2.getState());
            if (result == 0) {
                result = this.getAddressPortString(desc1).compareTo(this.getAddressPortString(desc2));
            }
            if (result == 0) {
                result = this.getProtocolString(desc1).compareTo(this.getProtocolString(desc2));
            }
        }
        if (!this.sortAscending) {
            result = -result;
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.dataArray.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.dataArray.get(row)[col];
    }

    @Override
    public String getColumnName(int col) {
        return this.COLUMN_NAMES[col];
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public void setSortColumn(int sortColumn) {
        this.sortColumn = sortColumn;
    }

    private String getAddressPortString(ConnectionHandlerDescriptor desc) {
        String returnValue;
        SortedSet<InetAddress> addresses = desc.getAddresses();
        if (addresses.size() == 0) {
            returnValue = desc.getPort() > 0 ? String.valueOf(desc.getPort()) : AdminToolMessages.INFO_NOT_APPLICABLE_LABEL.get().toString();
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append("<html>");
            boolean added = false;
            for (InetAddress address : addresses) {
                if (added) {
                    buf.append("<br>");
                }
                buf.append(address.getCanonicalHostName());
                added = true;
                if (desc.getPort() <= 0) continue;
                buf.append(":" + desc.getPort());
            }
            returnValue = buf.toString();
        }
        return returnValue;
    }

    private String getProtocolString(ConnectionHandlerDescriptor desc) {
        String returnValue;
        switch (desc.getProtocol()) {
            case OTHER: {
                returnValue = desc.getName();
                break;
            }
            default: {
                returnValue = desc.getProtocol().getDisplayMessage().toString();
            }
        }
        return returnValue;
    }

    private void updateDataArray() {
        TreeSet<ConnectionHandlerDescriptor> sortedSet = new TreeSet<ConnectionHandlerDescriptor>(this);
        sortedSet.addAll(this.data);
        this.dataArray.clear();
        for (ConnectionHandlerDescriptor desc : sortedSet) {
            String[] s = new String[3];
            s[0] = this.getAddressPortString(desc);
            s[1] = this.getProtocolString(desc);
            switch (desc.getState()) {
                case ENABLED: {
                    s[2] = AdminToolMessages.INFO_ENABLED_LABEL.get().toString();
                    break;
                }
                case DISABLED: {
                    s[2] = AdminToolMessages.INFO_DISABLED_LABEL.get().toString();
                    break;
                }
                case UNKNOWN: {
                    s[2] = AdminToolMessages.INFO_UNKNOWN_LABEL.get().toString();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state: " + (Object)((Object)desc.getState()));
                }
            }
            this.dataArray.add(s);
        }
    }
}

