/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.browser;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.ManageReferralControl;
import javax.naming.ldap.SortControl;
import javax.naming.ldap.SortKey;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.controlpanel.browser.BasicNodeError;
import org.opends.guitools.controlpanel.browser.IconPool;
import org.opends.guitools.controlpanel.browser.LDAPConnectionPool;
import org.opends.guitools.controlpanel.browser.NodeRefresher;
import org.opends.guitools.controlpanel.browser.NodeSearcherQueue;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.BrowserEvent;
import org.opends.guitools.controlpanel.event.BrowserEventListener;
import org.opends.guitools.controlpanel.event.ReferralAuthenticationListener;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.ui.nodes.BrowserNodeInfo;
import org.opends.guitools.controlpanel.ui.nodes.RootNode;
import org.opends.guitools.controlpanel.ui.nodes.SuffixNode;
import org.opends.guitools.controlpanel.ui.renderer.BrowserCellRenderer;
import org.opends.guitools.controlpanel.util.NumSubordinateHacker;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.server.types.LDAPURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserController
implements TreeExpansionListener,
ReferralAuthenticationListener {
    public static final int DISPLAY_ACI_COUNT = 1;
    public static final String[] SORT_ATTRIBUTES = new String[]{"cn", "givenname", "o", "ou", "sn", "uid"};
    public static final String RDN_ATTRIBUTE = "rdn attribute";
    public static final String ALL_OBJECTS_FILTER = "(|(objectClass=*)(objectClass=ldapsubentry))";
    private JTree tree;
    private DefaultTreeModel treeModel;
    private RootNode rootNode;
    private int displayFlags;
    private String displayAttribute;
    private boolean showAttributeName;
    private InitialLdapContext ctxConfiguration;
    private InitialLdapContext ctxUserData;
    boolean followReferrals;
    boolean sorted;
    boolean showContainerOnly;
    private boolean automaticExpand;
    private boolean automaticallyExpandedNode;
    private String[] containerClasses;
    private NumSubordinateHacker numSubordinateHacker;
    private int queueTotalSize;
    private int maxChildren = 0;
    private Collection<BrowserEventListener> listeners = new ArrayList<BrowserEventListener>();
    private LDAPConnectionPool connectionPool;
    private IconPool iconPool;
    private NodeSearcherQueue refreshQueue;
    private String filter;

    public BrowserController(JTree tree, LDAPConnectionPool cpool, IconPool ipool) {
        this.tree = tree;
        this.iconPool = ipool;
        this.rootNode = new RootNode();
        this.rootNode.setIcon(this.iconPool.getIconForRootNode());
        this.treeModel = new DefaultTreeModel(this.rootNode);
        tree.setModel(this.treeModel);
        tree.addTreeExpansionListener(this);
        tree.setCellRenderer(new BrowserCellRenderer());
        this.displayFlags = 1;
        this.displayAttribute = RDN_ATTRIBUTE;
        this.followReferrals = true;
        this.sorted = false;
        this.showContainerOnly = true;
        this.containerClasses = new String[0];
        this.queueTotalSize = 0;
        this.connectionPool = cpool;
        this.connectionPool.addReferralAuthenticationListener(this);
        this.refreshQueue = new NodeSearcherQueue("New red", 2);
        this.numSubordinateHacker = new NumSubordinateHacker();
    }

    public void setConnections(ServerDescriptor server, InitialLdapContext ctxConfiguration, InitialLdapContext ctxUserData) throws NamingException {
        String rootNodeName;
        if (ctxConfiguration != null) {
            this.ctxConfiguration = ctxConfiguration;
            this.ctxUserData = ctxUserData;
            this.ctxConfiguration.setRequestControls(this.getConfigurationRequestControls());
            this.ctxUserData.setRequestControls(this.getRequestControls());
            rootNodeName = server.getHostname() + ":" + ConnectionUtils.getPort(ctxConfiguration);
        } else {
            rootNodeName = "";
        }
        this.rootNode.setDisplayName(rootNodeName);
        this.startRefresh(null);
    }

    public InitialLdapContext getConfigurationConnection() {
        return this.ctxConfiguration;
    }

    public InitialLdapContext getUserDataConnection() {
        return this.ctxUserData;
    }

    public JTree getTree() {
        return this.tree;
    }

    public LDAPConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public IconPool getIconPool() {
        return this.iconPool;
    }

    public boolean hasSuffix(String suffixDn) throws IllegalArgumentException {
        return this.findSuffixNode(suffixDn, this.rootNode) != null;
    }

    public TreePath addSuffix(String suffixDn, String parentSuffixDn) throws IllegalArgumentException {
        int index;
        SuffixNode parentNode;
        if (parentSuffixDn != null) {
            parentNode = this.findSuffixNode(parentSuffixDn, this.rootNode);
            if (parentNode == null) {
                throw new IllegalArgumentException("Invalid suffix dn " + parentSuffixDn);
            }
        } else {
            parentNode = this.rootNode;
        }
        if ((index = this.findChildNode(parentNode, suffixDn)) >= 0) {
            throw new IllegalArgumentException("Duplicate suffix dn " + suffixDn);
        }
        index = -(index + 1);
        SuffixNode newNode = new SuffixNode(suffixDn);
        this.treeModel.insertNodeInto(newNode, parentNode, index);
        this.startRefreshNode(newNode, null, true);
        return new TreePath(this.treeModel.getPathToRoot(newNode));
    }

    public TreePath addNodeUnderRoot(String nodeDn) {
        RootNode parentNode = this.rootNode;
        int index = this.findChildNode(parentNode, nodeDn);
        if (index >= 0) {
            throw new IllegalArgumentException("Duplicate node dn " + nodeDn);
        }
        index = -(index + 1);
        BasicNode newNode = new BasicNode(nodeDn);
        this.treeModel.insertNodeInto(newNode, parentNode, index);
        this.startRefreshNode(newNode, null, true);
        return new TreePath(this.treeModel.getPathToRoot(newNode));
    }

    public TreePath removeSuffix(String suffixDn) {
        TreePath result = null;
        SuffixNode node = this.findSuffixNode(suffixDn, this.rootNode);
        TreeNode parentNode = node.getParent();
        if (parentNode != null) {
            this.removeOneNode(node);
            result = new TreePath(this.treeModel.getPathToRoot(parentNode));
        }
        return result;
    }

    public TreePath removeAllUnderRoot() {
        this.stopRefresh();
        this.removeAllChildNodes(this.rootNode, false);
        return new TreePath(this.treeModel.getPathToRoot(this.rootNode));
    }

    public int getDisplayFlags() {
        return this.displayFlags;
    }

    public void setDisplayFlags(int flags) {
        this.displayFlags = flags;
        this.startRefresh(null);
    }

    public void setDisplayAttribute(String displayAttribute) {
        this.displayAttribute = displayAttribute;
        this.stopRefresh();
        this.removeAllChildNodes(this.rootNode, true);
        this.startRefresh(null);
    }

    public String getDisplayAttribute() {
        return this.displayAttribute;
    }

    public void showAttributeName(boolean showAttributeName) {
        this.showAttributeName = showAttributeName;
        this.stopRefresh();
        this.removeAllChildNodes(this.rootNode, true);
        this.startRefresh(null);
    }

    public boolean isAttributeNameShown() {
        return this.showAttributeName;
    }

    public void setMaxChildren(int maxChildren) {
        this.maxChildren = maxChildren;
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public boolean getFollowReferrals() {
        return this.followReferrals;
    }

    public void setFollowReferrals(boolean followReferrals) {
        this.followReferrals = followReferrals;
        this.startRefreshReferralNodes(this.rootNode);
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) throws NamingException {
        this.stopRefresh();
        this.removeAllChildNodes(this.rootNode, true);
        this.sorted = sorted;
        this.ctxConfiguration.setRequestControls(this.getConfigurationRequestControls());
        this.ctxUserData.setRequestControls(this.getRequestControls());
        this.connectionPool.setRequestControls(this.getRequestControls());
        this.startRefresh(null);
    }

    public boolean isShowContainerOnly() {
        return this.showContainerOnly;
    }

    public void setShowContainerOnly(boolean showContainerOnly) {
        this.showContainerOnly = showContainerOnly;
        this.startRefresh(null);
    }

    public BrowserNodeInfo getNodeInfoFromPath(TreePath path) {
        BasicNode node = (BasicNode)path.getLastPathComponent();
        return new BrowserNodeInfoImpl(node);
    }

    public String[] getContainerClasses() {
        return this.containerClasses;
    }

    public void setContainerClasses(String[] containerClasses) {
        this.containerClasses = containerClasses;
        this.startRefresh(null);
    }

    public NumSubordinateHacker getNumSubordinateHacker() {
        return this.numSubordinateHacker;
    }

    public void setNumSubordinateHacker(NumSubordinateHacker h) {
        if (h == null) {
            throw new IllegalArgumentException("hacker cannot be null");
        }
        this.numSubordinateHacker = h;
    }

    public void addBrowserEventListener(BrowserEventListener l) {
        this.listeners.add(l);
    }

    public void removeBrowserEventListener(BrowserEventListener l) {
        this.listeners.remove(l);
    }

    public TreePath notifyEntryAdded(BrowserNodeInfo parentInfo, String newEntryDn) {
        int childIndex;
        BasicNode parentNode = parentInfo.getNode();
        BasicNode childNode = new BasicNode(newEntryDn);
        if (this.sorted) {
            childIndex = this.findChildNode(parentNode, newEntryDn);
            if (childIndex >= 0) {
                throw new IllegalArgumentException("Duplicate DN " + newEntryDn);
            }
            childIndex = -(childIndex + 1);
        } else {
            childIndex = parentNode.getChildCount();
        }
        parentNode.setLeaf(false);
        this.treeModel.insertNodeInto(childNode, parentNode, childIndex);
        this.startRefreshNode(childNode, null, false);
        return new TreePath(this.treeModel.getPathToRoot(childNode));
    }

    public TreePath notifyEntryDeleted(BrowserNodeInfo nodeInfo) {
        TreePath result = null;
        BasicNode node = nodeInfo.getNode();
        if (node == this.rootNode) {
            throw new IllegalArgumentException("Root node cannot be removed");
        }
        TreeNode parentNode = node.getParent();
        if (parentNode != null) {
            this.removeOneNode(node);
            result = new TreePath(this.treeModel.getPathToRoot(parentNode));
        }
        return result;
    }

    public void notifyEntryChanged(BrowserNodeInfo nodeInfo) {
        BasicNode node = nodeInfo.getNode();
        this.startRefreshNode(node, null, false);
    }

    public void notifyChildEntryChanged(BrowserNodeInfo nodeInfo, String dn) {
        BasicNode node = nodeInfo.getNode();
        this.startRefreshNode(node, null, true);
    }

    public void notifyChildEntryAdded(BrowserNodeInfo nodeInfo, String dn) {
        BasicNode node = nodeInfo.getNode();
        this.startRefreshNode(node, null, true);
    }

    public void notifyChildEntryDeleted(BrowserNodeInfo nodeInfo, String dn) {
        BasicNode node = nodeInfo.getNode();
        if (node.getParent() != null) {
            this.startRefreshNode((BasicNode)node.getParent(), null, true);
        } else {
            this.startRefreshNode(node, null, true);
        }
    }

    @Override
    public void notifyAuthDataChanged() {
        this.notifyAuthDataChanged(null);
    }

    public void notifyAuthDataChanged(LDAPURL url) {
        this.startRefreshReferralNodes(this.rootNode);
    }

    public void startRefresh(BrowserNodeInfo nodeInfo) {
        BasicNode node = nodeInfo == null ? this.rootNode : nodeInfo.getNode();
        this.stopRefreshNode(node);
        this.startRefreshNode(node, null, true);
    }

    public void startRefresh() {
        this.startRefresh(null);
    }

    public void stopRefresh() {
        this.stopRefreshNode(this.rootNode);
    }

    public void shutDown() {
        this.tree.removeTreeExpansionListener(this);
        this.refreshQueue.shutdown();
        this.connectionPool.flush();
    }

    void startRefreshNode(BasicNode node, SearchResult localEntry, boolean recursive) {
        block4: {
            block3: {
                if (node != this.rootNode) break block3;
                if (!recursive) break block4;
                Enumeration<TreeNode> e = this.rootNode.children();
                while (e.hasMoreElements()) {
                    BasicNode child = (BasicNode)e.nextElement();
                    this.startRefreshNode(child, null, true);
                }
                break block4;
            }
            this.refreshQueue.queue(new NodeRefresher(node, this, localEntry, recursive));
            if (recursive && node instanceof SuffixNode) {
                Enumeration<TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    BasicNode child = (BasicNode)e.nextElement();
                    if (!(child instanceof SuffixNode)) continue;
                    this.startRefreshNode(child, null, true);
                }
            }
        }
    }

    void stopRefreshNode(BasicNode node) {
        if (node == this.rootNode) {
            this.refreshQueue.cancelAll();
        } else {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                BasicNode child = (BasicNode)e.nextElement();
                this.stopRefreshNode(child);
            }
            this.refreshQueue.cancelForNode(node);
        }
    }

    void startRefreshReferralNodes(BasicNode parentNode) {
        Enumeration<TreeNode> e = parentNode.children();
        while (e.hasMoreElements()) {
            BasicNode child = (BasicNode)e.nextElement();
            if (child.getReferral() != null || child.getRemoteUrl() != null) {
                this.startRefreshNode(child, null, true);
                continue;
            }
            this.startRefreshReferralNodes(child);
        }
    }

    void removeAllChildNodes(BasicNode parentNode, boolean keepSuffixes) {
        for (int i = parentNode.getChildCount() - 1; i >= 0; --i) {
            BasicNode child = (BasicNode)parentNode.getChildAt(i);
            if (child instanceof SuffixNode && keepSuffixes) {
                this.removeAllChildNodes(child, true);
                child.setRefreshNeededOnExpansion(true);
                continue;
            }
            child.removeFromParent();
        }
        this.treeModel.nodeStructureChanged(parentNode);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        BasicNode basicNode;
        if (!this.automaticallyExpandedNode) {
            this.automaticExpand = false;
        }
        if ((basicNode = (BasicNode)event.getPath().getLastPathComponent()).isRefreshNeededOnExpansion()) {
            basicNode.setRefreshNeededOnExpansion(false);
            this.startRefreshNode(basicNode, null, true);
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        Object node = event.getPath().getLastPathComponent();
        if (!(node instanceof RootNode)) {
            BasicNode basicNode = (BasicNode)node;
            this.stopRefreshNode(basicNode);
        }
    }

    public void setInspectedNode(BrowserNodeInfo node) {
        BrowserCellRenderer renderer = (BrowserCellRenderer)this.tree.getCellRenderer();
        if (node == null) {
            renderer.setInspectedNode(null);
        } else {
            renderer.setInspectedNode(node.getNode());
        }
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    String getObjectSearchFilter() {
        return ALL_OBJECTS_FILTER;
    }

    String getChildSearchFilter() {
        String result;
        if (this.showContainerOnly) {
            result = this.followReferrals ? "(|(&(hasSubordinates=true)" + this.filter + ")(objectClass=referral)" : "(|(&(hasSubordinates=true)" + this.filter + ")";
            for (int i = 0; i < this.containerClasses.length; ++i) {
                result = result + "(objectClass=" + this.containerClasses[i] + ")";
            }
            result = result + ")";
        } else {
            result = this.filter;
        }
        return result;
    }

    InitialLdapContext findConnectionForLocalEntry(BasicNode node) throws NamingException {
        return this.findConnectionForLocalEntry(node, this.isConfigurationNode(node));
    }

    InitialLdapContext findConnectionForLocalEntry(BasicNode node, boolean isConfigurationNode) throws NamingException {
        BasicNode parent;
        InitialLdapContext result = node == this.rootNode ? this.ctxConfiguration : ((parent = (BasicNode)node.getParent()) != null && parent != this.rootNode ? this.findConnectionForDisplayedEntry(parent, isConfigurationNode) : (isConfigurationNode ? this.ctxConfiguration : this.ctxUserData));
        return result;
    }

    public boolean isConfigurationNode(BasicNode node) {
        boolean isConfigurationNode = false;
        if (node instanceof SuffixNode) {
            String dn = node.getDN();
            if (Utilities.areDnsEqual(dn, ADSContext.getAdministrationSuffixDN()) || Utilities.areDnsEqual(dn, "cn=schema") || Utilities.areDnsEqual(dn, "cn=Tasks") || Utilities.areDnsEqual(dn, "cn=config") || Utilities.areDnsEqual(dn, "cn=monitor") || Utilities.areDnsEqual(dn, "cn=ads-truststore") || Utilities.areDnsEqual(dn, "cn=backups") || Utilities.areDnsEqual(dn, "dc=replicationChanges")) {
                isConfigurationNode = true;
            }
        } else if (node instanceof RootNode) {
            isConfigurationNode = true;
        } else {
            BasicNode parentNode = (BasicNode)node.getParent();
            return this.isConfigurationNode(parentNode);
        }
        return isConfigurationNode;
    }

    public InitialLdapContext findConnectionForDisplayedEntry(BasicNode node) throws NamingException {
        return this.findConnectionForDisplayedEntry(node, this.isConfigurationNode(node));
    }

    InitialLdapContext findConnectionForDisplayedEntry(BasicNode node, boolean isConfigurationNode) throws NamingException {
        InitialLdapContext result = this.followReferrals && node.getRemoteUrl() != null ? this.connectionPool.getConnection(node.getRemoteUrl()) : this.findConnectionForLocalEntry(node, isConfigurationNode);
        return result;
    }

    void releaseLDAPConnection(InitialLdapContext ctx) {
        if (ctx != this.ctxConfiguration && ctx != this.ctxUserData) {
            this.connectionPool.releaseConnection(ctx);
        }
    }

    LDAPURL findUrlForLocalEntry(BasicNode node) {
        LDAPURL result;
        if (node == this.rootNode) {
            result = LDAPConnectionPool.makeLDAPUrl(this.ctxConfiguration, "");
        } else {
            BasicNode parent = (BasicNode)node.getParent();
            if (parent != null) {
                LDAPURL parentUrl = this.findUrlForDisplayedEntry(parent);
                result = LDAPConnectionPool.makeLDAPUrl(parentUrl, node.getDN());
            } else {
                result = LDAPConnectionPool.makeLDAPUrl(this.ctxConfiguration, node.getDN());
            }
        }
        return result;
    }

    LDAPURL findUrlForDisplayedEntry(BasicNode node) {
        LDAPURL result = this.followReferrals && node.getRemoteUrl() != null ? node.getRemoteUrl() : this.findUrlForLocalEntry(node);
        return result;
    }

    String findBaseDNForChildEntries(BasicNode node) {
        String result = this.followReferrals && node.getRemoteUrl() != null ? node.getRemoteUrl().getRawBaseDN() : node.getDN();
        return result;
    }

    boolean isDisplayedEntryRemote(BasicNode node) {
        boolean result = false;
        if (this.followReferrals) {
            if (node == this.rootNode) {
                result = false;
            } else if (node.getRemoteUrl() != null) {
                result = true;
            } else {
                BasicNode parent = (BasicNode)node.getParent();
                if (parent != null) {
                    result = this.isDisplayedEntryRemote(parent);
                }
            }
        }
        return result;
    }

    String[] getAttrsForRedSearch() {
        ArrayList<String> v = new ArrayList<String>();
        v.add("objectClass");
        v.add("numsubordinates");
        v.add("ref");
        if ((this.displayFlags & 1) != 0) {
            v.add("aci");
        }
        if (!this.displayAttribute.equals(RDN_ATTRIBUTE)) {
            v.add(this.displayAttribute);
        }
        String[] result = new String[v.size()];
        v.toArray(result);
        return result;
    }

    String[] getAttrsForGreenSearch() {
        if (!this.displayAttribute.equals(RDN_ATTRIBUTE)) {
            return new String[]{"aci", this.displayAttribute};
        }
        return new String[]{"aci"};
    }

    String[] getAttrsForBlackSearch() {
        if (!this.displayAttribute.equals(RDN_ATTRIBUTE)) {
            return new String[]{"objectClass", "numsubordinates", "ref", "aci", this.displayAttribute};
        }
        return new String[]{"objectClass", "numsubordinates", "ref", "aci"};
    }

    SearchControls getBasicSearchControls() {
        SearchControls searchControls = new SearchControls();
        searchControls.setCountLimit(this.maxChildren);
        return searchControls;
    }

    Control[] getRequestControls() {
        Control[] ctls = new Control[this.sorted ? 2 : 1];
        ctls[0] = new ManageReferralControl(true);
        if (this.sorted) {
            SortKey[] keys = new SortKey[SORT_ATTRIBUTES.length];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = new SortKey(SORT_ATTRIBUTES[i]);
            }
            try {
                ctls[1] = new SortControl(keys, true);
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Unexpected encoding exception: " + ioe, ioe);
            }
        }
        return ctls;
    }

    Control[] getConfigurationRequestControls() {
        Control[] ctls = new Control[]{};
        return ctls;
    }

    private void refreshTaskDidProgress(NodeRefresher task, NodeRefresher.State oldState, NodeRefresher.State newState) throws NamingException {
        BasicNode node = task.getNode();
        boolean nodeChanged = false;
        if (oldState == NodeRefresher.State.QUEUED) {
            this.checkUpdateEvent(true);
        }
        if (task.isInFinalState()) {
            this.checkUpdateEvent(false);
        }
        if (newState == NodeRefresher.State.FAILED) {
            if (this.isNameNotFoundException(task.getException()) && oldState != NodeRefresher.State.SOLVING_REFERRAL) {
                this.removeOneNode(node);
            } else {
                if (oldState == NodeRefresher.State.SOLVING_REFERRAL) {
                    node.setRemoteUrl(task.getRemoteUrl());
                    if (task.getRemoteEntry() != null) {
                        this.updateNodeRendering(node, task.getRemoteEntry());
                    }
                    node.setLeaf(true);
                    this.removeAllChildNodes(node, true);
                }
                node.setError(new BasicNodeError(oldState, task.getException(), task.getExceptionArg()));
                nodeChanged = this.updateNodeRendering(node, task.getDisplayedEntry());
            }
        } else if (newState == NodeRefresher.State.CANCELLED && newState == NodeRefresher.State.INTERRUPTED) {
            this.tree.collapsePath(new TreePath(this.treeModel.getPathToRoot(node)));
        } else {
            BasicNode child;
            if (oldState != NodeRefresher.State.SEARCHING_CHILDREN && newState == NodeRefresher.State.SEARCHING_CHILDREN) {
                if (this.canDoDifferentialUpdate(task)) {
                    Enumeration<TreeNode> e = node.children();
                    while (e.hasMoreElements()) {
                        child = (BasicNode)e.nextElement();
                        child.setObsolete(true);
                    }
                } else {
                    this.removeAllChildNodes(node, true);
                }
            }
            if (oldState == NodeRefresher.State.READING_LOCAL_ENTRY) {
                node.setRemoteUrl((String)null);
                SearchResult localEntry = task.getLocalEntry();
                nodeChanged = this.updateNodeRendering(node, localEntry);
            } else if (oldState == NodeRefresher.State.SOLVING_REFERRAL) {
                node.setRemoteUrl(task.getRemoteUrl());
                this.updateNodeRendering(node, task.getRemoteEntry());
                nodeChanged = true;
            } else if (oldState == NodeRefresher.State.DETECTING_CHILDREN) {
                if (node.isLeaf() != task.isLeafNode()) {
                    node.setLeaf(task.isLeafNode());
                    this.updateNodeRendering(node, task.getDisplayedEntry());
                    nodeChanged = true;
                    if (node.isLeaf()) {
                        this.removeAllChildNodes(node, false);
                    }
                }
            } else if (oldState == NodeRefresher.State.SEARCHING_CHILDREN) {
                this.updateChildNodes(task);
                if (newState == NodeRefresher.State.FINISHED) {
                    if (this.canDoDifferentialUpdate(task)) {
                        for (int i = node.getChildCount() - 1; i >= 0; --i) {
                            child = (BasicNode)node.getChildAt(i);
                            if (!child.isObsolete()) continue;
                            this.removeOneNode(child);
                        }
                    }
                    if (node.getChildCount() == 0) {
                        node.setLeaf(true);
                        this.updateNodeRendering(node, task.getDisplayedEntry());
                        nodeChanged = true;
                    }
                }
                if (node.isSizeLimitReached()) {
                    this.fireEvent(BrowserEvent.Type.SIZE_LIMIT_REACHED);
                }
            }
            if (newState == NodeRefresher.State.FINISHED && node.getError() != null) {
                node.setError(null);
                nodeChanged = this.updateNodeRendering(node, task.getDisplayedEntry());
            }
        }
        if (nodeChanged) {
            this.treeModel.nodeChanged(task.getNode());
        }
        if (node.isLeaf() && node.getChildCount() >= 1) {
            throw new IllegalStateException("Inconsistent node: " + node.getDN());
        }
    }

    void invokeRefreshTaskDidProgress(final NodeRefresher task, final NodeRefresher.State oldState, final NodeRefresher.State newState) throws InterruptedException {
        Runnable r = new Runnable(){

            public void run() {
                try {
                    BrowserController.this.refreshTaskDidProgress(task, oldState, newState);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        };
        BrowserController.swingInvoke(r);
    }

    private void updateChildNodes(NodeRefresher task) throws NamingException {
        BasicNode parent = task.getNode();
        ArrayList<Integer> insertIndex = new ArrayList<Integer>();
        ArrayList<Integer> changedIndex = new ArrayList<Integer>();
        boolean differential = this.canDoDifferentialUpdate(task);
        LDAPURL parentUrl = this.findUrlForDisplayedEntry(parent);
        boolean dontTrust = this.numSubordinateHacker.containsChildrenOf(parentUrl);
        for (SearchResult entry : task.getChildEntries()) {
            boolean hasNoSubOrdinates;
            BasicNode child;
            int index = differential ? this.findChildNode(parent, entry.getName()) : -(parent.getChildCount() + 1);
            if (index < 0) {
                index = -(index + 1);
                child = new BasicNode(entry.getName());
                parent.insert(child, index);
                this.updateNodeRendering(child, entry);
                insertIndex.add(new Integer(index));
            } else {
                child = (BasicNode)parent.getChildAt(index);
                if (this.updateNodeRendering(child, entry)) {
                    changedIndex.add(new Integer(index));
                }
                child.setObsolete(false);
            }
            int numSubOrdinates = child.getNumSubOrdinates();
            if (numSubOrdinates == 0 && dontTrust) {
                LDAPURL childUrl = this.findUrlForDisplayedEntry(child);
                hasNoSubOrdinates = !this.numSubordinateHacker.contains(childUrl);
            } else {
                boolean bl = hasNoSubOrdinates = numSubOrdinates == 0;
            }
            if (hasNoSubOrdinates && child.getReferral() == null && child.getChildCount() <= 0) continue;
            this.startRefreshNode(child, entry, true);
        }
        if (insertIndex.size() >= 1) {
            this.treeModel.nodesWereInserted(parent, BrowserController.intArrayFromCollection(insertIndex));
        }
        if (changedIndex.size() >= 1) {
            this.treeModel.nodesChanged(parent, BrowserController.intArrayFromCollection(changedIndex));
        }
    }

    private boolean canDoDifferentialUpdate(NodeRefresher task) {
        return task.getNode().getChildCount() >= 1 && task.getNode().getNumSubOrdinates() <= 100;
    }

    private boolean updateNodeRendering(BasicNode node, SearchResult entry) throws NamingException {
        boolean changed;
        Set<String> ocs;
        Set<String> aciValues;
        if (entry != null) {
            node.setNumSubOrdinates(BrowserController.getNumSubOrdinates(entry));
            node.setReferral(BrowserController.getReferral(entry));
            Set<String> ocValues = ConnectionUtils.getValues(entry, "objectClass");
            if (ocValues != null) {
                String[] array = new String[ocValues.size()];
                ocValues.toArray(array);
                node.setObjectClassValues(array);
            }
        }
        int aciCount = (this.displayFlags & 1) != 0 && entry != null ? ((aciValues = ConnectionUtils.getValues(entry, "aci")) != null ? aciValues.size() : 0) : 0;
        int modifiers = 0;
        if (node.isLeaf() && node.getNumSubOrdinates() <= 0) {
            modifiers |= 1;
        }
        if (node.getReferral() != null) {
            modifiers |= 2;
        }
        if (node.getError() != null) {
            if (node.getError().getException() != null) {
                node.getError().getException().printStackTrace();
            }
            modifiers |= 4;
        }
        TreeSet<String> objectClasses = new TreeSet<String>();
        if (entry != null && (ocs = ConnectionUtils.getValues(entry, "objectClass")) != null) {
            objectClasses.addAll(ocs);
        }
        ImageIcon newIcon = node instanceof SuffixNode ? this.iconPool.getSuffixIcon() : this.iconPool.getIcon(objectClasses, modifiers);
        StringBuilder sb2 = new StringBuilder();
        if (aciCount >= 1) {
            sb2.append(String.valueOf(aciCount));
            if (aciCount == 1) {
                sb2.append(" aci");
            } else {
                sb2.append(" acis");
            }
        }
        StringBuilder sb1 = new StringBuilder();
        if (node instanceof SuffixNode) {
            if (entry != null) {
                sb1.append(entry.getName());
            }
        } else {
            String value;
            boolean useRdn = true;
            if (!this.displayAttribute.equals(RDN_ATTRIBUTE) && entry != null && (value = ConnectionUtils.getFirstValue(entry, this.displayAttribute)) != null) {
                if (this.showAttributeName) {
                    value = this.displayAttribute + "=" + value;
                }
                sb1.append(value);
                useRdn = false;
            }
            if (useRdn) {
                String rdn = this.followReferrals && node.getRemoteUrl() != null ? (this.showAttributeName ? node.getRemoteRDNWithAttributeName() : node.getRemoteRDN()) : (this.showAttributeName ? node.getRDNWithAttributeName() : node.getRDN());
                sb1.append(rdn);
            }
        }
        if (sb2.length() >= 1) {
            sb1.append("  (");
            sb1.append((CharSequence)sb2);
            sb1.append(")");
        }
        String newDisplayName = sb1.toString();
        int newStyle = 0;
        if (this.isDisplayedEntryRemote(node)) {
            newStyle |= 2;
        }
        boolean bl = changed = node.getIcon() != newIcon || node.getDisplayName() != newDisplayName || node.getFontStyle() != newStyle;
        if (changed) {
            node.setIcon(newIcon);
            node.setDisplayName(newDisplayName);
            node.setFontStyle(newStyle);
        }
        return changed;
    }

    public int findChildNode(BasicNode parent, String childDn) {
        int i;
        int childCount = parent.getChildCount();
        for (i = 0; i < childCount && !childDn.equals(((BasicNode)parent.getChildAt(i)).getDN()); ++i) {
        }
        if (i >= childCount) {
            i = -(childCount + 1);
        }
        return i;
    }

    private void removeOneNode(BasicNode node) {
        this.stopRefreshNode(node);
        this.treeModel.removeNodeFromParent(node);
    }

    private void checkUpdateEvent(boolean taskIsStarting) {
        int newSize = this.refreshQueue.size();
        if (!taskIsStarting) {
            --newSize;
        }
        if (newSize != this.queueTotalSize) {
            if (this.queueTotalSize == 0 && newSize >= 1) {
                this.fireEvent(BrowserEvent.Type.UPDATE_START);
            } else if (this.queueTotalSize >= 1 && newSize == 0) {
                this.fireEvent(BrowserEvent.Type.UPDATE_END);
            }
            this.queueTotalSize = newSize;
        }
    }

    public int getQueueSize() {
        return this.refreshQueue.size();
    }

    private void fireEvent(BrowserEvent.Type type) {
        BrowserEvent event = new BrowserEvent(this, type);
        for (BrowserEventListener listener : this.listeners) {
            listener.processBrowserEvent(event);
        }
    }

    SuffixNode findSuffixNode(String suffixDn, SuffixNode suffixNode) throws IllegalArgumentException {
        SuffixNode result;
        if (Utilities.areDnsEqual(suffixNode.getDN(), suffixDn)) {
            result = suffixNode;
        } else {
            int childCount = suffixNode.getChildCount();
            if (childCount == 0) {
                result = null;
            } else {
                BasicNode child;
                int i = 0;
                boolean found = false;
                do {
                    if (!Utilities.areDnsEqual((child = (BasicNode)suffixNode.getChildAt(i)).getDN(), suffixDn)) continue;
                    found = true;
                } while (++i < childCount && !found);
                if (!found) {
                    result = null;
                } else if (child instanceof SuffixNode) {
                    result = (SuffixNode)child;
                } else {
                    throw new IllegalArgumentException(suffixDn + " is not a suffix node");
                }
            }
        }
        return result;
    }

    private boolean isNameNotFoundException(Object x) {
        boolean result = x != null && x instanceof NameNotFoundException;
        return result;
    }

    public static int getNumSubOrdinates(SearchResult entry) throws NamingException {
        int result;
        String v = ConnectionUtils.getFirstValue(entry, "numsubordinates");
        if (v == null) {
            result = 0;
        } else {
            try {
                result = Integer.parseInt(v);
            }
            catch (NumberFormatException x) {
                result = 0;
            }
        }
        return result;
    }

    public static String[] getReferral(SearchResult entry) throws NamingException {
        String[] result;
        block0: {
            Set<String> refValues;
            String value;
            boolean isReferral;
            Iterator<String> i$;
            result = null;
            Set<String> values = ConnectionUtils.getValues(entry, "objectClass");
            if (values == null || !(i$ = values.iterator()).hasNext() || !(isReferral = (value = i$.next()).equalsIgnoreCase("referral")) || (refValues = ConnectionUtils.getValues(entry, "ref")) == null) break block0;
            result = new String[refValues.size()];
            refValues.toArray(result);
        }
        return result;
    }

    public boolean nodeIsExpanded(BasicNode node) {
        TreePath tp = new TreePath(this.treeModel.getPathToRoot(node));
        return this.tree.isExpanded(tp);
    }

    public void expandNode(BasicNode node) {
        this.automaticallyExpandedNode = true;
        TreePath tp = new TreePath(this.treeModel.getPathToRoot(node));
        this.tree.expandPath(tp);
        this.tree.fireTreeExpanded(tp);
        this.automaticallyExpandedNode = false;
    }

    static int[] intArrayFromCollection(Collection<Integer> v) {
        int[] result = new int[v.size()];
        int i = 0;
        for (Integer value : v) {
            result[i] = value;
            ++i;
        }
        return result;
    }

    static SearchResult[] entryArrayFromCollection(Collection<SearchResult> v) {
        SearchResult[] result = new SearchResult[v.size()];
        v.toArray(result);
        return result;
    }

    static BasicNode[] nodeArrayFromCollection(Collection<BasicNode> v) {
        BasicNode[] result = new BasicNode[v.size()];
        v.toArray(result);
        return result;
    }

    static void swingInvoke(Runnable r) throws InterruptedException {
        try {
            SwingUtilities.invokeAndWait(r);
        }
        catch (InterruptedException x) {
            throw x;
        }
        catch (InvocationTargetException x) {
            x.printStackTrace();
        }
    }

    public boolean isAutomaticExpand() {
        return this.automaticExpand;
    }

    public void setAutomaticExpand(boolean automaticExpand) {
        this.automaticExpand = automaticExpand;
    }

    class BrowserNodeInfoImpl
    implements BrowserNodeInfo {
        BasicNode node;
        LDAPURL url;
        boolean isRemote;
        boolean isSuffix;
        boolean isRootNode;
        String[] referral;
        int numSubOrdinates;
        int errorType;
        Exception errorException;
        Object errorArg;
        String[] objectClassValues;
        String toString;

        public BrowserNodeInfoImpl(BasicNode node) {
            this.node = node;
            this.url = BrowserController.this.findUrlForDisplayedEntry(node);
            this.isRootNode = node instanceof RootNode;
            this.isRemote = BrowserController.this.isDisplayedEntryRemote(node);
            this.isSuffix = node instanceof SuffixNode;
            this.referral = node.getReferral();
            this.numSubOrdinates = node.getNumSubOrdinates();
            this.objectClassValues = node.getObjectClassValues();
            if (node.getError() != null) {
                BasicNodeError error = node.getError();
                switch (error.getState()) {
                    case READING_LOCAL_ENTRY: {
                        this.errorType = 1;
                        break;
                    }
                    case SOLVING_REFERRAL: {
                        this.errorType = 2;
                        break;
                    }
                    case DETECTING_CHILDREN: 
                    case SEARCHING_CHILDREN: {
                        this.errorType = 3;
                    }
                }
                this.errorException = error.getException();
                this.errorArg = error.getArg();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.getURL());
            if (this.getReferral() != null) {
                sb.append(" -> ");
                sb.append(this.getReferral());
            }
            this.toString = sb.toString();
        }

        public BasicNode getNode() {
            return this.node;
        }

        public LDAPURL getURL() {
            return this.url;
        }

        public boolean isRootNode() {
            return this.isRootNode;
        }

        public boolean isSuffix() {
            return this.isSuffix;
        }

        public boolean isRemote() {
            return this.isRemote;
        }

        public String[] getReferral() {
            return this.referral;
        }

        public int getNumSubOrdinates() {
            return this.numSubOrdinates;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public Exception getErrorException() {
            return this.errorException;
        }

        public Object getErrorArg() {
            return this.errorArg;
        }

        public TreePath getTreePath() {
            return new TreePath(BrowserController.this.treeModel.getPathToRoot(this.node));
        }

        public String[] getObjectClassValues() {
            return this.objectClassValues;
        }

        public String toString() {
            return this.toString;
        }

        public boolean representsSameNode(BrowserNodeInfo node) {
            boolean representsSameNode = false;
            if (node != null) {
                representsSameNode = node.getNode() == node;
            }
            return representsSameNode;
        }
    }
}

