/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class TrustedSocketFactory
extends SSLSocketFactory {
    private static Map<Thread, TrustManager> hmTrustManager = new HashMap<Thread, TrustManager>();
    private static Map<Thread, KeyManager> hmKeyManager = new HashMap<Thread, KeyManager>();
    private static Map<TrustManager, SocketFactory> hmDefaultFactoryTm = new HashMap<TrustManager, SocketFactory>();
    private static Map<KeyManager, SocketFactory> hmDefaultFactoryKm = new HashMap<KeyManager, SocketFactory>();
    private SSLSocketFactory innerFactory;
    private TrustManager trustManager;
    private KeyManager keyManager;

    public TrustedSocketFactory(TrustManager trustManager, KeyManager keyManager) {
        this.trustManager = trustManager;
        this.keyManager = keyManager;
    }

    public static synchronized void setCurrentThreadTrustManager(TrustManager trustManager, KeyManager keyManager) {
        TrustedSocketFactory.setThreadTrustManager(trustManager, Thread.currentThread());
        TrustedSocketFactory.setThreadKeyManager(keyManager, Thread.currentThread());
    }

    public static synchronized void setThreadTrustManager(TrustManager trustManager, Thread thread) {
        TrustManager currentTrustManager = hmTrustManager.get(thread);
        if (currentTrustManager != null) {
            hmDefaultFactoryTm.remove(currentTrustManager);
            hmTrustManager.remove(thread);
        }
        if (trustManager != null) {
            hmTrustManager.put(thread, trustManager);
        }
    }

    public static synchronized void setThreadKeyManager(KeyManager keyManager, Thread thread) {
        KeyManager currentKeyManager = hmKeyManager.get(thread);
        if (currentKeyManager != null) {
            hmDefaultFactoryKm.remove(currentKeyManager);
            hmKeyManager.remove(thread);
        }
        if (keyManager != null) {
            hmKeyManager.put(thread, keyManager);
        }
    }

    public static synchronized SocketFactory getDefault() {
        SocketFactory result;
        Thread currentThread = Thread.currentThread();
        TrustManager trustManager = hmTrustManager.get(currentThread);
        KeyManager keyManager = hmKeyManager.get(currentThread);
        if (trustManager == null) {
            if (keyManager == null) {
                result = new TrustedSocketFactory(null, null);
            } else {
                result = hmDefaultFactoryKm.get(keyManager);
                if (result == null) {
                    result = new TrustedSocketFactory(null, keyManager);
                    hmDefaultFactoryKm.put(keyManager, result);
                }
            }
        } else if (keyManager == null) {
            result = hmDefaultFactoryTm.get(trustManager);
            if (result == null) {
                result = new TrustedSocketFactory(trustManager, null);
                hmDefaultFactoryTm.put(trustManager, result);
            }
        } else {
            SocketFactory tmsf = hmDefaultFactoryTm.get(trustManager);
            SocketFactory kmsf = hmDefaultFactoryKm.get(keyManager);
            if (tmsf == null || kmsf == null) {
                result = new TrustedSocketFactory(trustManager, keyManager);
                hmDefaultFactoryTm.put(trustManager, result);
                hmDefaultFactoryKm.put(keyManager, result);
            } else if (!tmsf.equals(kmsf)) {
                result = new TrustedSocketFactory(trustManager, keyManager);
                hmDefaultFactoryTm.put(trustManager, result);
                hmDefaultFactoryKm.put(keyManager, result);
            } else {
                result = tmsf;
            }
        }
        return result;
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.getInnerFactory().createSocket(address, port);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        return this.getInnerFactory().createSocket(address, port, clientAddress, clientPort);
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.getInnerFactory().createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException {
        return this.getInnerFactory().createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.getInnerFactory().createSocket(s, host, port, autoClose);
    }

    public String[] getDefaultCipherSuites() {
        try {
            return this.getInnerFactory().getDefaultCipherSuites();
        }
        catch (IOException x) {
            return new String[0];
        }
    }

    public String[] getSupportedCipherSuites() {
        try {
            return this.getInnerFactory().getSupportedCipherSuites();
        }
        catch (IOException x) {
            return new String[0];
        }
    }

    private SSLSocketFactory getInnerFactory() throws IOException {
        if (this.innerFactory == null) {
            String algorithm = "TLSv1";
            KeyManager[] km = null;
            TrustManager[] tm = null;
            try {
                SSLContext sslCtx = SSLContext.getInstance(algorithm);
                if (this.trustManager != null) {
                    tm = new TrustManager[]{this.trustManager};
                }
                if (this.keyManager != null) {
                    km = new KeyManager[]{this.keyManager};
                }
                sslCtx.init(km, tm, new SecureRandom());
                this.innerFactory = sslCtx.getSocketFactory();
            }
            catch (GeneralSecurityException x) {
                SSLKeyException xx = new SSLKeyException("Failed to create SSLContext for " + algorithm);
                xx.initCause(x);
                throw xx;
            }
        }
        return this.innerFactory;
    }
}

