//---------------------------------------------------------------------------
#include <algorithm>
#include "QSelector.h"
//---------------------------------------------------------------------------
QSelector::QSelector() {}
//---------------------------------------------------------------------------
QSelector::~QSelector() {}
//---------------------------------------------------------------------------
void
QSelector::DeleteAll(void) {
  qList.clear();
}
//---------------------------------------------------------------------------
void
QSelector::Select(QDraw *qDraw) {
  int GridSize = qDraw->GetGridSize();
  for (int i = 0; i < GetSelectedCount(); i++) {
    QCircuit *qc = (QCircuit *)qList[i];
    TRect rect = qc->GetOccupiedRect();
    int x0 = GridSize * rect.left;
    int y0 = GridSize * rect.top;
    int x1 = GridSize * rect.right;
    int y1 = GridSize * rect.bottom;
    qDraw->SetBrushColor(clBlack);
    qDraw->FrameRect(x0, y0, x1, y1);
  }
}
//--------------------------------------------------------------------------
bool
QSelector::IsAdded(QCircuit *qc) {
  for (QList::iterator i=qList.begin();i!=qList.end();i++) {
    if (qc == (QCircuit *)i) {
      return true;
    }
  }
  return false;
}
//--------------------------------------------------------------------------
void
QSelector::Remove(QCircuit *qc) {
  qList.erase(remove(qList.begin(), qList.end(), qc), qList.end());
}
//--------------------------------------------------------------------------
void
QSelector::AddRemove(QCircuit *qc) {
  if (!IsAdded(qc)) {
    Add(qc);
  } else {
    Remove(qc);
  }
}
//--------------------------------------------------------------------------
QCircuit *
QSelector::GetSelectedCircuit(int index) {
  return (QCircuit*) qList[index];
}
//--------------------------------------------------------------------------

