//---------------------------------------------------------------------------
#ifndef QDrawHSVGraphH
#define QDrawHSVGraphH
//---------------------------------------------------------------------------
#include "QBits.h"
//---------------------------------------------------------------------------

class QDrawHSVGraph {
private :
  int LeftMargin;
  int TopMargin;
  int ColumnNumber;

  int BoxWidth;
  int BoxDepth;
  int BoxMaxHeight;
  int BoxOffset;

  TCanvas *Canvas;

  void SetPenColor(TColor Color) {Canvas->Pen->Color = Color;};
  void SetBrushColor(TColor Color) {Canvas->Brush->Color = Color;};

  void SetSize(int BoxSize);
  void DrawBox(int _x, int _y, int height, double ang);
  void DrawBoxBase(int _x, int _y);
  TColor GetColor(double theta, double abVal);
public :
  QDrawHSVGraph(TCanvas *_canvas);
  void DrawTest(void);
  void DrawAll(QBits * qBots);
  void DrawAll2D(QBits * qBits);
  void SetCanvas(TCanvas *_canvas) {Canvas = _canvas;};
};
#endif
