//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Preview.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFPreview *FPreview;
//---------------------------------------------------------------------------
__fastcall
TFPreview::TFPreview(TComponent* Owner)
    : TForm(Owner) {
  qDraw  = new QDraw(Image->Canvas);
  CBZoom->Items->Add("100%");
  CBZoom->Items->Add("120%");
  CBZoom->Items->Add("150%");
  CBZoom->Items->Add("200%");
  CBZoom->ItemIndex = 0;
  qManager=NULL;
}
//---------------------------------------------------------------------------
void __fastcall
TFPreview::FormClose(TObject *Sender, TCloseAction &Action) {
  delete qDraw;
}
//---------------------------------------------------------------------------
void
TFPreview::Execute(QManager *qm) {
  qManager = qm;
  CBZoom->ItemIndex = 0;
  ChangeSize();
  DrawAll();
  ShowModal();
}
//---------------------------------------------------------------------------
/**
 * Change Circuit Size
 */
void
TFPreview::ChangeSize(void) {
  int GridSize = qDraw->GetGridSize();
  int LineNumber = qManager->GetLineNumber();
  int ColumnNumber = qManager->GetColumnNumber();
  Image->Picture = NULL;
  Image->Height = LineNumber * GridSize + GridSize*2;
  Image->Width = ColumnNumber * GridSize + GridSize*2;
  Image->Canvas->Brush->Color = clWhite;
  Image->Canvas->FillRect(Rect(0,0,Image->Width,Image->Height));

  ClientWidth = Image->Width;
  ClientHeight = Image->Height;

  if (ClientWidth > MAX_WIDTH) {
    ClientWidth = MAX_WIDTH;
  }
  if (ClientHeight > MAX_HEIGHT) {
    ClientHeight = MAX_HEIGHT;
  }
  qDraw->SetCanvas(Image->Canvas);
}
//---------------------------------------------------------------------------
void
TFPreview::DrawAll(void) {
  int gridx = 700 / (qManager->GetColumnNumber() + 2);
  int gridy = 500 / (qManager->GetLineNumber() + 1);
  if (gridx < gridy) {
    qDraw->SetGridSize(gridx);
  } else {
    qDraw->SetGridSize(gridy);
  }
  ClearCanvas();
  qManager->DrawAllPrinter(qDraw);
}
//---------------------------------------------------------------------------
void
TFPreview::ClearCanvas() {
  Image->Canvas->Brush->Color = clWhite;
  Image->Canvas->Pen->Color = clBlack;
  Image->Canvas->FillRect(TRect(0, 0, Image->Width, Image->Height));
}
//---------------------------------------------------------------------------
void __fastcall
TFPreview::TBShowIndexClick(TObject *Sender) {
  qManager->PrtSt.ShowIndexFlg = TBShowIndex->Down;
  DrawAll();
}
//---------------------------------------------------------------------------

void __fastcall
TFPreview::TBShowVGClick(TObject *Sender) {
  qManager->PrtSt.ShowVtLineFlg = TBShowVG->Down;
  DrawAll();
}
//---------------------------------------------------------------------------
void __fastcall TFPreview::CBZoomChange(TObject *Sender) {
  DrawAll();
}
//---------------------------------------------------------------------------

