//---------------------------------------------------------------------------
// Form for Parameter
//---------------------------------------------------------------------------
#ifndef ParamH
#define ParamH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
//---------------------------------------------------------------------------
#include "QCircuitAll.h"
#include "QManager.h"
#include <ExtCtrls.hpp>
//---------------------------------------------------------------------------
class QPhaseController;
//---------------------------------------------------------------------------
class TFParam : public TForm {
__published:
  TPageControl *PageControl;
  TTabSheet *TSBitBox;
  TButton *BtOK;
  TButton *BtCancel;
  TTabSheet *TSCnot;
  TTabSheet *TSCCNot;
  TLabel *Label1;
  TLabel *Label2;
  TComboBox *CBTarget;
  TComboBox *CBTarget1;
  TComboBox *CBTarget2;
  TLabel *Label3;
  TLabel *Label4;
  TTabSheet *TSTextBox;
  TComboBox *CBTarget3;
  TLabel *Label5;
  TLabel *Label6;
  TEdit *EdText2;
  TCheckBox *CBEnabled;
  TTabSheet *TSSwap;
  TComboBox *CBSwapTarget1;
  TComboBox *CBSwapTarget2;
  TLabel *Label7;
  TLabel *Label8;
  TComboBox *CBBitState;
  TTabSheet *TSCRot;
  TComboBox *CBCRTarget;
  TLabel *Label9;
  TLabel *Phase;
  TTabSheet *TSRot;
  TLabel *Label10;
        TEdit *EdRotPhase;
        TEdit *EdCRotPhase;
        TImage *ImageRotPhase;
        TImage *ImageCRotPhase;
        void __fastcall ImageRotPhaseMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
        void __fastcall ImageCRotPhaseMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
        void __fastcall FormDestroy(TObject *Sender);
private:
  QPhaseController *qpcRot;
  QPhaseController *qpcCRot;
public:

  void CreateCircuit(int type, int mx, int my, QDraw *qDraw, QManager *qManager);
  void CreateCNOT(int mx, int my, QDraw *qDraw, QManager *qManager);
  void CreateCCNOT(int mx, int my, QDraw *qDraw, QManager *qManager);
  void CreateSWAP(int mx, int my, QDraw *qDraw, QManager *qManager);
  void CreateROT(int mx, int my, QDraw *qDraw, QManager *qManager);
  void CreateCROT(int mx, int my, QDraw *qDraw, QManager *qManager);

  void ModifyCircuit(QCircuit *qc, QManager *qManager);


  bool Execute(QBitbox *qBitBox);
  bool Execute(QCNot *qCNot,QManager *qManager);
  bool Execute(QCCNot *qCCNot,QManager *qManager);
  bool Execute(QSwap *qSwap, QManager *qManager);
  bool Execute(QCRot *qCRot, QManager *qManager);
  bool Execute(QRot *qRot, QManager * qManager);

  __fastcall TFParam(TComponent* Owner);

};
//---------------------------------------------------------------------------
extern PACKAGE TFParam *FParam;
//---------------------------------------------------------------------------
#endif
