//---------------------------------------------------------------------------
#include <vcl.h>
#include <fstream>
#include <sstream>
#include <vcl\Clipbrd.hpp>
#pragma hdrstop

#include "main.h"
#include "Graph.h"

using namespace std;

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFGraph *FGraph;
//---------------------------------------------------------------------------
__fastcall
TFGraph::TFGraph(TComponent* Owner) : TForm(Owner) {
  qBits = NULL;
  qDrawGraph = new QDrawGraph(PaintBox->Canvas);
  qDrawHsvGraph = new QDrawHSVGraph(ImageHsv->Canvas);
}
//---------------------------------------------------------------------------
/**
 * Destructor
 */
void __fastcall
TFGraph::FormDestroy(TObject *Sender) {
  delete qDrawGraph;
  delete qDrawHsvGraph;
}
//---------------------------------------------------------------------------
/**
 * Show Graph
 */
void
TFGraph::Execute(QBits *_qBits) {

  qBits = _qBits;
  if (qDrawGraph == NULL) {
    qDrawGraph = new QDrawGraph(PaintBox->Canvas);
  }
  qDrawGraph->SetImageSize(PaintBox->Width,PaintBox->Height);

  RBShowAll->Checked = FMain->MMShowAll->Checked;
  RBShowNonZero->Checked = FMain->MMShowNonZero->Checked;

  SBarStandard->Position = 0;

  if (RBShowAll->Checked) {
    qDrawGraph->SetDrawMode(QDrawGraph::DM_ALL,qBits);
  } else if (RBShowNonZero->Checked) {
    qDrawGraph->SetDrawMode(QDrawGraph::DM_NONZERO,qBits);
  }
  //Measurement
  ShowMeasurement();

  qDrawHsvGraph->SetCanvas(ImageHsv->Canvas);
  qDrawHsvGraph->DrawAll(qBits);
  qDrawHsvGraph->SetCanvas(ImageHsv2D->Canvas);
  qDrawHsvGraph->DrawAll2D(qBits);
  PaintBox->Repaint();
  Show();
}
//---------------------------------------------------------------------------
/**
 *  Show Measured Value
 */
void
TFGraph::ShowMeasurement(void) {
  if (qBits->GetNumberOfMeasured()==0) {
    REMeasured->Text = "Measurement was not performed.";
    return;
  }
  qBits->PerformMeasurement();
  ostringstream ss;
  qBits->SaveMeasurementToStream(ss);
  REMeasured->Text = ss.str().c_str();
}
//---------------------------------------------------------------------------
//  Event Processing
//---------------------------------------------------------------------------
void __fastcall
TFGraph::FormMouseWheel(TObject *Sender, TShiftState Shift, int WheelDelta, TPoint &MousePos, bool &Handled) {
  if (PageControl->ActivePage != TSStandard) {
    return;
  }

  const double m = 0.1;
  int t = qDrawGraph->GetViewingTop();
  qDrawGraph->SetViewingTop(t - m*WheelDelta);

  if(t != qDrawGraph->GetViewingTop()) {
    qDrawGraph->Paint(qBits);
  }

  double r = qDrawGraph->GetViewingTopRatio();
  SBarStandard->Position = (int)((SBarStandard->Max-SBarStandard->Min)*r+SBarStandard->Min);
}
//---------------------------------------------------------------------------
/**
 * Save Results
 */
void __fastcall
TFGraph::MMSaveResultsClick(TObject *Sender) {
  if (qBits==NULL) {
    return;
  }

  if (PageControl->ActivePage == TSMeasured) {
    SaveDialog->Title = "Save Measured Results to File";
  } else {
    SaveDialog->Title = "Save Results to File";
  }

  if (!SaveDialog->Execute())return;

  char *filename = SaveDialog->FileName.c_str();
  if (PageControl->ActivePage == TSMeasured) {
    //Save Measured Results
    ofstream ofs;
    ofs.open(filename);
    qBits->SaveMeasurementToStream(ofs);
    ofs.close();
  } else {
    qBits->SaveAsText(filename);
  }

}
//---------------------------------------------------------------------------
void __fastcall
TFGraph::MMCloseClick(TObject *Sender) {
  Close();
}
//---------------------------------------------------------------------------
void __fastcall
TFGraph::RBShowNonZeroClick(TObject *Sender) {
  FMain->MMShowNonZero->Checked = true;
  SBarStandard->Position = 0;
  qDrawGraph->SetDrawMode(QDrawGraph::DM_NONZERO,qBits);
  qDrawGraph->Paint(qBits);
}
//---------------------------------------------------------------------------
void __fastcall
TFGraph::RBShowAllClick(TObject *Sender) {
  FMain->MMShowAll->Checked = true;
  SBarStandard->Position = 0;
  qDrawGraph->SetDrawMode(QDrawGraph::DM_ALL,qBits);
  qDrawGraph->Paint(qBits);
}
//---------------------------------------------------------------------------
void __fastcall
TFGraph::PaintBoxPaint(TObject *Sender) {
  qDrawGraph->Paint(qBits);
}
//---------------------------------------------------------------------------
void __fastcall
TFGraph::SBarStandardScroll(TObject *Sender, TScrollCode ScrollCode, int &ScrollPos) {
  double r = (double)ScrollPos/(double)(SBarStandard->Max-SBarStandard->Min);
  qDrawGraph->SetViewingTopRatio(r);
  qDrawGraph->Paint(qBits);
}
//---------------------------------------------------------------------------
void __fastcall
TFGraph::FormResize(TObject *Sender) {
  if (qDrawGraph==NULL) {
    return;
  }
  qDrawGraph->SetImageSize(PaintBox->Width,PaintBox->Height);
}
//---------------------------------------------------------------------------
void __fastcall
TFGraph::MMCopyClick(TObject *Sender) {
  if (REMeasured->SelLength==0) {
    return;
  }
  TClipboard *co = Clipboard();
  co->AsText = REMeasured->SelText;
}
//---------------------------------------------------------------------------
void __fastcall
TFGraph::PMCopyClick(TObject *Sender) {
  MMCopy->Click();
}
//---------------------------------------------------------------------------
void __fastcall TFGraph::MMHideClick(TObject *Sender) {
 Hide();
}
//---------------------------------------------------------------------------

