//----------------------------------------------------------------------------
//  Parse information
//----------------------------------------------------------------------------
#ifndef QPARSEINFO_H
#define QPARSEINFO_H

#include <iostream>
#include <string>
#include <vector>

// ---------------------------------------------------------------------------
class QParseInfo {
  friend std::ostream &operator<<(std::ostream &os, const QParseInfo &pinfo);
public:
  static const int er_no_error           = 0;
  static const int er_syntax_error       = 1;
  static const int er_unknown_operation  = 2;
  static const int er_lack_of_arguments  = 3;
  static const int er_too_many_arguments = 4;
  static const int er_invalid_arguments  = 5;

  QParseInfo(const QParseInfo &pinfo);
  QParseInfo(const int _error);
  QParseInfo(const int _operator,
             const std::vector<int> &_targets,
             const double _rotation = 0,
             const bool _result = true,
             const int _error = 0);

  ~QParseInfo() {}

  int                 getOperator(void) const {
    return mOperator;
  }
  const std::vector<int> &getTargetIndices(void) const {
    return mTargetIndices;
  }
  double                 getRotation(void) const {
    return mRotation;
  }
  bool                getParseResult(void) const {
    return mParseResult;
  }
  int                 getErrorNo(void) const {
    return mErrorNo;
  }
private:
  int                 mOperator;
  std::vector<int>    mTargetIndices;
  double                 mRotation;
  bool                mParseResult;
  int                 mErrorNo;
};

std::ostream &operator<<(std::ostream &os, const QParseInfo &pinfo);

#endif //QPARSEINFO_H
