//---------------------------------------------------------------------------
#ifndef QSwapH
#define QSwapH
//---------------------------------------------------------------------------
#include "QCircuit.h"
//---------------------------------------------------------------------------
class QSwap : public QCircuit {
private:

  int Target1;
  int Target2;

public:
  QSwap(int x,int y);
  QSwap(int x,int y, string Param);

  virtual int        GetType(void)    { return QC_SWAP; }
  virtual string GetTypeStr(void) { return "QSwap"; }

  string GetCalcText(void);

  void SetTarget(int t1, int t2);
  int GetTarget1(void) {return Target1;};
  int GetTarget2(void) {return Target2;};


  void Draw(QDraw *Draw);
  void DrawPS(QPSDraw *psDraw);
  string GetParam(void);
  void Reverse(int y);
  TRect GetOccupiedRect();
  QCircuit *Clone();
};
//--------------------------------------------------------------------------
#endif
