//---------------------------------------------------------------------------
// Z Rotation
//---------------------------------------------------------------------------
#include <stdlib.h>
#include "QRot.h"
//---------------------------------------------------------------------------
QRot::QRot(int x,int y) :QCircuit(x,y) {
  Name = GetTypeStr();
  Phase = 0;
}
//---------------------------------------------------------------------------
QRot::QRot(int x,int y, string Param) :QCircuit(x,y) {
  Name = GetTypeStr();
  Phase = atof(Param.c_str());
}
//---------------------------------------------------------------------------
void
QRot::Draw(QDraw *qDraw) {
  int GridSize = qDraw->GetGridSize();
  int UnitSize = qDraw->GetUnitSize();

  int d = (GridSize-UnitSize)/2;
  int x1 = X * GridSize+d;
  int y1 = Y * GridSize+d;
  int x2 = x1 + UnitSize;
  int y2 = y1 + UnitSize;

  qDraw->SetBrushColor(clWhite);
  qDraw->FillRect(x1,y1,x2,y2);
  qDraw->SetBrushColor(clPurple);
  qDraw->FrameRect(x1,y1,x2,y2);
  qDraw->SetPenColor(clBlack);
  qDraw->SetBrushColor(clWhite);
  ostringstream os;
  os << Phase;
  qDraw->TextOut(x1+UnitSize/2,y1+UnitSize/2, os.str());
}
//---------------------------------------------------------------------------
void
QRot::Reverse(int y) {
  Y = y-Y;
}
//---------------------------------------------------------------------------
string
QRot::GetCalcText(void) {
  ostringstream os;
  os << "ROT(";
  os << "q[" << Y << "],";
  os << Phase << ")";
  return os.str();
}
//---------------------------------------------------------------------------
void
QRot::DrawPS(QPSDraw *psDraw) {
  int GridSize = psDraw->GetGridSize();
  int UnitSize = psDraw->GetUnitSize();

  int d = (GridSize-UnitSize)/2;
  int x1 = X * GridSize+d;
  int y1 = Y * GridSize+d;
  int x2 = x1 + UnitSize;
  int y2 = y1 + UnitSize;

  psDraw->FillRect(x1,y1,x2,y2);

  psDraw->FillRect(x1,y1,x2,y2);
  psDraw->FrameRect(x1,y1,x2,y2);
  ostringstream os;
  os << Phase;
  psDraw->TextOut(x1+UnitSize/2,y1+UnitSize/2,os.str());
}
//---------------------------------------------------------------------------
string
QRot::GetParam(void) {
  ostringstream os;
  os << Phase;
  return os.str();
}
//---------------------------------------------------------------------------
TRect QRot::GetOccupiedRect() {
  return TRect(X, Y, X + 1, Y + 1);
}
//--------------------------------------------------------------------------
QCircuit *
QRot::Clone() {
  QRot * qc = new QRot(X, Y);
  qc->SetPhase(GetPhase());
  return (QCircuit*)qc;
}
//---------------------------------------------------------------------------
