//---------------------------------------------------------------------------
#ifndef QPauliZH
#define QPauliZH
//---------------------------------------------------------------------------
#include "QCircuit.h"
//---------------------------------------------------------------------------
class QPauliZ : public QCircuit {
public :
  QPauliZ(int x, int y);

  virtual int        GetType(void)    { return QC_PAULIZ; }
  virtual string GetTypeStr(void) { return "QPauliZ"; }

  void Draw(QDraw *qDraw);
  void DrawPS(QPSDraw *psDraw);
  string GetCalcText(void);
  string GetSaveText(void);
  void Reverse(int y);
  TRect GetOccupiedRect();
  QCircuit *Clone() {QPauliZ *qz = new QPauliZ(X, Y); return (QCircuit*)qz;};
};
//---------------------------------------------------------------------------
#endif
