//---------------------------------------------------------------------------
#ifndef QPauliYH
#define QPauliYH
//---------------------------------------------------------------------------
#include "QCircuit.h"
//---------------------------------------------------------------------------
class QPauliY : public QCircuit {
public :
  QPauliY(int x, int y);

  virtual int        GetType(void)    { return QC_PAULIY; }
  virtual string GetTypeStr(void) { return "QPauliY"; }

  void Draw(QDraw *qDraw);
  void DrawPS(QPSDraw *psDraw);
  string GetCalcText(void);
  string GetSaveText(void);
  void Reverse(int y);
  TRect GetOccupiedRect();
  QCircuit *Clone() {QPauliY *qy = new QPauliY(X, Y); return (QCircuit*)qy;};
};
//---------------------------------------------------------------------------
#endif
