//---------------------------------------------------------------------------
// Management Class of QCalcUnit
//---------------------------------------------------------------------------
#ifndef QCalcManagerH
#define QCalcManagerH
//---------------------------------------------------------------------------
#include <vector>
#include <iostream>
#include "QBits.h"
#include "QCalcUnit.h"
#include "QCompilerCntl.h"
//---------------------------------------------------------------------------
class QCalcManager
{
protected:
    int     mNumberOfQBits;

public:
    QCalcManager(void);
    QCalcManager(std::istream &is);
    ~QCalcManager();

//---------------------------------------------------------------------------
// Interfaces
//---------------------------------------------------------------------------
    bool AddFromIntermediate(std::istream &is);
    void Calc(QBits * const qBits);
    void AddUnit(QCalcUnit *qc);
    int  GetCalcUnitCount(void) const {
        return mQCalcUnits.size();
    }
    QCalcUnit *CalcUnitAt(const int index) {
        return mQCalcUnits[index];
    }
    void DeleteAll(void);
    int GetNumberOfQBits(void) {
        return mNumberOfQBits;
    }
    //void DeleteAt(const int index) {} //TODO:
//---------------------------------------------------------------------------
// Utility functions
//---------------------------------------------------------------------------
protected:
    std::vector<QCalcUnit*> mQCalcUnits;
};
//---------------------------------------------------------------------------
#endif
