//---------------------------------------------------------------------------
// Rotate Gate
//---------------------------------------------------------------------------
#include <cmath>
#include <math.h>
#include "QC_rot.h"
//---------------------------------------------------------------------------
/**
 *
 */
QC_rot::QC_rot(int _TargetBit,double degree) : QCalcUnit() {
    TargetBit = _TargetBit;
    Theta = M_PI * degree / 180.0;
}
//---------------------------------------------------------------------------
/**
 * Calculation
 */
void
QC_rot::calc(int target, double theta,
             double R[], double I[], int NumberOfBits) {
    const double c     = std::cos(theta);
    const double s     = std::sin(theta);
    double r1, i1;
    unsigned int states = (1 << (NumberOfBits - 1));
    for (unsigned int i = 0; i < states; i++) {
        unsigned int ix1 = QCalcUnit::insert1(i, target);
        double r1 = R[ix1];
        double i1 = I[ix1];

        R[ix1] =  c*r1 - s*i1;
        I[ix1] =  s*r1 + c*i1;
    }
}
//---------------------------------------------------------------------------
void QC_rot::Calc(QBits *qBits)
{
    int N = qBits->GetNumberOfQBits();
    double *R = qBits->GetBitsR();//Real Part
    double *I = qBits->GetBitsI();//Imaginary Part
    QC_rot::calc(TargetBit, Theta, R, I, N);
}
//---------------------------------------------------------------------------
#ifdef __USE__MPI
void
QC_rot::calcmpi(int t1, double theta, double R[], double I[], int N) {
    const double c     = std::cos(theta);
    const double s     = std::sin(theta);
    double r0 = 0.0;
    double i0 = 0.0;
    double r1 = 0.0;
    double i1 = 0.0;
    unsigned int ix0, ix1;

    for (int i = 0; i < (1 << (N - 1)); i++) {
        // Obtain indices of state:
        ix0 = QCalcUnit::insert0(i, t1);
        ix1 = QCalcUnit::insert1(i, t1);

        bool bstore = setup(R, I, ix0, ix1, r0, i0, r1, i1);

        if (bstore) {
            double nr0 = r0;
            double ni0 = i0;
            double nr1 = c*r1 - s*i1;
            double ni1 = s*r1 + c*i1;
            // Store:
            store(R, I, ix0, ix1, nr0, ni0, nr1, ni1);
        }
    }
}
#endif
//---------------------------------------------------------------------------
