//---------------------------------------------------------------------------
//  Pauli Y gate
//---------------------------------------------------------------------------
#include "QC_pauliY.h"
//---------------------------------------------------------------------------
/**
 *  Constructor
 */
QC_pauliY::QC_pauliY(int _Target) : QCalcUnit() {
    Target = _Target;
}
//---------------------------------------------------------------------------
/**
 *  Calculate
 */
void
QC_pauliY::calc(int target, double R[], double I[], int NumberOfBits) {
    unsigned int state = 1<< (NumberOfBits - 1);

    double r0,r1,i0,i1;
    for (unsigned int i=0;i<state;i++) {
        unsigned int ix0 = insert0(i,target);
        unsigned int ix1 = insert1(i,target);

        //pauli Y
        r0 = R[ix0];
        i0 = I[ix0];
        r1 = R[ix1];
        i1 = I[ix1];

        R[ix0] = i1;
        I[ix0] = -r1;
        R[ix1] = -i0;
        I[ix1] = r0;
    }
}
//---------------------------------------------------------------------------
void QC_pauliY::Calc(QBits *qBits)
{
    int N = qBits->GetNumberOfQBits();
    double *R = qBits->GetBitsR();//Real Part
    double *I = qBits->GetBitsI();//Imaginary Part

    QC_pauliY::calc(Target, R, I, N);
}
//---------------------------------------------------------------------------
#ifdef __USE__MPI
void
QC_pauliY::calcmpi(int t1, double R[], double I[], int N) {
    double r0 = 0.0;
    double i0 = 0.0;
    double r1 = 0.0;
    double i1 = 0.0;
    unsigned int ix0, ix1;

    for (int i = 0; i < (1 << (N - 1)); i++)
    {
        // Obtain indices of state:
        ix0 = QCalcUnit::insert0(i, t1);
        ix1 = QCalcUnit::insert1(i, t1);

        bool bstore = setup(R, I, ix0, ix1, r0, i0, r1, i1);
        if (bstore) {
            double nr0 = i1;
            double ni0 = -r1;
            double nr1 = -i0;
            double ni1 = r0;
            // Store:
            store(R, I, ix0, ix1, nr0, ni0, nr1, ni1);
        }
    }
}
#endif
//---------------------------------------------------------------------------
