//---------------------------------------------------------------------------
#include "QC_pauliX.h"
#include "QC_not.h"
//---------------------------------------------------------------------------
/**
 *  Constructor
 */
QC_pauliX::QC_pauliX(int _Target) : QCalcUnit() {
    Target = _Target;
}
//---------------------------------------------------------------------------
/**
 *  Calculate
 */
void
QC_pauliX::calc(int target, double R[], double I[], int NumberOfBits) {
    QC_not::calc(target, R, I, NumberOfBits);
}
//---------------------------------------------------------------------------
void
QC_pauliX::Calc(QBits *qBits) {
    int N = qBits->GetNumberOfQBits();
    double *R = qBits->GetBitsR();//Real Part
    double *I = qBits->GetBitsI();//Imaginary Part

    QC_pauliX::calc(Target, R, I, N);
}
//---------------------------------------------------------------------------
#ifdef __USE__MPI
void
QC_pauliX::calcmpi(int t1, double R[], double I[], int N) {
    QC_not::calcmpi(t1,R,I,N);
}
#endif
//---------------------------------------------------------------------------
