#!/bin/bash

#usage: REV4=b44c SUFFIX=rc2 PREV=1.5.3 NEW=1.5.4 /path/to/create_patch.sh

set -uex

echo REV4: $REV4
echo SUFFIX: $SUFFIX

# Unzip all
for f in $(ls *.zip); do
  echo $f
  unzip $f
done

no_exit_diff()
{
  set +e
    diff $@
  set -e
}

# Create patch packages
# PREV=1.5.3
# NEW=1.5.4
P2N=${PREV//./}to${NEW//./} # 153to154

no_exit_diff -urN pukiwiki-${PREV}_utf8 pukiwiki-${NEW}_utf8 > update_pukiwiki_${P2N}_utf8.patch
no_exit_diff -urN pukiwiki-${PREV}_eucjp pukiwiki-${NEW}_eucjp > update_pukiwiki_${P2N}_eucjp.patch
zip update_pukiwiki_${P2N}_utf8.patch.zip update_pukiwiki_${P2N}_utf8.patch
zip update_pukiwiki_${P2N}_eucjp.patch.zip update_pukiwiki_${P2N}_eucjp.patch
cp -p update_pukiwiki_${P2N}_utf8.patch.zip update_pukiwiki_${P2N}${SUFFIX}-${REV4}_utf8.patch.zip
cp -p update_pukiwiki_${P2N}_eucjp.patch.zip update_pukiwiki_${P2N}${SUFFIX}-${REV4}_eucjp.patch.zip

# Compare
cp -rp pukiwiki-${PREV}_utf8/ _upgrade_pukiwiki-${PREV}_utf8/
cp -rp pukiwiki-${PREV}_eucjp/ _upgrade_pukiwiki-${PREV}_eucjp/

pushd _upgrade_pukiwiki-${PREV}_utf8/
  patch -p1 < ../update_pukiwiki_${P2N}_utf8.patch
popd

pushd _upgrade_pukiwiki-${PREV}_eucjp/
  patch -p1 < ../update_pukiwiki_${P2N}_eucjp.patch
popd

set +e
  diff -ur pukiwiki-${NEW}_utf8/ _upgrade_pukiwiki-${PREV}_utf8/
  diff -ur pukiwiki-${NEW}_eucjp/ _upgrade_pukiwiki-${PREV}_eucjp/

  DIFF_U=$(diff -ur pukiwiki-${NEW}_utf8/ _upgrade_pukiwiki-${PREV}_utf8/ | grep -v 'zip differ')
  DIFF_E=$(diff -ur pukiwiki-${NEW}_eucjp/ _upgrade_pukiwiki-${PREV}_eucjp/ | grep -v 'zip differ')
set -e

if [ -n "$DIFF_U" ]; then
  echo "Invalid patch (UTF-8)"
  exit 101
fi

if [ -n "$DIFF_E" ]; then
  echo "Invalid patch (EUC-JP)"
  exit 102
fi

