// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004 M. Ishiguro <mishiguro@users.sourceforge.jp>
// Copyright (C) 2004, 2007, 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ChartBox.cs 263 2010-01-16 13:12:35Z panacoran $

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Data;
using System.Windows.Forms;
using Protra.Lib.Db;
using Protra.Lib.Lang;

namespace Protra.Controls
{
	/// <summary>
	/// `[g`悷Rg[łB
	/// </summary>
	public class ChartBox : System.Windows.Forms.UserControl
	{
		/// <summary>
		/// ɂԊu
		/// </summary>
		private const int LeftMargin = 55;
		/// <summary>
		/// 㑤ɂԊu
		/// </summary>
		private const int TopMargin = 10;
		/// <summary>
		/// EɂԊu
		/// </summary>
		private const int RightMargin = 10;
		/// <summary>
		/// ɂԊu
		/// </summary>
		private const int BottomMargin = 20;

		/// <summary>
		/// vOt@C
		/// </summary>
        private string[] programFiles = new string[2];
		/// <summary>
		/// C^v^
		/// </summary>
        private Interpreter[] interpreters = new Interpreter[2];
		/// <summary>
		/// `ΏۂƂȂPrice̔z
		/// </summary>
        private Price[][] priceLists = new Price[2][];
        /// <summary>
        /// `[g̉E[̃CfbNX
        /// </summary>
        private int[] rightIndexes = new int[2];
		/// <summary>
		/// ̊Ԋu
		/// </summary>
		private int dx = 8;
        /// <summary>
        /// \[h
        /// </summary>
        private int chartMode;
        /// <summary>
        /// ƏTňقȂ`[ggp邩(gp邪1)
        /// </summary>
        private int useDifferentChart;

		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// RXgN^
		/// </summary>
		public ChartBox()
		{
			// ̌ĂяóAWindows.Forms tH[ fUCiŕKvłB
			InitializeComponent();
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
            this.SuspendLayout();
            // 
            // ChartBox
            // 
            this.Name = "ChartBox";
            this.Size = new System.Drawing.Size(976, 150);
            this.Paint += new System.Windows.Forms.PaintEventHandler(this.ChartBox_Paint);
            this.SizeChanged += new System.EventHandler(this.ChartBox_SizeChanged);
            this.ResumeLayout(false);

		}
		#endregion

        /// <summary>
        /// \[hݒ肷B
        /// </summary>
        public int ChartMode
        {
            set
            {
                chartMode = value;
                Invalidate();
            }
        }

        /// <summary>
        /// ƏTňقȂ`[ggp邩ݒ肷B
        /// </summary>
        public bool UseDifferentChart
        {
            set
            {
                if (value && useDifferentChart == 0)
                {
                    programFiles[1] = programFiles[0];
                    interpreters[1] = interpreters[0];
                }
                else if (!value && useDifferentChart == 1 && chartMode == 1)
                {
                    programFiles[0] = programFiles[1];
                    interpreters[0] = interpreters[1];
                }
                useDifferentChart = (value) ? 1 : 0;
            }
        }

		/// <summary>
		/// vOt@Cݒ肷B
		/// </summary>
        /// <param name="mode">`[g[hw肷B</param>
        /// <param name="file">vOt@Cw肷B</param>
        private void SetProgramFile(int mode, string file)
        {
            programFiles[mode] = file;
            if (file == null)
            {
                interpreters[mode] = null;
                return;
            }
            try
            {
                interpreters[mode] = new Interpreter(file);
            }
            catch (ParseException exc)
            {
                interpreters[mode] = null;
                MessageBox.Show(exc.Message);
            }
        }

        /// <summary>
        /// ݂̕\[hɉăvOt@Cݒ肷B
        /// </summary>
		public string ProgramFile
		{
			set
			{
                SetProgramFile(chartMode * useDifferentChart, value);
                Invalidate();
			}
		}

        /// <summary>
        /// p̃vOt@C擾邢͐ݒ肷B
        /// </summary>
        public string DailyProgramFile
        {
            get
            {
                return programFiles[0];
            }
            set
            {
                SetProgramFile(0, value);
            }
        }

        /// <summary>
        /// Tp̃vOt@C擾邢͐ݒ肷B
        /// </summary>
        public string WeeklyProgramFile
        {
            get
            {
                return programFiles[1];
            }
            set
            {
                SetProgramFile(1, value);
            }
        }

        /// <summary>
        /// Price̔zݒ肷B
        /// </summary>
        /// <param name="mode">`[g[hw肷B</param>
        /// <param name="prices">Price̔zw肷B</param>
        public void SetPrices(int mode, Price[] prices)
        {
            priceLists[mode] = prices;
            if (prices != null)
                rightIndexes[mode] = prices.Length - 1;
            if (mode == chartMode)
                Invalidate();
        }

        /// <summary>
        /// `[g̉E[̃CfbNX擾܂͐ݒ肷B
        /// </summary>
        public int RightIndex
        {
            get
            {
                return rightIndexes[chartMode];
            }
            set
            {
                rightIndexes[chartMode] = value;
                Invalidate();
            }
        }

		/// <summary>
		/// ̉i`悳邩擾܂B
		/// </summary>
		public int Count
		{
			get { return (this.Width - LeftMargin - RightMargin - 1) / dx; } 
		}

        /// <summary>
        /// XN[o[Kvǂ擾B
        /// </summary>
        public bool NeedScrollBar
        {
            get
            {
                if (priceLists[chartMode] == null || priceLists[chartMode].Length < Count)
                    return false;
                return true;
            }
        }

		private void ChartBox_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
            Interpreter interpreter = interpreters[chartMode * useDifferentChart];
            Price[] prices = priceLists[chartMode];
            if (interpreter == null || prices == null || prices.Length == 0)
				return;
            int rightIndex = rightIndexes[chartMode];

            Graphics g = e.Graphics;
			Brush brush = new SolidBrush(this.ForeColor);
			Pen pen = new Pen(this.ForeColor);
			Color dotColor = Color.FromArgb(
				(this.BackColor.A + this.ForeColor.A) / 2,
				(this.BackColor.R + this.ForeColor.R) / 2,
				(this.BackColor.G + this.ForeColor.G) / 2,
				(this.BackColor.B + this.ForeColor.B) / 2);
			Pen dotPen = new Pen(dotColor);
			dotPen.DashStyle = DashStyle.Dot;
			Rectangle chartRect = new Rectangle(
				LeftMargin, TopMargin,
				this.Width - LeftMargin - RightMargin - 1,
				this.Height - TopMargin - BottomMargin);
	
			// O[oϐ̐ݒ
			interpreter.GlobalVariableTable.Clear();
			interpreter.GlobalVariableTable["$Names"] = new Value(new Value[6]);
			interpreter.GlobalVariableTable["$Colors"] = new Value(new Value[6]);
			interpreter.GlobalVariableTable["$IsTimeSeries"] = new Value(true);

			// z`ɂďc̃XP[𓾂
            DrawBuiltins blt = new DrawBuiltins();
            int count = chartRect.Width / dx;
			blt.Index = Math.Max(0, rightIndex - count + 1);
            blt.Prices = prices;
			blt.X = chartRect.Right - (rightIndex - blt.Index + 1) * dx;
            blt.Dx = dx;
            blt.RightIndex = rightIndex;
            interpreter.Builtins = blt;
			while (blt.Index <= rightIndex)
			{
				try
				{
					interpreter.Execute();
				}
				catch(Exception exc)
				{
                    interpreters[chartMode * useDifferentChart] = null;
                    MessageBox.Show(exc.Message);
					return;
				}
				blt.X += dx;
				blt.Index++;
			}

			// c̒l̕`
			if(blt.MaxY != double.MinValue)
			{
				if(blt.MaxY == blt.MinY)
				{
					blt.MaxY += 1;
					blt.MinY -= 1;
				}
				double band = (blt.MaxY - blt.MinY) / 5;
				double a = 0.01;
				while (true)
				{
					if (band < 10 * a)
					{
						for (double b = a; b <= 10 * a; b += a)
							if (b >= band)
							{
								band = b;
								break;
							}
						break;
					}
					a *= 10;
				}
				if (blt.MaxY < 0)
					blt.MaxY = (int)(blt.MaxY / band) * band;
				else
					blt.MaxY = Math.Ceiling(blt.MaxY / band) * band;
				if (blt.MinY < 0)
					blt.MinY = -Math.Ceiling(-blt.MinY / band) * band;
				else
					blt.MinY = (int)(blt.MinY / band) * band;
				double m = blt.MinY + band;
				double ratio = chartRect.Height / (blt.MaxY - blt.MinY);
				while(m < blt.MaxY)
				{
                    m = Math.Round(m, 2);
					string text = m.ToString();

					SizeF size = g.MeasureString(text, this.Font);
					g.DrawString(text, this.Font, brush,
						chartRect.Left - size.Width,
						(float)(chartRect.Bottom - (m - blt.MinY) * ratio - size.Height / 2));
					g.DrawLine(dotPen,
						chartRect.Left, (float)(chartRect.Bottom - (m - blt.MinY) * ratio),
						chartRect.Right, (float)(chartRect.Bottom - (m - blt.MinY) * ratio));
					m += band;
				}
			}

            int x;
			// t̕`
			if (interpreter.GlobalVariableTable["$IsTimeSeries"].IsTrue)
			{
				int index = Math.Max(0, rightIndex - count + 1);
                x = chartRect.Right - (rightIndex - index + 1) * dx;
				DateTime preDate = prices[index].Date;
				while(index <= rightIndex)
				{
					DateTime date = prices[index].Date;
                    int monthInterval = (chartMode == 0) ? 1 : 3;
					if((date.Month - 1) % monthInterval == 0)
						if(date.Month != preDate.Month)
						{
							string text = date.ToString("yy/MM");
							SizeF size = g.MeasureString(text, this.Font);
							g.DrawString(text, this.Font, brush,
								x - (dx + size.Width) / 2, chartRect.Bottom);
							g.DrawLine(dotPen,
								x - dx / 2, chartRect.Top,
								x - dx / 2, chartRect.Bottom);
							preDate = date;
						}
					x += dx;
					index++;
				}
			}

			// {Ԃ̕`
			Region oldClip = g.Clip;
			g.Clip = new Region(chartRect);
            blt.Draw(g, Font, chartRect);
			g.Clip = oldClip;

			// g̕`
			g.DrawRectangle(pen, chartRect);

			// wW̕`
			Value[] names = (Value[])interpreter.GlobalVariableTable["$Names"].InnerValue;
			Value[] colors = (Value[])interpreter.GlobalVariableTable["$Colors"].InnerValue;
            x = chartRect.Left + 10;
			for (int i = 0; i < names.Length; i++)
				if (names[i] != null && colors[i] != null)
				{
					string text = (string)names[i].InnerValue;
					int rgb = (int)colors[i].InnerValue;
					SizeF size = g.MeasureString(text, this.Font);
					Rectangle rect = new Rectangle(x, chartRect.Top + 10, (int)size.Height, (int)size.Height);
					g.FillRectangle(new SolidBrush(Color.FromArgb(rgb)), rect);
					g.DrawRectangle(pen, rect);
					g.DrawString(text, this.Font, brush, rect.Right, rect.Top);
					x = (int)(rect.Right + size.Width); 
				}
		}

		private void ChartBox_SizeChanged(object sender, System.EventArgs e)
		{
			this.Invalidate();
		}
	}
}