// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: InterpreterFacade.cs,v 1.3 2007-12-27 08:34:39 panacoran Exp $

using System;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// vO̎sSFacadełB
	/// </summary>
	public class InterpreterFacade
	{
		/// <summary>
		/// vÕm[h
		/// </summary>
		Node node = new ProgramNode();
		/// <summary>
		/// \[X
		/// </summary>
		private Resource resource;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// vO̍\͒ɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="file">vOt@C̃pX</param>
		/// <param name="factory">IExecuter𐶐Factory</param>
		public InterpreterFacade(string file, IExecuterFactory factory)
		{
			Context context = new Context(file);
			context.LibraryPath = Global.DirLib;
			try
			{
				node = new ProgramNode();
				node.Parse(context);
				node = node.Simplify();
			}
			catch(ParseException exc)
			{
				ContextToken ct = exc.ContextToken;
				throw new ParseException
					("parse error in " + ct.FileName + ":" + (ct.Line + 1) + ": " + exc.Message, exc.ContextToken);
			}

			resource = new Resource();
			resource.Stack = new StackArea();
			resource.GlobalVariableTable = new VariableTable();
			resource.FunctionTable = new FunctionTable();
			resource.ExecuterFactory = factory;
		}

		/// <summary>
		/// vOs܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <returns>vO̖߂lłB</returns>
		public Value Execute()
		{
			resource.Stack.Clear();
			resource.FunctionTable.Clear();
			try
			{
				return node.Execute(resource, 0);
			}
			catch(RuntimeException exc)
			{
				ContextToken ct = exc.ContextToken;
				throw new RuntimeException
					("runtime error in " + ct.FileName + ":" + (ct.Line + 1) + ": " + exc.Message, exc.ContextToken);
			}
		}

		/// <summary>
		/// O[oϐ̃e[u擾܂͐ݒ肵܂B
		/// </summary>
		public VariableTable GlobalVariableTable
		{
			get { return resource.GlobalVariableTable; }
			set { resource.GlobalVariableTable = value; }
		}
	}
}
