// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ExecuterFactoryUnion.cs,v 1.2 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;

namespace Protra.Lib.Lang.Executer
{
	/// <summary>
	/// IExecuterFactory܂Ƃ߂1
	/// IExecuterFactoryƂĂ݂Ȃ߂̃NXłB
	/// </summary>
	public class ExecuterFactoryUnion : IExecuterFactory
	{
		/// <summary>
		/// IExecuterFactorỹXg
		/// </summary>
		ArrayList factoryList = new ArrayList();

		/// <summary>
		/// RXgN^
		/// </summary>
		public ExecuterFactoryUnion() {}

		/// <summary>
		/// IExecuterFactoryǉ܂B
		/// </summary>
		/// <param name="factory"></param>
		public void Add(IExecuterFactory factory)
		{
			factoryList.Add(factory);
		}

		/// <summary>
		/// IExecuter𐶐܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.NoSuchExecuterException">
		/// IExecuter݂Ȃꍇthrow܂B
		/// </exception>
		/// <param name="ft">֐̃^Cv</param>
		/// <returns>֐sIExcecuterłB</returns>
		public IExecuter CreateExecuter(FunctionType ft)
		{
			foreach(IExecuterFactory factory in factoryList)
			{
				try
				{
					return factory.CreateExecuter(ft);
				}
				catch(NoSuchExecuterException)
				{
				}
			}

			throw new NoSuchExecuterException();
		}
	}
}
