// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004-2007 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Price.cs,v 1.15 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;

namespace Protra.Lib.Db
{
	/// <summary>
	/// Pricee[ũR[h\B
	/// </summary>
	public class Price: IRecord
	{
		private int brandId;
		private DateTime date;
		private int open;
		private int high;
		private int low;
		private int close;
		private double volume;

		/// <summary>
		/// ̃RXgN^
		/// </summary>
		public Price() {}

		/// <summary>
		/// RXgN^
		/// </summary>
		public Price(int brandId, DateTime date,
					 int open, int high, int low, int close, double volume)
		{
			this.brandId = brandId;
			this.date = date;
			this.open = open;
			this.high = high;
			this.low = low;
			this.close = close;
			this.volume = volume;
		}

		/// <summary>
		/// ID擾B
		/// </summary>
		public int BrandId
		{
			get { return brandId; }
		}

		/// <summary>
		/// IDɑΉBrandIuWFNg擾B
		/// </summary>
		public Brand Brand
		{
			get { return BrandTable.GetRecord(brandId); }
		}

		/// <summary>
		/// t擾B
		/// </summary>
		public DateTime Date
		{
			get { return date; }
		}

		/// <summary>
		/// nl擾B
		/// </summary>
		public int Open
		{
			get { return open; }
		}

		/// <summary>
		/// l擾B
		/// </summary>
		public int High
		{
			get { return high; }
		}

		/// <summary>
		/// l擾B
		/// </summary>
		public int Low
		{
			get { return low; }
		}

		/// <summary>
		/// Il擾B
		/// </summary>
		public int Close
		{
			get { return close; }
		}

		/// <summary>
		/// o擾B
		/// </summary>
		public double Volume
		{
			get { return volume; }
		}

		/// <summary>
		/// 䗦KpB
		/// </summary>
		public void Split(double ratio)
		{
			open = (int)(open / ratio);
			high = (int)(high / ratio);
			low = (int)(low / ratio);
			close = (int)(close / ratio);
			volume *= ratio;
		}

		/// <summary>
		/// f[^x[X̃R[hIuWFNgɕϊB
		/// </summary>
		/// <param name="values">lCeBu`̒l̔z</param>
		/// <returns>ϊPriceIuWFNgԂB</returns>
		public Object ToObject(Object[] values)
		{
			return new Price((int)values[0], // @Id
							 (DateTime)values[1], // @Date
							 (int)values[2], // @Open
							 (int)values[3], // @High
							 (int)values[4], // @Low
							 (int)values[5], // @Close
							 (double)values[6]); // @Volume
		}

		/// <summary>
		/// CX^X𕶎\ɕϊB
		/// </summary>
		/// <returns>\ԂB</returns>
		public override string ToString()
		{
			return string.Format(
				"Price[Id={0}, {1}, Open={2}, Low={3}, High={4}, Close={5}, Volume={6}]",
				brandId, date.ToString("d"), open, low, high, close, volume);
		}
	}

	/// <summary>
	/// Pricee[u𑀍삷B
	/// </summary>
	public class PriceTable
	{
		private static Connection conn;
		private static Connection Conn
		{
			get 
			{
				if (conn != null)
					return conn;
				conn = new Connection("protra");
				return conn;
			}
		}

		/// <summary>
		/// IDɑΉ̓̃f[^擾B
		/// </summary>
		/// <param name="brandId">Idw肷B</param>
		/// <returns>Price̔zԂB</returns>
		public static Price[] PriceList(int brandId)
		{
			string sql = string.Format(
				"SELECT * FROM Price WHERE @BrandId={0} ORDER BY @Date",
				brandId);
			ArrayList list = Conn.Query(sql, new Price());
			foreach (Split split in SplitTable.GetRecords(BrandTable.GetRecord(brandId).Code))
			{
				if (split.Date > ((Price)list[list.Count - 1]).Date)
					continue;
				foreach (Price price in list)
					if (price.Date < split.Date)
						price.Split(split.Ratio);
					else
						break;
			}
			return (Price[])list.ToArray(typeof(Price));
		}

		/// <summary>
		/// IDɑΉ̏T̃f[^擾B
		/// </summary>
		/// <param name="brandId">IDw肷B</param>
		/// <returns>Price̔zԂB</returns>
		public static Price[] WeeklyPriceList(int brandId)
		{
			return WeeklyPriceList(brandId, false);
		}

		/// <summary>
		/// IDɑΉ̏T̃f[^擾B
		/// </summary>
		/// <param name="brandId">IDw肷B</param>
		/// <param name="needLastWeek">
		/// ŏIT̃f[^ȂĂlKvȏꍇtruew肷B
		/// </param>
		public static Price[] WeeklyPriceList(int brandId, bool needLastWeek)
		{
			Price[] dailyList = PriceTable.PriceList(brandId);
			if (dailyList.Length == 0)
				return dailyList;

			ArrayList weeklyList = new ArrayList();
			DateTime date = dailyList[0].Date;
			int high = 0;
			int low = 0;
			int open = 0;
			int close = 0;
			double volume = 0;
			DayOfWeek previous_dow = DayOfWeek.Sunday;

			foreach (Price daily in dailyList)
			{
				if (previous_dow > daily.Date.DayOfWeek)
				{
					weeklyList.Add(new Price(brandId, date,
						open, high, low, close, volume));
					date = daily.Date;
					high = daily.High; low = daily.Low;
					open = daily.Open; close = daily.Close;
					volume = daily.Volume;
				}
				else
				{
					if (daily.High > high)
						high = daily.High;
					if (low == 0 || (daily.Low > 0 && daily.Low < low))
						low = daily.Low;
					if (open == 0)
						open = daily.Open;
					close = daily.Close;
					volume += daily.Volume;
				}
				previous_dow = daily.Date.DayOfWeek;
			}

			if (Utils.IsLastOpenDateOfWeek(dailyList[dailyList.Length - 1].Date) || needLastWeek)
				weeklyList.Add(new Price(brandId, date,
										 open, high, low, close, volume));
			return (Price[])weeklyList.ToArray(typeof(Price));
		}

		/// <summary>
		/// ׂẴR[h̓t̂łV̂ԂB
		/// </summary>
		/// <returns>łVtBR[h݂ȂꍇɂDateTime.MinValueB</returns>
		public static DateTime MaxDate()
		{
			string sql = "SELECT MAX(@Date) FROM Price";
			object o = Conn.QueryScalar(sql);
			return o == DBNull.Value ? DateTime.MinValue : (DateTime)o;
		}

		/// <summary>
		/// e[uɃf[^ǉB
		/// </summary>
		/// <param name="brandId">ID</param>
		/// <param name="date">t</param>
		/// <param name="open">nl</param>
		/// <param name="high">l</param>
		/// <param name="low">l</param>
		/// <param name="close">Il</param>
		/// <param name="volume">o</param>
		/// <returns>ǉR[hPriceIuWFNgB</returns>
		public static Price Add(int brandId, DateTime date,
			int open, int high, int low, int close, double volume)
		{
			string sql = string.Format(
				"INSERT INTO Price VALUES({0}, #{1}#, {2}, {3}, {4}, {5}, {6})",
				brandId, date.ToString("d"),
				open, high, low, close, volume);
			Conn.Execute(sql);
			return new Price(brandId, date, open, high, low, close, volume);
		}

		/// <summary>
		/// w肳ꂽtȍ~̃f[^폜B
		/// </summary>
		/// <param name="date">t</param>
		public static void Delete(DateTime date)
		{
			string sql = string.Format(
				"DELETE FROM Price WHERE @Date>=#{0}#",
				date.ToString("d"));
			Conn.Execute(sql);
		}

		/// <summary>
		/// Sf[^폜B
		/// </summary>
		public static void Delete()
		{
			Conn.Execute("DELETE FROM Price");
		}

	}
}
