﻿// Copyright (C) 2005, 2010 panacorn <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ApplicationError.cs 338 2010-04-08 06:42:08Z panacoran $

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace Protra.Lib.Dialogs
{
	/// <summary>
	/// 例外発生時に表示するダイアログです。
	/// </summary>
	public class ApplicationError : System.Windows.Forms.Form
	{
		/// <summary>
		/// 必要なデザイナ変数です。
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// コンストラクタです。
		/// </summary>
		public ApplicationError()
		{
			//
			// Windows フォーム デザイナ サポートに必要です。
			//
			InitializeComponent();
		}

		/// <summary>
		/// 使用されているリソースに後処理を実行します。
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows フォーム デザイナで生成されたコード 
		/// <summary>
		/// デザイナ サポートに必要なメソッドです。このメソッドの内容を
		/// コード エディタで変更しないでください。
		/// </summary>
		private void InitializeComponent()
		{
            this.exitButton = new System.Windows.Forms.Button();
            this.messageText = new System.Windows.Forms.TextBox();
            this.SuspendLayout();
            // 
            // exitButton
            // 
            this.exitButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.exitButton.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.exitButton.Location = new System.Drawing.Point(317, 133);
            this.exitButton.Name = "exitButton";
            this.exitButton.Size = new System.Drawing.Size(75, 22);
            this.exitButton.TabIndex = 1;
            this.exitButton.Text = "無視";
            // 
            // messageText
            // 
            this.messageText.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.messageText.Location = new System.Drawing.Point(12, 12);
            this.messageText.Multiline = true;
            this.messageText.Name = "messageText";
            this.messageText.ReadOnly = true;
            this.messageText.ScrollBars = System.Windows.Forms.ScrollBars.Both;
            this.messageText.Size = new System.Drawing.Size(380, 115);
            this.messageText.TabIndex = 2;
            // 
            // ApplicationError
            // 
            this.AcceptButton = this.exitButton;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
            this.ClientSize = new System.Drawing.Size(404, 162);
            this.ControlBox = false;
            this.Controls.Add(this.messageText);
            this.Controls.Add(this.exitButton);
            this.Name = "ApplicationError";
            this.Text = "エラー";
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

        private System.Windows.Forms.Button exitButton;
		private System.Windows.Forms.TextBox messageText;

		
		/// <summary>
		/// エラーの種類を表す列挙型です。
		/// </summary>
		public enum ErrorType
		{
			/// <summary>
			/// 回復可能なエラー。
			/// </summary>
			Recoverable,
			/// <summary>
			/// 致命的なエラー。
			/// </summary>
			Fatal
		}

        private ErrorType mode;

		/// <summary>
		/// エラーの種類です。
		/// </summary>
		public ErrorType Mode
		{
            get { return mode; }
            set
            {
				mode = value;
				if (value == ErrorType.Fatal)
					this.exitButton.Text = "終了";
				else
					this.exitButton.Text = "無視";
			}
		}

		/// <summary>
		/// 表示するエラーメッセージです。
		/// </summary>
		public string ErrorMessage
		{
			set
			{
				messageText.Lines = value.Split(new Char[] {'\n'});
			}
		}
	}
}
