﻿// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Node.cs 306 2010-03-19 13:21:22Z panacoran $

using System;
using System.Collections.Generic;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// プログラムの構文木のノードを表す抽象クラス。
	/// </summary>
	public abstract class Node
	{
        static private Scanner scanner;
        private Token token;
        static private Stack<Dictionary<string, int>> lvtStack = new Stack<Dictionary<string,int>>();

        /// <summary>
        /// 字句解析器を取得または設定する。
        /// </summary>
        static public Scanner Scanner
        {
            get { return scanner; }
            set { scanner = value; }
        }

        /// <summary>
        /// ローカル変数の記号表のスタックを取得する。
        /// </summary>
        static public Stack<Dictionary<string, int>> LvtStack
        {
            get { return lvtStack; }
        }

        /// <summary>
        /// このノードが属するトークンを取得または設定する。
        /// </summary>
        /// <returns>このノードが属するトークン</returns>
        public Token Token
        {
            get { return token; }
            set { token = value; }
        }

		/// <summary>
		/// 構文解析する。
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// 構文解析中にエラーが発生した場合にthrowされる。
		/// </exception>
        /// <return>
        /// 解析した結果のノード。
        /// </return>
        public abstract Node Parse();

		/// <summary>
		/// プログラムを実行する。
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// プログラム実行中にエラーが発生した場合にthrowされる。
		/// </exception>
		/// <param name="resource">リソース</param>
		/// <param name="at">@作用素の値</param>
		/// <returns>実行結果</returns>
		public abstract Value Execute(Resource resource, int at);
	}
}
