﻿// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Builtins.cs 431 2011-11-06 09:43:30Z darai $

using System;

namespace Protra.Lib.Lang
{
    /// <summary>
    /// 組み込み関数が存在しないときにスローされる例外。
    /// </summary>
    public class NoSuchBuiltinException : Exception {}

    /// <summary>
    /// 組み込み関数を実行するクラス。
    /// </summary>
    public class Builtins
    {
        /// <summary>
        /// 組み込み関数を実行する。
        /// </summary>
        /// <param name="name">名前</param>
        /// <param name="args">引数の配列</param>
        /// <param name="at">int型@作用素</param>
        /// <param name="ats">string型@作用素</param>
        /// <returns></returns>
        public virtual Value Invoke(string name, Value[] args, int at, string ats)
        {
            if (args.Length == 1)
            {
                switch (name)
                {
                    case "Length": // 配列長
                        return new Value(((Value[])(args[0].InnerValue)).Length);
                }
            }

            throw new NoSuchBuiltinException();
        }
    }
}
