// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004 M. Ishiguro <mishiguro@users.sourceforge.jp>
// Copyright (C) 2004, 2007 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ChartBox.cs,v 1.7 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Data;
using System.Windows.Forms;
using Protra.Lib.Db;
using Protra.Lib.Lang;
using Protra.Lib.Lang.Executer;

namespace Protra.Lib.Controls
{
	/// <summary>
	/// `[g`悷Rg[łB
	/// </summary>
	public class ChartBox : System.Windows.Forms.UserControl, IExecuterFactory
	{
		/// <summary>
		/// `֐̌Ăяo\NXłB
		/// </summary>
		private class RenderCall
		{
			private DelegateExecuter.Delegate del;
			private Value[] args;
			
			/// <summary>
			/// RXgN^
			/// </summary>
			/// <param name="del">fQ[g</param>
			/// <param name="args"></param>
			public RenderCall(DelegateExecuter.Delegate del, Value[] args)
			{
				this.del = del;
				this.args = args;
			}

			/// <summary>
			/// Ăяos܂B
			/// </summary>
			public void Execute()
			{
				del(args, 0);
			}
		}

		/// <summary>
		/// ɂԊu
		/// </summary>
		private const int LeftMargin = 55;
		/// <summary>
		/// 㑤ɂԊu
		/// </summary>
		private const int TopMargin = 10;
		/// <summary>
		/// EɂԊu
		/// </summary>
		private const int RightMargin = 10;
		/// <summary>
		/// ɂԊu
		/// </summary>
		private const int BottomMargin = 20;

		/// <summary>
		/// vOt@C
		/// </summary>
		private string programFile;
		/// <summary>
		/// C^v^t@T[h
		/// </summary>
		private InterpreterFacade facade;
		/// <summary>
		/// `ΏۂƂȂPrice̔z
		/// </summary>
		private Price[] prices;
		/// <summary>
		/// `[g̉E[̃CfbNX
		/// </summary>
		private int rightIndex;
		/// <summary>
		/// ݕ`撆̃CfbNX
		/// </summary>
		private int index;
		/// <summary>
		/// ̊Ԋu
		/// </summary>
		private int dx = 6;
		/// <summary>
		/// ݕ`撆XW
		/// </summary>
		private int x;
		/// <summary>
		/// ƂɌ`悷邩
		/// </summary>
		private int monthInterval = 1;
		/// <summary>
		/// `ΏۂGraphics
		/// </summary>
		private Graphics g;
		/// <summary>
		/// `[g̋`
		/// </summary>
		private Rectangle chartRect;
		/// <summary>
		/// c̍őlƍŏl
		/// </summary>
		private double maxY, minY;
		/// <summary>
		/// z`撆H
		/// </summary>
		private bool isVirtualRendering;
		/// <summary>
		/// `֐̌ĂяoXg
		/// </summary>
		private ArrayList renderCalls;
		/// <summary>
		/// FunctionTypeDelegateExecuter.Delegate
		/// ΉnbV
		/// </summary>
		private Hashtable hash = new Hashtable();
		/// <summary>
		/// IExecuter𐶐Factory
		/// </summary>
		private ExecuterFactoryUnion factory;

		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// RXgN^
		/// </summary>
		public ChartBox()
		{
			// ̌ĂяóAWindows.Forms tH[ fUCiŕKvłB
			InitializeComponent();
			
			// nbVɃfQ[go^܂B
			hash.Add(new FunctionType("X", 0), new DelegateExecuter.Delegate(X));
			hash.Add(new FunctionType("Dx", 0), new DelegateExecuter.Delegate(_Dx));
			hash.Add(new FunctionType("Index", 0), new DelegateExecuter.Delegate(Index));
			hash.Add(new FunctionType("RightIndex", 0), new DelegateExecuter.Delegate(_RightIndex));
			hash.Add(new FunctionType("Year", 0), new DelegateExecuter.Delegate(Year));
			hash.Add(new FunctionType("Month", 0), new DelegateExecuter.Delegate(Month));
			hash.Add(new FunctionType("Day", 0), new DelegateExecuter.Delegate(Day));
			hash.Add(new FunctionType("DayOfWeek", 0), new DelegateExecuter.Delegate(DayOfWeek));
			hash.Add(new FunctionType("Open", 0), new DelegateExecuter.Delegate(Open));
			hash.Add(new FunctionType("High", 0), new DelegateExecuter.Delegate(High));
			hash.Add(new FunctionType("Low", 0), new DelegateExecuter.Delegate(Low));
			hash.Add(new FunctionType("Close", 0), new DelegateExecuter.Delegate(Close));
			hash.Add(new FunctionType("Volume", 0), new DelegateExecuter.Delegate(Volume));
			hash.Add(new FunctionType("Code", 0), new DelegateExecuter.Delegate(Code));
			hash.Add(new FunctionType("Rgb", 3), new DelegateExecuter.Delegate(Rgb));
			hash.Add(new FunctionType("DrawLine", 5), new DelegateExecuter.Delegate(DrawLine));
			hash.Add(new FunctionType("DrawRectangle", 5), new DelegateExecuter.Delegate(DrawRectangle));
			hash.Add(new FunctionType("DrawEllipse", 5), new DelegateExecuter.Delegate(DrawEllipse));
			hash.Add(new FunctionType("DrawString", 4), new DelegateExecuter.Delegate(DrawString));
			hash.Add(new FunctionType("DrawString", 5), new DelegateExecuter.Delegate(DrawString));
			hash.Add(new FunctionType("FillRectangle", 5), new DelegateExecuter.Delegate(FillRectangle));
			hash.Add(new FunctionType("FillEllipse", 5), new DelegateExecuter.Delegate(FillEllipse));

			// w֐Ƃ̍Factory`
			factory = new ExecuterFactoryUnion();
			factory.Add(this);
			factory.Add(new MathExecuterFactory());
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
			// 
			// ChartBox
			// 
			this.Name = "ChartBox";
			this.SizeChanged += new System.EventHandler(this.ChartBox_SizeChanged);
			this.Paint += new System.Windows.Forms.PaintEventHandler(this.ChartBox_Paint);

		}
		#endregion

		/// <summary>
		/// vOt@C擾܂͐ݒ肵܂B
		/// </summary>
		public string ProgramFile
		{
			get { return programFile; }
			set
			{
				programFile = value;
				if(programFile == null)
				{
					facade = null; return;
				}

				try
				{
					facade = new InterpreterFacade(programFile, factory);
				}
				catch(ParseException exc)
				{
					facade = null;
					MessageBox.Show(exc.Message);
				}

				this.Invalidate();
			}
		}

		/// <summary>
		/// `ΏۂƂȂPrice̔z擾܂͐ݒ肵܂B
		/// </summary>
		public Price[] Prices
		{
			get { return prices; }
			set
			{
				prices = value;
				if(prices != null)
					rightIndex = prices.Length - 1;
				this.Invalidate();
			}
		}

		/// <summary>
		/// `[g̉E[̃CfbNX擾܂͐ݒ肵܂B
		/// </summary>
		public int RightIndex
		{
			get { return rightIndex; }
			set
			{
				rightIndex = value;
				this.Invalidate();
			}
		}

		/// <summary>
		/// ̊Ԋu擾܂͐ݒ肵܂B
		/// </summary>
		public int Dx
		{
			get { return dx; }
			set
			{
				dx = value;
				this.Invalidate();
			}
		}

		/// <summary>
		/// ƂɌ`悷邩l擾܂͐ݒ肵܂B
		/// </summary>
		public int MonthInterval
		{
			get { return monthInterval; }
			set
			{
				monthInterval = value;
				this.Invalidate();
			}
		}

		/// <summary>
		/// ̉i`悳邩擾܂B
		/// </summary>
		public int Count
		{
			get { return (this.Width - LeftMargin - RightMargin - 1)/dx; } 
		}

		private void ChartBox_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			if(facade == null || prices == null || prices.Length == 0)
				return;
			
			g = e.Graphics;
			Brush brush = new SolidBrush(this.ForeColor);
			Pen pen = new Pen(this.ForeColor);
			Color dotColor = Color.FromArgb(
				(this.BackColor.A + this.ForeColor.A)/2,
				(this.BackColor.R + this.ForeColor.R)/2,
				(this.BackColor.G + this.ForeColor.G)/2,
				(this.BackColor.B + this.ForeColor.B)/2);
			Pen dotPen = new Pen(dotColor);
			dotPen.DashStyle = DashStyle.Dot;
			chartRect = new Rectangle(
				LeftMargin, TopMargin,
				this.Width - LeftMargin - RightMargin - 1,
				this.Height - TopMargin - BottomMargin);
			
			// O[oϐ̐ݒ
			facade.GlobalVariableTable.Clear();
			facade.GlobalVariableTable["$Names"] = new Value(new Value[6]);
			facade.GlobalVariableTable["$Colors"] = new Value(new Value[6]);
			facade.GlobalVariableTable["$IsTimeSeries"] = new Value(true);

			// z`ɂďc̃XP[𓾂
			int count = chartRect.Width/dx;
			maxY = double.MinValue;
			minY = double.MaxValue;
			isVirtualRendering = true;
			renderCalls = new ArrayList();
			index = Math.Max(0, rightIndex - count + 1);
			x = chartRect.Right - (rightIndex - index + 1)*dx;
			while(index <= rightIndex)
			{
				try
				{
					facade.Execute();
				}
				catch(Exception exc)
				{
					string msg = exc.Message;
					g.DrawString(msg, this.Font, brush, 0, 0);
					return;
				}
				x += dx;
				index++;
			}

			// c̒l̕`
			if(maxY != double.MinValue)
			{
				if(maxY == minY)
				{
					maxY += 1;
					minY -= 1;
				}
				double band = (maxY - minY)/5;
				double a = 0.01;
				while(true)
				{
					if(band < 10*a)
					{
						for(double b = a; b <= 10*a; b += a)
							if(b >= band)
							{
								band = b;
								break;
							}
						break;
					}
					a *= 10;
				}
				if(maxY < 0)
					maxY = (int)(maxY/band)*band;
				else
					maxY = Math.Ceiling(maxY/band)*band;
				if(minY < 0)
					minY = -Math.Ceiling(-minY/band)*band;
				else
					minY = (int)(minY/band)*band;
				double m = minY + band;
				double ratio = chartRect.Height/(maxY - minY);
				while(m < maxY)
				{
					m = (long)(100*m)/100.0;
					string text = m.ToString();
					
					SizeF size = g.MeasureString(text, this.Font);
					g.DrawString(text, this.Font, brush,
						chartRect.Left - size.Width,
						(float)(chartRect.Bottom - (m - minY)*ratio - size.Height/2));
					g.DrawLine(dotPen,
						chartRect.Left, (float)(chartRect.Bottom - (m - minY)*ratio),
						chartRect.Right, (float)(chartRect.Bottom - (m - minY)*ratio));
					m += band;
				}
			}

			// t̕`
			if(facade.GlobalVariableTable["$IsTimeSeries"].IsTrue)
			{
				index = Math.Max(0, rightIndex - count + 1);
				x = chartRect.Right - (rightIndex - index + 1)*dx;
				DateTime preDate = prices[index].Date;
				while(index <= rightIndex)
				{
					DateTime date = prices[index].Date;
					if((date.Month - 1) % monthInterval == 0)
						if(date.Month != preDate.Month)
						{
							string text = date.ToString("yy/MM");
							SizeF size = g.MeasureString(text, this.Font);
							g.DrawString(text, this.Font, brush,
								x - (dx + size.Width)/2, chartRect.Bottom);
							g.DrawLine(dotPen,
								x - dx/2, chartRect.Top,
								x - dx/2, chartRect.Bottom);
							preDate = date;
						}
					x += dx;
					index++;
				}
			}

			// {Ԃ̕`
			Region oldClip = g.Clip;
			g.Clip = new Region(chartRect);
			isVirtualRendering = false;
			foreach(RenderCall call in renderCalls)
				call.Execute();
			g.Clip = oldClip;
			renderCalls = null;

			// g̕`
			g.DrawRectangle(pen, chartRect);

			// wW̕`
			Value[] names = (Value[])facade.GlobalVariableTable["$Names"].InnerValue;
			Value[] colors = (Value[])facade.GlobalVariableTable["$Colors"].InnerValue;
			x = chartRect.Left + 10;
			for(int i = 0; i < names.Length; i++)
				if(names[i] != null && colors[i] != null)
				{
					string text = (string)names[i].InnerValue;
					int rgb = (int)colors[i].InnerValue;
					SizeF size = g.MeasureString(text, this.Font);
					Rectangle rect = new Rectangle(x, chartRect.Top + 10, (int)size.Height, (int)size.Height);
					g.FillRectangle(new SolidBrush(Color.FromArgb(rgb)), rect);
					g.DrawRectangle(pen, rect);
					g.DrawString(text, this.Font, brush, rect.Right, rect.Top);
					x = (int)(rect.Right + size.Width); 
				}
		}

		private void ChartBox_SizeChanged(object sender, System.EventArgs e)
		{
			this.Invalidate();
		}

		/// <summary>
		/// IExecuter𐶐܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.NoSuchExecuterException">
		/// IExecuter݂Ȃꍇthrow܂B
		/// </exception>
		/// <param name="ft">֐̃^Cv</param>
		/// <returns>֐sIExcecuterłB</returns>
		public IExecuter CreateExecuter(FunctionType ft)
		{
			if(hash.ContainsKey(ft))
				return new DelegateExecuter((DelegateExecuter.Delegate)hash[ft]);
			throw new NoSuchExecuterException();
		}

		/// <summary>
		/// ݕ`撆XW擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>XWłB</returns>
		private Value X(Value[] args, int at)
		{
			return new Value(x + at*dx);
		}

		/// <summary>
		/// ̊Ԋu擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>̊ԊułB</returns>
		private Value _Dx(Value[] args, int at)
		{
			return new Value(dx);
		}

		/// <summary>
		/// ݕ`撆̃CfbNX擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>CfbNXłB</returns>
		private Value Index(Value[] args, int at)
		{
			return new Value(index + at);
		}

		/// <summary>
		/// E[̃CfbNX擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>E[̃CfbNXłB</returns>
		private Value _RightIndex(Value[] args, int at)
		{
			return new Value(rightIndex);
		}

		/// <summary>
		/// ݕ`撆̔N擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>NłB</returns>
		private Value Year(Value[] args, int at)
		{
			try
			{
				return new Value(prices[index + at].Date.Year);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// ݕ`撆̌擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>łB</returns>
		private Value Month(Value[] args, int at)
		{
			try
			{
				return new Value(prices[index + at].Date.Month);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// ݕ`撆̓t擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>tłB</returns>
		private Value Day(Value[] args, int at)
		{
			try
			{
				return new Value(prices[index + at].Date.Day);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// ݕ`撆̗j擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>jłB</returns>
		private Value DayOfWeek(Value[] args, int at)
		{
			try
			{
				return new Value((int)prices[index + at].Date.DayOfWeek);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// nl擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>nlłB</returns>
		private Value Open(Value[] args, int at)
		{
			try
			{
				return new Value(prices[index + at].Open);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// l擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>lłB</returns>
		private Value High(Value[] args, int at)
		{
			try
			{
				return new Value(prices[index + at].High);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// l擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>lłB</returns>
		private Value Low(Value[] args, int at)
		{
			try
			{
				return new Value(prices[index + at].Low);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// Il擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>IlłB</returns>
		private Value Close(Value[] args, int at)
		{
			try
			{
				return new Value(prices[index + at].Close);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// o擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>ołB</returns>
		private Value Volume(Value[] args, int at)
		{
			try
			{
				return new Value(prices[index + at].Volume);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// R[h擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>R[hłB</returns>
		private Value Code(Value[] args, int at)
		{
			try
			{
				return new Value(prices[0].Brand.Code);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}
		
		/// <summary>
		/// RgblvZ܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>vZʂłB</returns>
		private Value Rgb(Value[] args, int at)
		{
			int r = (int)args[0].InnerValue;
			int g = (int)args[1].InnerValue;
			int b = (int)args[2].InnerValue;
			int rgb = Color.FromArgb(r, g, b).ToArgb();
			return new Value(rgb);
		}

		/// <summary>
		/// `悵܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>nullԂ܂B</returns>
		private Value DrawLine(Value[] args, int at)
		{
			int rgb = (int)args[0].InnerValue;
			double x1 = (double)args[1].Cast(Value.Type.Float).InnerValue;
			double y1 = (double)args[2].Cast(Value.Type.Float).InnerValue;
			double x2 = (double)args[3].Cast(Value.Type.Float).InnerValue;
			double y2 = (double)args[4].Cast(Value.Type.Float).InnerValue;
			if (isVirtualRendering)
			{
				maxY = Math.Max(Math.Max(y1, y2), maxY);
				minY = Math.Min(Math.Min(y1, y2), minY);
				renderCalls.Add(new RenderCall(new DelegateExecuter.Delegate(DrawLine), args));
			}
			else
			{
				y1 = chartRect.Bottom - chartRect.Height * (y1 - minY) / (maxY - minY);
				y2 = chartRect.Bottom - chartRect.Height * (y2 - minY) / (maxY - minY);
				this.g.DrawLine(new Pen(Color.FromArgb(rgb)),
					(float)x1, (float)y1, (float)x2, (float)y2);
			}
			return null;
		}

		/// <summary>
		/// ``悵܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>nullԂ܂B</returns>
		private Value DrawRectangle(Value[] args, int at)
		{
			int rgb = (int)args[0].InnerValue;
			double x = (double)args[1].Cast(Value.Type.Float).InnerValue;
			double y = (double)args[2].Cast(Value.Type.Float).InnerValue;
			double width = (double)args[3].Cast(Value.Type.Float).InnerValue;
			double height = (double)args[4].Cast(Value.Type.Float).InnerValue;
			if (isVirtualRendering)
			{
				maxY = Math.Max(Math.Max(y, y + height), maxY);
				minY = Math.Min(Math.Min(y, y + height), minY);
				renderCalls.Add(new RenderCall(new DelegateExecuter.Delegate(DrawRectangle), args));
			}
			else
			{
				y = chartRect.Bottom - chartRect.Height * (y - minY) / (maxY - minY);
				height = chartRect.Height * height / (maxY - minY);
				this.g.DrawRectangle(new Pen(Color.FromArgb(rgb)),
					(float)x, (float)(y - height), (float)width, (float)height);
			}
			return null;
		}

		/// <summary>
		/// ȉ~`悵܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>nullԂ܂B</returns>
		private Value DrawEllipse(Value[] args, int at)
		{
			int rgb = (int)args[0].InnerValue;
			double x = (double)args[1].Cast(Value.Type.Float).InnerValue;
			double y = (double)args[2].Cast(Value.Type.Float).InnerValue;
			double width = (double)args[3].Cast(Value.Type.Float).InnerValue;
			double height = (double)args[4].Cast(Value.Type.Float).InnerValue;
			if (isVirtualRendering)
			{
				maxY = Math.Max(Math.Max(y, y + height), maxY);
				minY = Math.Min(Math.Min(y, y + height), minY);
				renderCalls.Add(new RenderCall(new DelegateExecuter.Delegate(DrawEllipse), args));
			}
			else
			{
				y = chartRect.Bottom - chartRect.Height * (y - minY) / (maxY - minY);
				height = chartRect.Height*height / (maxY - minY);
				this.g.DrawEllipse(new Pen(Color.FromArgb(rgb)),
					(float)x, (float)(y - height), (float)width, (float)height);
			}
			return null;
		}

		/// <summary>
		/// `悵܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>nullԂ܂B</returns>
		private Value DrawString(Value[] args, int at)
		{
			int i = 0;
			int rgb = Color.Black.ToArgb();
			if (args.Length > 4)
				rgb = (int)args[i++].InnerValue;
			string text = (string)args[i++].InnerValue;
			double x = (double)args[i++].Cast(Value.Type.Float).InnerValue;
			double y = (double)args[i++].Cast(Value.Type.Float).InnerValue;
			int dh = (int)args[i++].InnerValue;
			if(isVirtualRendering)
			{
				maxY = Math.Max(y, maxY);
				minY = Math.Min(y, minY);
				renderCalls.Add(new RenderCall(new DelegateExecuter.Delegate(DrawString), args));
			}
			else
			{
				SizeF size = g.MeasureString(text, this.Font);
				y = chartRect.Bottom - chartRect.Height * (y - minY) / (maxY - minY);
				this.g.DrawString(text, this.Font, new SolidBrush(Color.FromArgb(rgb)),
					(float)(x - size.Width / 2), (float)(y - size.Height / 2) - dh);
			}
			return null;
		}

		/// <summary>
		/// `hԂ܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>nullԂ܂B</returns>
		private Value FillRectangle(Value[] args, int at)
		{
			int rgb = (int)args[0].InnerValue;
			double x = (double)args[1].Cast(Value.Type.Float).InnerValue;
			double y = (double)args[2].Cast(Value.Type.Float).InnerValue;
			double width = (double)args[3].Cast(Value.Type.Float).InnerValue;
			double height = (double)args[4].Cast(Value.Type.Float).InnerValue;
			if (isVirtualRendering)
			{
				maxY = Math.Max(Math.Max(y, y + height), maxY);
				minY = Math.Min(Math.Min(y, y + height), minY);
				renderCalls.Add(new RenderCall(new DelegateExecuter.Delegate(FillRectangle), args));
			}
			else
			{
				y = chartRect.Bottom - chartRect.Height * (y - minY) / (maxY - minY);
				height = chartRect.Height * height / (maxY - minY);
				if (-1 < height && height < 0)
					height = -1;
				if (0 < height && height < 1)
					height = 1;
				this.g.FillRectangle(new SolidBrush(Color.FromArgb(rgb)),
					(float)x, (float)(y - height), (float)width, (float)height);
			}
			return null;
		}

		/// <summary>
		/// ȉ~hԂ܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>nullԂ܂B</returns>
		private Value FillEllipse(Value[] args, int at)
		{
			int rgb = (int)args[0].InnerValue;
			double x = (double)args[1].Cast(Value.Type.Float).InnerValue;
			double y = (double)args[2].Cast(Value.Type.Float).InnerValue;
			double width = (double)args[3].Cast(Value.Type.Float).InnerValue;
			double height = (double)args[4].Cast(Value.Type.Float).InnerValue;
			if(isVirtualRendering)
			{
				maxY = Math.Max(Math.Max(y, y + height), maxY);
				minY = Math.Min(Math.Min(y, y + height), minY);
				renderCalls.Add(new RenderCall(new DelegateExecuter.Delegate(FillEllipse), args));
			}
			else
			{
				y = chartRect.Bottom - chartRect.Height * (y - minY) / (maxY - minY);
				height = chartRect.Height * height / (maxY - minY);
				if (-1 < height && height < 0)
					height = -1;
				if (0 < height && height < 1)
					height = 1;
				this.g.FillEllipse(new SolidBrush(Color.FromArgb(rgb)),
					(float)x, (float)(y - height), (float)width, (float)height);
			}
			return null;
		}
	}
}
