﻿// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004, 2005, 2007, 2008, 2010 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: OptionDialog.cs 439 2013-02-17 04:33:01Z panacoran $

using System;
using System.Drawing;
using System.Windows.Forms;
using Protra.Lib;
using Protra.Lib.Config;
using Protra.Lib.Update;

namespace Protra.Dialogs
{
	/// <summary>
	/// オプションのダイアログです。
	/// </summary>
	public class OptionDialog : System.Windows.Forms.Form
	{
		private System.Windows.Forms.TabControl tabControl;
		private System.Windows.Forms.TabPage tabPageChart;
		private System.Windows.Forms.TabPage tabPageUpload;
		private System.Windows.Forms.Button buttonOk;
		private System.Windows.Forms.Button buttonCancel;
		private System.Windows.Forms.NumericUpDown numericUpDownChartNum;
		private System.Windows.Forms.Label labelChartNum;
		private System.Windows.Forms.GroupBox groupBoxChartColor;
		private System.Windows.Forms.Label labelChartBackColor;
		private System.Windows.Forms.Label labelChartForeColor;
		private System.Windows.Forms.Button buttonChartBackColor;
		private System.Windows.Forms.Button buttonChartForeColor;
        private System.Windows.Forms.GroupBox groupBoxProxy;
		private System.Windows.Forms.Label labelProxyAddress;
		private System.Windows.Forms.Label labelProxyPort;
		private System.Windows.Forms.TextBox textBoxProxyAddress;
		private System.Windows.Forms.TextBox textBoxProxyPort;
		private System.Windows.Forms.Label labelPriceDataSource;
		private System.Windows.Forms.ComboBox comboBoxPriceDataSource;
		private System.Windows.Forms.Label labelDataSourceInfo;
		private System.Windows.Forms.CheckBox drawLastWeek;
		private System.Windows.Forms.CheckBox useDifferentChart;
        private RadioButton radioButtonOriginalProxy;
        private RadioButton radioButtonIEProxy;
        /// <summary>
		/// 必要なデザイナ変数です。
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		public OptionDialog()
		{
			//
			// Windows フォーム デザイナ サポートに必要です。
			//
			InitializeComponent();

            // データソースの選択肢を設定する。
            comboBoxPriceDataSource.Items.AddRange(PriceDataUpdator.DataSourceNames);

            // Protraに関する設定を反映させる。
            var p = GlobalEnv.ProtraConfig;
            numericUpDownChartNum.Value = p.ChartNum;
            buttonChartForeColor.BackColor = Color.FromArgb(p.ChartForeColor);
            buttonChartBackColor.BackColor = Color.FromArgb(p.ChartBackColor);
            drawLastWeek.Checked = p.DrawLastWeek;
            useDifferentChart.Checked = p.UseDifferentChart;

            // データ更新に関する設定を反映させる。
            var u = GlobalEnv.UpdateConfig;
            comboBoxPriceDataSource.SelectedIndex = (int)u.PriceDataSource;
            radioButtonOriginalProxy.Checked = u.UseProxy;
            textBoxProxyAddress.Text = u.ProxyAddress;
            if (u.ProxyPort > 0)
                textBoxProxyPort.Text = u.ProxyPort.ToString();
		}

		/// <summary>
		/// 使用されているリソースに後処理を実行します。
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// デザイナ サポートに必要なメソッドです。このメソッドの内容を
		/// コード エディタで変更しないでください。
		/// </summary>
		private void InitializeComponent()
		{
            this.tabControl = new System.Windows.Forms.TabControl();
            this.tabPageUpload = new System.Windows.Forms.TabPage();
            this.labelDataSourceInfo = new System.Windows.Forms.Label();
            this.comboBoxPriceDataSource = new System.Windows.Forms.ComboBox();
            this.labelPriceDataSource = new System.Windows.Forms.Label();
            this.groupBoxProxy = new System.Windows.Forms.GroupBox();
            this.radioButtonOriginalProxy = new System.Windows.Forms.RadioButton();
            this.radioButtonIEProxy = new System.Windows.Forms.RadioButton();
            this.textBoxProxyPort = new System.Windows.Forms.TextBox();
            this.textBoxProxyAddress = new System.Windows.Forms.TextBox();
            this.labelProxyPort = new System.Windows.Forms.Label();
            this.labelProxyAddress = new System.Windows.Forms.Label();
            this.tabPageChart = new System.Windows.Forms.TabPage();
            this.useDifferentChart = new System.Windows.Forms.CheckBox();
            this.drawLastWeek = new System.Windows.Forms.CheckBox();
            this.groupBoxChartColor = new System.Windows.Forms.GroupBox();
            this.buttonChartForeColor = new System.Windows.Forms.Button();
            this.buttonChartBackColor = new System.Windows.Forms.Button();
            this.labelChartForeColor = new System.Windows.Forms.Label();
            this.labelChartBackColor = new System.Windows.Forms.Label();
            this.numericUpDownChartNum = new System.Windows.Forms.NumericUpDown();
            this.labelChartNum = new System.Windows.Forms.Label();
            this.buttonOk = new System.Windows.Forms.Button();
            this.buttonCancel = new System.Windows.Forms.Button();
            this.tabControl.SuspendLayout();
            this.tabPageUpload.SuspendLayout();
            this.groupBoxProxy.SuspendLayout();
            this.tabPageChart.SuspendLayout();
            this.groupBoxChartColor.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.numericUpDownChartNum)).BeginInit();
            this.SuspendLayout();
            // 
            // tabControl
            // 
            this.tabControl.Controls.Add(this.tabPageUpload);
            this.tabControl.Controls.Add(this.tabPageChart);
            this.tabControl.Location = new System.Drawing.Point(8, 8);
            this.tabControl.Name = "tabControl";
            this.tabControl.SelectedIndex = 0;
            this.tabControl.Size = new System.Drawing.Size(376, 270);
            this.tabControl.TabIndex = 0;
            // 
            // tabPageUpload
            // 
            this.tabPageUpload.Controls.Add(this.labelDataSourceInfo);
            this.tabPageUpload.Controls.Add(this.comboBoxPriceDataSource);
            this.tabPageUpload.Controls.Add(this.labelPriceDataSource);
            this.tabPageUpload.Controls.Add(this.groupBoxProxy);
            this.tabPageUpload.Location = new System.Drawing.Point(4, 22);
            this.tabPageUpload.Name = "tabPageUpload";
            this.tabPageUpload.Size = new System.Drawing.Size(368, 244);
            this.tabPageUpload.TabIndex = 1;
            this.tabPageUpload.Text = "データ更新";
            // 
            // labelDataSourceInfo
            // 
            this.labelDataSourceInfo.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.labelDataSourceInfo.Location = new System.Drawing.Point(28, 54);
            this.labelDataSourceInfo.Name = "labelDataSourceInfo";
            this.labelDataSourceInfo.Padding = new System.Windows.Forms.Padding(3);
            this.labelDataSourceInfo.Size = new System.Drawing.Size(316, 44);
            this.labelDataSourceInfo.TabIndex = 3;
            this.labelDataSourceInfo.Text = "データソースを選択してください。";
            // 
            // comboBoxPriceDataSource
            // 
            this.comboBoxPriceDataSource.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboBoxPriceDataSource.Location = new System.Drawing.Point(117, 21);
            this.comboBoxPriceDataSource.Name = "comboBoxPriceDataSource";
            this.comboBoxPriceDataSource.Size = new System.Drawing.Size(163, 20);
            this.comboBoxPriceDataSource.TabIndex = 2;
            this.comboBoxPriceDataSource.SelectedIndexChanged += new System.EventHandler(this.comboBoxPriceDataSource_SelectedIndexChanged);
            // 
            // labelPriceDataSource
            // 
            this.labelPriceDataSource.Location = new System.Drawing.Point(28, 24);
            this.labelPriceDataSource.Name = "labelPriceDataSource";
            this.labelPriceDataSource.Size = new System.Drawing.Size(92, 16);
            this.labelPriceDataSource.TabIndex = 1;
            this.labelPriceDataSource.Text = "株価データソース";
            // 
            // groupBoxProxy
            // 
            this.groupBoxProxy.Controls.Add(this.radioButtonOriginalProxy);
            this.groupBoxProxy.Controls.Add(this.radioButtonIEProxy);
            this.groupBoxProxy.Controls.Add(this.textBoxProxyPort);
            this.groupBoxProxy.Controls.Add(this.textBoxProxyAddress);
            this.groupBoxProxy.Controls.Add(this.labelProxyPort);
            this.groupBoxProxy.Controls.Add(this.labelProxyAddress);
            this.groupBoxProxy.Location = new System.Drawing.Point(28, 112);
            this.groupBoxProxy.Name = "groupBoxProxy";
            this.groupBoxProxy.Size = new System.Drawing.Size(316, 112);
            this.groupBoxProxy.TabIndex = 0;
            this.groupBoxProxy.TabStop = false;
            this.groupBoxProxy.Text = "プロキシサーバ";
            // 
            // radioButtonOriginalProxy
            // 
            this.radioButtonOriginalProxy.AutoSize = true;
            this.radioButtonOriginalProxy.Location = new System.Drawing.Point(16, 40);
            this.radioButtonOriginalProxy.Name = "radioButtonOriginalProxy";
            this.radioButtonOriginalProxy.Size = new System.Drawing.Size(133, 16);
            this.radioButtonOriginalProxy.TabIndex = 7;
            this.radioButtonOriginalProxy.Text = "以下の設定を使用する";
            this.radioButtonOriginalProxy.UseVisualStyleBackColor = true;
            this.radioButtonOriginalProxy.CheckedChanged += new System.EventHandler(this.radioButtonOriginalProxy_CheckedChanged);
            // 
            // radioButtonIEProxy
            // 
            this.radioButtonIEProxy.AutoSize = true;
            this.radioButtonIEProxy.Checked = true;
            this.radioButtonIEProxy.Location = new System.Drawing.Point(16, 18);
            this.radioButtonIEProxy.Name = "radioButtonIEProxy";
            this.radioButtonIEProxy.Size = new System.Drawing.Size(194, 16);
            this.radioButtonIEProxy.TabIndex = 6;
            this.radioButtonIEProxy.TabStop = true;
            this.radioButtonIEProxy.Text = "Internet Explorerの設定を使用する";
            this.radioButtonIEProxy.UseVisualStyleBackColor = true;
            // 
            // textBoxProxyPort
            // 
            this.textBoxProxyPort.Enabled = false;
            this.textBoxProxyPort.Location = new System.Drawing.Point(246, 78);
            this.textBoxProxyPort.Name = "textBoxProxyPort";
            this.textBoxProxyPort.Size = new System.Drawing.Size(56, 19);
            this.textBoxProxyPort.TabIndex = 4;
            // 
            // textBoxProxyAddress
            // 
            this.textBoxProxyAddress.Enabled = false;
            this.textBoxProxyAddress.Location = new System.Drawing.Point(16, 78);
            this.textBoxProxyAddress.Name = "textBoxProxyAddress";
            this.textBoxProxyAddress.Size = new System.Drawing.Size(220, 19);
            this.textBoxProxyAddress.TabIndex = 3;
            // 
            // labelProxyPort
            // 
            this.labelProxyPort.Enabled = false;
            this.labelProxyPort.Location = new System.Drawing.Point(242, 62);
            this.labelProxyPort.Name = "labelProxyPort";
            this.labelProxyPort.Size = new System.Drawing.Size(48, 16);
            this.labelProxyPort.TabIndex = 2;
            this.labelProxyPort.Text = "ポート";
            // 
            // labelProxyAddress
            // 
            this.labelProxyAddress.Enabled = false;
            this.labelProxyAddress.Location = new System.Drawing.Point(14, 62);
            this.labelProxyAddress.Name = "labelProxyAddress";
            this.labelProxyAddress.Size = new System.Drawing.Size(48, 16);
            this.labelProxyAddress.TabIndex = 1;
            this.labelProxyAddress.Text = "アドレス";
            // 
            // tabPageChart
            // 
            this.tabPageChart.Controls.Add(this.useDifferentChart);
            this.tabPageChart.Controls.Add(this.drawLastWeek);
            this.tabPageChart.Controls.Add(this.groupBoxChartColor);
            this.tabPageChart.Controls.Add(this.numericUpDownChartNum);
            this.tabPageChart.Controls.Add(this.labelChartNum);
            this.tabPageChart.Location = new System.Drawing.Point(4, 22);
            this.tabPageChart.Name = "tabPageChart";
            this.tabPageChart.Size = new System.Drawing.Size(368, 249);
            this.tabPageChart.TabIndex = 0;
            this.tabPageChart.Text = "チャート";
            // 
            // useDifferentChart
            // 
            this.useDifferentChart.Location = new System.Drawing.Point(32, 80);
            this.useDifferentChart.Name = "useDifferentChart";
            this.useDifferentChart.Size = new System.Drawing.Size(220, 24);
            this.useDifferentChart.TabIndex = 5;
            this.useDifferentChart.Text = "週足と日足で異なるチャートを使用する";
            // 
            // drawLastWeek
            // 
            this.drawLastWeek.Location = new System.Drawing.Point(32, 56);
            this.drawLastWeek.Name = "drawLastWeek";
            this.drawLastWeek.Size = new System.Drawing.Size(172, 24);
            this.drawLastWeek.TabIndex = 4;
            this.drawLastWeek.Text = "週の途中で週足を描画する";
            // 
            // groupBoxChartColor
            // 
            this.groupBoxChartColor.Controls.Add(this.buttonChartForeColor);
            this.groupBoxChartColor.Controls.Add(this.buttonChartBackColor);
            this.groupBoxChartColor.Controls.Add(this.labelChartForeColor);
            this.groupBoxChartColor.Controls.Add(this.labelChartBackColor);
            this.groupBoxChartColor.Location = new System.Drawing.Point(28, 124);
            this.groupBoxChartColor.Name = "groupBoxChartColor";
            this.groupBoxChartColor.Size = new System.Drawing.Size(316, 100);
            this.groupBoxChartColor.TabIndex = 2;
            this.groupBoxChartColor.TabStop = false;
            this.groupBoxChartColor.Text = "配色";
            // 
            // buttonChartForeColor
            // 
            this.buttonChartForeColor.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
            this.buttonChartForeColor.Location = new System.Drawing.Point(80, 56);
            this.buttonChartForeColor.Name = "buttonChartForeColor";
            this.buttonChartForeColor.Size = new System.Drawing.Size(75, 20);
            this.buttonChartForeColor.TabIndex = 3;
            this.buttonChartForeColor.Click += new System.EventHandler(this.buttonChartForeColor_Click);
            // 
            // buttonChartBackColor
            // 
            this.buttonChartBackColor.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
            this.buttonChartBackColor.Location = new System.Drawing.Point(80, 28);
            this.buttonChartBackColor.Name = "buttonChartBackColor";
            this.buttonChartBackColor.Size = new System.Drawing.Size(75, 20);
            this.buttonChartBackColor.TabIndex = 2;
            this.buttonChartBackColor.Click += new System.EventHandler(this.buttonChartBackColor_Click);
            // 
            // labelChartForeColor
            // 
            this.labelChartForeColor.Location = new System.Drawing.Point(24, 60);
            this.labelChartForeColor.Name = "labelChartForeColor";
            this.labelChartForeColor.Size = new System.Drawing.Size(48, 16);
            this.labelChartForeColor.TabIndex = 1;
            this.labelChartForeColor.Text = "前景色";
            // 
            // labelChartBackColor
            // 
            this.labelChartBackColor.Location = new System.Drawing.Point(24, 32);
            this.labelChartBackColor.Name = "labelChartBackColor";
            this.labelChartBackColor.Size = new System.Drawing.Size(48, 16);
            this.labelChartBackColor.TabIndex = 0;
            this.labelChartBackColor.Text = "背景色";
            // 
            // numericUpDownChartNum
            // 
            this.numericUpDownChartNum.Location = new System.Drawing.Point(116, 24);
            this.numericUpDownChartNum.Maximum = new decimal(new int[] {
            6,
            0,
            0,
            0});
            this.numericUpDownChartNum.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.numericUpDownChartNum.Name = "numericUpDownChartNum";
            this.numericUpDownChartNum.Size = new System.Drawing.Size(56, 19);
            this.numericUpDownChartNum.TabIndex = 1;
            this.numericUpDownChartNum.Value = new decimal(new int[] {
            1,
            0,
            0,
            0});
            // 
            // labelChartNum
            // 
            this.labelChartNum.Location = new System.Drawing.Point(28, 28);
            this.labelChartNum.Name = "labelChartNum";
            this.labelChartNum.Size = new System.Drawing.Size(84, 16);
            this.labelChartNum.TabIndex = 0;
            this.labelChartNum.Text = "チャートの個数";
            // 
            // buttonOk
            // 
            this.buttonOk.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.buttonOk.Location = new System.Drawing.Point(226, 284);
            this.buttonOk.Name = "buttonOk";
            this.buttonOk.Size = new System.Drawing.Size(75, 23);
            this.buttonOk.TabIndex = 1;
            this.buttonOk.Text = "OK";
            this.buttonOk.Click += new System.EventHandler(this.buttonOk_Click);
            // 
            // buttonCancel
            // 
            this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.buttonCancel.Location = new System.Drawing.Point(307, 284);
            this.buttonCancel.Name = "buttonCancel";
            this.buttonCancel.Size = new System.Drawing.Size(75, 23);
            this.buttonCancel.TabIndex = 2;
            this.buttonCancel.Text = "キャンセル";
            // 
            // OptionDialog
            // 
            this.AcceptButton = this.buttonOk;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
            this.CancelButton = this.buttonCancel;
            this.ClientSize = new System.Drawing.Size(394, 319);
            this.ControlBox = false;
            this.Controls.Add(this.buttonCancel);
            this.Controls.Add(this.buttonOk);
            this.Controls.Add(this.tabControl);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "OptionDialog";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "オプション";
            this.tabControl.ResumeLayout(false);
            this.tabPageUpload.ResumeLayout(false);
            this.groupBoxProxy.ResumeLayout(false);
            this.groupBoxProxy.PerformLayout();
            this.tabPageChart.ResumeLayout(false);
            this.groupBoxChartColor.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.numericUpDownChartNum)).EndInit();
            this.ResumeLayout(false);

		}
		#endregion

		private void comboBoxPriceDataSource_SelectedIndexChanged(object sender, System.EventArgs e)
		{
            var dataSource = (PriceDataSource)this.comboBoxPriceDataSource.SelectedIndex;
            labelDataSourceInfo.Text = PriceDataUpdator.GetDescription(dataSource);
		}

		private void buttonChartBackColor_Click(object sender, System.EventArgs e)
		{
			using (var dialog = new ColorDialog())
            {
                dialog.CustomColors = new int[] { ColorTranslator.ToWin32(Color.FromKnownColor(KnownColor.Control)) };
			    var result = dialog.ShowDialog(this);
			    if(result == DialogResult.OK)
				    buttonChartBackColor.BackColor = dialog.Color;
			}
		}

		private void buttonChartForeColor_Click(object sender, System.EventArgs e)
		{
			using (var dialog = new ColorDialog())
            {
			    var result = dialog.ShowDialog(this);
			    if(result == DialogResult.OK)
    				this.buttonChartForeColor.BackColor = dialog.Color;
			}
		}

        private void radioButtonOriginalProxy_CheckedChanged(object sender, EventArgs e)
        {
            Boolean enabled = radioButtonOriginalProxy.Checked;
            labelProxyAddress.Enabled = enabled;
            labelProxyPort.Enabled = enabled;
            textBoxProxyAddress.Enabled = enabled;
            textBoxProxyPort.Enabled = enabled;
        }

        private void buttonOk_Click(object sender, EventArgs e)
        {
            // Protraに関する設定を更新する。
            var p = GlobalEnv.ProtraConfig;
            p.ChartNum = (int)numericUpDownChartNum.Value;
            p.ChartForeColor = buttonChartForeColor.BackColor.ToArgb();
            p.ChartBackColor = buttonChartBackColor.BackColor.ToArgb();
            p.DrawLastWeek = drawLastWeek.Checked;
            p.UseDifferentChart = useDifferentChart.Checked;
            
            // データ更新に関する設定を更新する。
            var u = GlobalEnv.UpdateConfig;
            u.PriceDataSource = (PriceDataSource)comboBoxPriceDataSource.SelectedIndex;
            u.UseProxy = radioButtonOriginalProxy.Checked;
            u.ProxyAddress = textBoxProxyAddress.Text;
            try
            {
                u.ProxyPort = -1;
                u.ProxyPort = int.Parse(textBoxProxyPort.Text);
            }
            catch
            { }
            u.Save();
        }
	}
}
