﻿// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008, 2010, 2013 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Resource.cs 474 2013-06-28 04:03:17Z panacoran $

using System.Collections.Generic;
using Protra.Lib.Lang.Builtins;

namespace Protra.Lib.Lang
{
    /// <summary>
    /// プログラムを実行するのに必要なリソースを保持するクラス。
    /// </summary>
    public class Resource
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public Resource()
        {
            Stack = new Stack<Dictionary<string, Value>>();
            FunctionTable = new Dictionary<FunctionType, FunctionDefinitionNode>();
            GlobalVariableTable = new Dictionary<string, Value>();
        }

        /// <summary>
        /// 記号表のスタックを取得または設定する。
        /// </summary>
        public Stack<Dictionary<string, Value>> Stack { get; private set; }

        /// <summary>
        /// 関数のテーブルを取得または設定する。
        /// </summary>
        public Dictionary<FunctionType, FunctionDefinitionNode> FunctionTable { get; private set; }

        /// <summary>
        /// グローバル変数のテーブルを取得または設定する。
        /// </summary>
        public Dictionary<string, Value> GlobalVariableTable { get; set; }

        /// <summary>
        /// 組み込み関数の実装を取得または設定する。
        /// </summary>
        public BasicBuiltins Builtins { get; set; }

        /// <summary>
        /// returnの返値を取得または設定する。
        /// </summary>
        public Value ReturnValue { get; set; }

        /// <summary>
        /// return/break/continueに対応する字句を取得または設定する。
        /// </summary>
        public Token Token { get; set; }

        /// <summary>
        /// マジックコメントのDictionaryを取得または設定する。
        /// </summary>
        public Dictionary<string, string> MagicComment { get; set; }
    }
}