// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004, 2005, 2007 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Connection.cs 283 2010-03-05 22:15:12Z panacoran $

using System;
using System.Collections;
using System.Data;
using System.Data.OleDb;
using System.IO;
using System.Windows.Forms;
using Protra.Lib.Dialogs;

namespace Protra.Lib.Db
{
	/// <summary>
	/// R[hIuWFNgɕϊ郁\bh`B
	/// </summary>
	public interface IRecord
	{
		/// <summary>
		/// f[^x[X̃R[hIuWFNgɕϊB
		/// </summary>
		/// <param name="record">lCeBu`̒l̔z</param>
		/// <returns>ϊ̃IuWFNgԂB</returns>
		Object ToObject(Object[] record);
	}

	/// <summary>
	/// OLE DBoRAccessf[^x[X𑀍삷NXB
	/// DBւ̐ڑvZXŜŋLB
	/// </summary>
	public class Connection
	{
		private bool throwException;

		/// <summary>
		/// O𓊂邩ǂݒ肷B
		/// </summary>
		public bool ThrowException
		{
			set { throwException = value; }
		}

		/// <summary>
		/// OleDbError̓e\B
		/// </summary>
		/// <param name="e">OleDbExceptioñCX^XB</param>
		/// <param name="desc">G[̌̋LqB</param>
		public void ShowOleDbError(OleDbException e, string desc)
		{
			if (throwException)
				throw e;
			string msg = "f[^x[X̃ANZXŃG[܂:\n";
			if (desc != null)
				msg += desc + "\n";
			for (int i = 0; i < e.Errors.Count; i++)
			{
				msg += "Index #" + i + "\n" +
					"Message: " + e.Errors[i].Message + "\n" +
					"NativeError: " + e.Errors[i].NativeError + "\n" +
					"Source: " + e.Errors[i].Source + "\n" +
					"SQLState: " + e.Errors[i].SQLState;
			}
            using (var dialog = new ApplicationError())
            {
                dialog.ErrorMessage = msg;
                dialog.Mode = ApplicationError.ErrorType.Fatal;
                dialog.ShowDialog();
            }
            Environment.Exit(1);
		}

		private static Hashtable connPool = new Hashtable();
		private OleDbConnection conn;

		/// <summary>
		/// RXgN^B
		/// </summary>
		public Connection(string dbname)
		{
			lock (typeof(Connection))
			{
				conn = (OleDbConnection)connPool[dbname];
				if (conn != null &&	(conn.State & ConnectionState.Open) != 0)
					return;
				string target = "Provider=Microsoft.JET.OLEDB.4.0;" +
					"data source=" + Path.Combine(Global.DirData, dbname + ".mdb");
				conn = new OleDbConnection(target);
				try
				{
					conn.Open();
				}
				catch (OleDbException e)
				{
					ShowOleDbError(e, target);
				}
				connPool[dbname] = conn;
			}
			
		}

		/// <summary>
		/// NG̎sʂIuWFNg̃XgŕԂB
		/// </summary>
		/// <param name="sql">SQLw肷B</param>
		/// <param name="cvtr">ϊ\bhNX̃CX^Xw肷B</param>
		/// <returns>cvtrɂĕϊꂽIuWFNg̃XgԂB</returns>
		public ArrayList Query(string sql, IRecord cvtr)
		{
			ArrayList list = new ArrayList();
			OleDbCommand comm = new OleDbCommand(sql, conn);
			OleDbDataReader reader = null;
			lock (conn)
			{
				try
				{
					reader = comm.ExecuteReader();
				}
				catch (OleDbException e)
				{
					ShowOleDbError(e, sql);
				}
				try
				{
					while (reader.Read())
					{
						Object[] values = new Object[reader.FieldCount];
						reader.GetValues(values);
						list.Add(cvtr.ToObject(values));
					}
				}
				finally
				{
					reader.Close();
				}
			}
			return list;
		}

		/// <summary>
		/// NǦʂ̍ŏ̃R[h̍ŏ̃tB[hԂB
		/// </summary>
		/// <param name="sql">SQLw肷B</param>
		/// <returns>ŏ̃R[h̍ŏ̃tB[hB</returns>
		public Object QueryScalar(string sql)
		{
			OleDbCommand comm = new OleDbCommand(sql, conn);
			lock (conn)
			{
				try 
				{
					return comm.ExecuteScalar();
				}
				catch (OleDbException e) 
				{
					ShowOleDbError(e, sql);
				}
				return null;
			}
		}

		/// <summary>
		/// SQLsĉe󂯂s̐ԂB
		/// </summary>
		/// <param name="sql">SQLw肷B</param>
		/// <returns>e󂯂s̐ԂB</returns>
		public int Execute(string sql)
		{
			OleDbCommand comm = new OleDbCommand(sql, conn);
			lock (conn)
			{
				try
				{
					return  comm.ExecuteNonQuery();
				}
				catch (OleDbException e)
				{
					ShowOleDbError(e, sql);
				}
				return 0;
			}
		}

		/// <summary>
		/// f[^x[Xւ̐ڑB
		/// </summary>
		public void Close()
		{
			conn.Close();
		}
	}
}
