// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004-2007 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Brand.cs,v 1.16 2008-08-09 07:07:38 panacoran Exp $

using System;
using System.Collections;
using System.Globalization;

namespace Protra.Lib.Db
{
	/// <summary>
	/// Brande[ũR[h\B
	/// </summary>
	public class Brand: IRecord, IComparable
	{
		private int id;
		private int code;
		private MarketId marketId;
		private string name;

		/// <summary>
		/// ̃RXgN^
		/// </summary>
		public Brand() {}

		/// <summary>
		/// RXgN^
		/// </summary>
		public Brand(int id, int code, MarketId marketId, string name)
		{
			this.id = id;
			this.code = code;
			this.marketId = marketId;
			this.name = name;
		}

		/// <summary>
		/// ID擾B
		/// </summary>
		public int Id
		{
			get { return id; }
		}

		/// <summary>
		/// R[h擾B
		/// </summary>
		public int Code
		{
			get { return code; }
		}

		/// <summary>
		/// sID擾B
		/// </summary>
		public MarketId MarketId
		{
			get { return marketId; }
		}

		/// <summary>
		/// sIDɑΉMarketIuWFNg擾B
		/// </summary>
		public Market Market
		{
			get { return MarketTable.GetRecord(marketId); }
		}

		/// <summary>
		/// 擾邢͕ύXB
		/// </summary>
		public string Name
		{
			get { return name; }
			set { 
				BrandTable.ChangeBrandName(id, value);
				name = value;
			}
		}

		/// <summary>
		/// f[^x[X̃R[hIuWFNgɕϊB
		/// </summary>
		/// <param name="values">lCeBu`̒l̔z</param>
		/// <returns>ϊBrandIuWFNgԂB</returns>
		public Object ToObject(Object[] values)
		{
			return new Brand((int)values[0], // @Id
				(int)values[1], // @Code
				(MarketId)values[2], // @MarketId
				(string)values[3]); // @Name
		}

		/// <summary>
		/// CX^X𕶎\ɕϊB
		/// </summary>
		/// <returns>\</returns>
		public override string ToString()
		{
			return string.Format(
				"Brand[Id={0}, Code={1}, MarketId={2}, Name={3}]",
				id, code, marketId, name);
		}

		#region IComparable o
		/// <summary>
		/// w肳ꂽIuWFNgƎrB
		/// </summary>
		/// <param name="obj">rΏۂ̃IuWFNg</param>
		/// <returns>0菬ȒlA傫0傫ȒlA0ԂB</returns>
		public int CompareTo(object obj)
		{
			Brand brand = (Brand)obj;
			if (code == brand.Code)
				return marketId - brand.MarketId;
			return code - brand.Code;
		}
		#endregion
	}

	/// <summary>
	/// Brande[u𑀍삷B
	/// ̃NX͍ŏɂׂẴR[hArrayListɓǂݍށB
	/// ꕔ̃\bhArrayList̃CfbNX+1R[h@Idƈv邱Ƃ肵ĂB
	/// Brande[uspӂɕҏWƂ̉肪̂ŗvӁB
	/// </summary>
	public class BrandTable
	{
		private static ArrayList byId;
		private static SortedList[] byMarketId;

		private static Connection conn;
		private static Connection Conn
		{
			get 
			{
				if (conn != null)
					return conn;
				conn = new Connection("protra");
				return conn;
			}
		}

		/// <summary>
		/// ׂẴR[hێArrayList擾B
		/// </summary>
		private static ArrayList ById
		{
			get {
				if (byId != null)
					return byId;

				string sql = "SELECT * FROM Brand ORDER BY @Id";
				byId = Conn.Query(sql, new Brand());
				return byId;
			}
		}

		/// <summary>
		/// ׂẴR[hێz擾B
		/// ̔z͎sIDԖڂɁAR[hƃR[hΉtSortedListێB
		/// </summary>
		private static SortedList[] ByMarketId
		{
			get {
				if (byMarketId != null)
					return byMarketId;

				byMarketId = new SortedList[(int)MarketId.Max];
				for (int i = 0; i < (int)MarketId.Max; i++)
					byMarketId[i] = new SortedList();
				foreach (Brand brand in ById)
				{
					SortedList byCode = byMarketId[(int)brand.MarketId - 1];
					byCode[brand.Code] = brand;
				}
				return byMarketId;
			}
		}

		// ǂ

		/// <summary>
		/// w肳ꂽID̃R[h擾B
		/// </summary>
		/// <param name="id">ID</param>
		/// <returns>BrandIuWFNgԂB</returns>
		//
		public static Brand GetRecord(int id) 
		{
            try
            {
                return (Brand)ById[id - 1];
            }
            catch (ArgumentOutOfRangeException)
            {
                return null;
            }
		}

		/// <summary>
		/// w肳ꂽsIDƖR[h̃R[h擾B
		/// </summary>
		/// <param name="marketId">sID</param>
		/// <param name="code">R[h</param>
		/// <returns>BrandIuWFNgԂBR[h݂ȂꍇɂnullԂB</returns>
		public static Brand GetRecord(MarketId marketId, int code)
		{
            try
            {
                return (Brand)ByMarketId[(int)marketId - 1][code];
            }
            catch (ArgumentOutOfRangeException)
            {
                return null;
            }
		}

		/// <summary>
		/// w肳ꂽsׂ̖Ď擾B
		/// </summary>
		/// <param name="marketId">sID</param>
		/// <returns>BrandIuWFNg̔zB</returns>
		public static Brand[] GetRecords(MarketId marketId)
		{
			SortedList byCode = ByMarketId[(int)marketId - 1];
			Brand[] result = new Brand[byCode.Count];
			byCode.Values.CopyTo(result, 0);
			return result;
		}

		/// <summary>
		/// w肳ꂽR[hR[hׂĎ擾B
		/// </summary>
		/// <param name="code"></param>
		/// <returns></returns>
		public static Brand[] GetRecords(int code)
		{
			ArrayList result = new ArrayList();
			foreach (SortedList byCode in ByMarketId)
				if (byCode[code] != null)
					result.Add(byCode[code]);
			return (Brand[])result.ToArray(typeof(Brand));
		}

		/// <summary>
		/// w肳ꂽɊ܂ރR[hׂĎ擾B
		/// </summary>
		/// <param name="name">镶</param>
		/// <returns>BrandIuWFNg̔z</returns>
		public static Brand[] GetRecords(string name)
		{
			ArrayList result = new ArrayList();
			CompareInfo comp = CompareInfo.GetCompareInfo("ja-JP");
			foreach (SortedList byCode in ByMarketId)
				foreach (Brand brand in byCode.Values)
					if (comp.IndexOf(brand.Name, name,
							CompareOptions.IgnoreCase |	CompareOptions.IgnoreWidth) != -1)
						result.Add(brand);
			result.Sort();
			return (Brand[])result.ToArray(typeof(Brand));
		}

		/// <summary>
		/// w肳ꂽs̎w͈̖͂R[h̃R[h擾B
		/// </summary>
		/// <param name="marketId">sID</param>
		/// <param name="minCode">R[h̍ŏl</param>
		/// <param name="maxCode">R[h̍ől</param>
		/// <returns>BrandIuWFNg̔z</returns>
		public static Brand[] GetRecords(MarketId marketId, int minCode, int maxCode)
		{
			ArrayList result = new ArrayList();
			foreach (Brand brand in ByMarketId[(int)marketId - 1].Values)
				if (brand.Code >= minCode && brand.Code <= maxCode)
					result.Add(brand);
			return (Brand[])result.ToArray(typeof(Brand));
		}

		/// <summary>
		/// ID̍ől擾B
		/// </summary>
		public static int MaxId
		{
			get { return ById.Count; }
		}

		// 

		/// <summary>
		/// sIDƖR[hɑΉ郌R[h擾ƓɁA
		/// <code>name</code>ƈقȂꍇɂ͕ύXB
		/// R[h݂Ȃꍇɂ͍쐬B
		/// </summary>
		/// <param name="marketId">sID</param>
		/// <param name="code">R[h</param>
		/// <param name="name"></param>
		/// <returns>ǉR[hBrandIuWFNgB</returns>
		public static Brand GetRecordOrCreate(MarketId marketId, int code, string name)
		{
			Brand record = GetRecord(marketId, code);
			if (record != null)
			{
				if (record.Name != name)
					record.Name = name;
				return record;
			}
			string sql = string.Format(
				"INSERT INTO Brand(@Code, @MarketId, @Name) " +
				"VALUES({0}, {1}, '{2}')", code, (int)marketId, name);
			Conn.Execute(sql);
			record = new Brand(ById.Count + 1, code, marketId, name);
			ById.Add(record);
			ByMarketId[(int)marketId - 1][code] = record;
			return record;
		}

		/// <summary>
		/// ύXB
		/// </summary>
		/// <param name="id">ID</param>
		/// <param name="name">VO</param>
		public static void ChangeBrandName(int id, string name)
		{
			string sql = string.Format(
				"UPDATE Brand SET @Name='{0}' WHERE @Id={1}", name, id);
			Conn.Execute(sql);
		}

		/// <summary>
		/// Sf[^폜B
		/// </summary>
		public static void Delete()
		{
			string sql = "DELETE FROM Brand";
			Conn.Execute(sql);
			byId = null;
			byMarketId = null;
		}
	}
}
