﻿// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004, 2005, 2007, 2008, 2010, 2014 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: OptionDialog.cs 503 2014-02-10 06:10:07Z panacoran $

using System;
using System.Drawing;
using System.Windows.Forms;
using Protra.Lib;
using Protra.Lib.Update;

namespace Protra.Dialogs
{
    /// <summary>
    /// オプションを設定するダイアログ
    /// </summary>
    public partial class OptionDialog : Form
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public OptionDialog()
        {
            InitializeComponent();

            // データソースの選択肢を設定する。
// ReSharper disable once CoVariantArrayConversion
            comboBoxDataSource.Items.AddRange(PriceDataUpdator.DataSourceNames);

            // Protraに関する設定を反映させる。
            var protra = GlobalEnv.ProtraConfig;
            numericUpDownChartNum.Value = protra.ChartNum;
            buttonChartForeColor.BackColor = Color.FromArgb(protra.ChartForeColor);
            buttonChartBackColor.BackColor = Color.FromArgb(protra.ChartBackColor);
            checkBoxDrawLastWeek.Checked = protra.DrawLastWeek;
            checkBoxUseDifferentChart.Checked = protra.UseDifferentChart;

            // データ更新に関する設定を反映させる。
            var update = GlobalEnv.UpdateConfig;
            comboBoxDataSource.SelectedIndex = (int)update.PriceDataSource;
            radioButtonProxyCustom.Checked = update.UseProxy;
            textBoxProxyAddress.Text = update.ProxyAddress;
            if (update.ProxyPort > 0)
                textBoxProxyPort.Text = update.ProxyPort.ToString();
        }

        private void comboBoxDataSource_SelectedIndexChanged(object sender, EventArgs e)
        {
            var dataSource = (PriceDataSource)comboBoxDataSource.SelectedIndex;
            textBoxDataSource.Text = PriceDataUpdator.GetDescription(dataSource);
        }

        private void buttonBackColor_Click(object sender, EventArgs e)
        {
            using (new CenteredDialogHelper())
            using (var dialog = new ColorDialog())
            {
                dialog.CustomColors = new[] {ColorTranslator.ToWin32(Color.FromKnownColor(KnownColor.Control))};
                var result = dialog.ShowDialog(this);
                if (result == DialogResult.OK)
                    buttonChartBackColor.BackColor = dialog.Color;
            }
        }

        private void buttonForeColor_Click(object sender, EventArgs e)
        {
            using (new CenteredDialogHelper())
            using (var dialog = new ColorDialog())
            {
                var result = dialog.ShowDialog(this);
                if (result == DialogResult.OK)
                    buttonChartForeColor.BackColor = dialog.Color;
            }
        }

        private void radioButtonProxyCustom_CheckedChanged(object sender, EventArgs e)
        {
            var enabled = radioButtonProxyCustom.Checked;
            labelProxyAddress.Enabled = enabled;
            labelProxyPort.Enabled = enabled;
            textBoxProxyAddress.Enabled = enabled;
            textBoxProxyPort.Enabled = enabled;
        }

        private void buttonOk_Click(object sender, EventArgs e)
        {
            // Protraに関する設定を更新する。
            var protra = GlobalEnv.ProtraConfig;
            protra.ChartNum = (int)numericUpDownChartNum.Value;
            protra.ChartForeColor = buttonChartForeColor.BackColor.ToArgb();
            protra.ChartBackColor = buttonChartBackColor.BackColor.ToArgb();
            protra.DrawLastWeek = checkBoxDrawLastWeek.Checked;
            protra.UseDifferentChart = checkBoxUseDifferentChart.Checked;

            // データ更新に関する設定を更新する。
            var update = GlobalEnv.UpdateConfig;
            update.PriceDataSource = (PriceDataSource)comboBoxDataSource.SelectedIndex;
            update.UseProxy = radioButtonProxyCustom.Checked;
            update.ProxyAddress = textBoxProxyAddress.Text;
            try
            {
                update.ProxyPort = -1;
                update.ProxyPort = int.Parse(textBoxProxyPort.Text);
            }
            catch (FormatException)
            {
            }
            update.Save();
        }
    }
}